/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util;

import java.nio.ByteOrder;
import org.javaseis.io.Seisio;
import org.javaseis.io.SeisioVoxet;
import org.javaseis.util.SeisException;

public class CopyVoxetToJavaSeis {
    protected SeisioVoxet svp;
    protected Seisio sio;
    protected long[] lengths;
    protected String voxPath;
    protected String jsPath;

    public CopyVoxetToJavaSeis(String vpath, String jpath) throws SeisException {
        this.voxPath = vpath.toString();
        this.jsPath = jpath.toString();
        try {
            this.svp = new SeisioVoxet(this.voxPath);
            this.svp.open("r");
        }
        catch (SeisException e) {
            throw new SeisException("Could not open " + this.voxPath + "\n" + e.getMessage() + "\n");
        }
        this.lengths = this.svp.getGridDefinition().getAxisLengths();
        try {
            this.sio = new Seisio(this.jsPath, 3, new int[]{(int)this.lengths[0], (int)this.lengths[1], (int)this.lengths[2]}, ByteOrder.nativeOrder());
            this.sio.create();
        }
        catch (SeisException e) {
            throw new SeisException("Could not create " + this.jsPath + "\n" + e.getMessage() + "\n");
        }
    }

    public int copy() throws SeisException {
        int[] position = new int[4];
        position[3] = 0;
        position[2] = 0;
        int ifrm = 0;
        while ((long)ifrm < this.lengths[2]) {
            position[2] = ifrm++;
            int numTraces = this.svp.readFrame(position);
            this.sio.writeFrame(position, numTraces);
        }
        return (int)this.lengths[2];
    }

    public void close() throws SeisException {
        this.sio.close();
        this.svp.close();
    }

    public static void main(String[] args) throws SeisException {
        if (args.length < 2) {
            throw new SeisException("Number of arguments must be 2 ");
        }
        CopyVoxetToJavaSeis cvp = new CopyVoxetToJavaSeis(args[0], args[1]);
        cvp.copy();
        cvp.close();
        System.out.format("CopyVoxetToJavaSeis for %s to %s complete\n", cvp.voxPath, cvp.jsPath);
    }
}

