/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.io.File;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualFoldersSimple;
import org.javaseis.tests.SynthDataset4D;
import org.javaseis.tests.SyntheticDataset3D;
import org.javaseis.util.SeisException;

public class TestUtil {
    public static final String CONTAINER = "javaseis-tests";
    public static final String DATASETS_FOLDER = "datasets";
    public static final String SCRATCH_FOLDER = "scratch";
    public static final String SECONDARY_FOLDER = "secondary";
    public static final String[] VIRTUAL_FOLDERS = new String[]{"0", "1", "2", "3"};
    public static final String REFERENCE_DATASET = "ReferenceDataset.js";
    public static final String REFERENCE_DATASET_V = "ReferenceDatasetV.js";

    public static String getDatasetContainer() throws SeisException {
        return TestUtil.getFolder(DATASETS_FOLDER);
    }

    public static String getVirtualContainer() throws SeisException {
        return TestUtil.getFolder(SECONDARY_FOLDER);
    }

    public static String getDatasetPath(String name) throws SeisException {
        return TestUtil.getFolder(DATASETS_FOLDER + File.separator + name);
    }

    public static String getDatasetPath(String name, String area, String line) throws SeisException {
        return TestUtil.getFolder(DATASETS_FOLDER + File.separator + area + File.separator + line + File.separator + name);
    }

    public static String getScratchFolder() throws SeisException {
        return TestUtil.getFolder(SCRATCH_FOLDER);
    }

    public static String getScratchPath(String path) throws SeisException {
        return TestUtil.getFolder(SCRATCH_FOLDER + File.separator + path);
    }

    public static String[] getVirtualFolders() throws SeisException {
        String[] folders = new String[VIRTUAL_FOLDERS.length];
        for (int i = 0; i < VIRTUAL_FOLDERS.length; ++i) {
            folders[i] = TestUtil.getFolder(SECONDARY_FOLDER + File.separator + VIRTUAL_FOLDERS[i]);
        }
        return folders;
    }

    public static VirtualFolders getVirtualFolders(String path) throws SeisException {
        String[] folders = new String[VIRTUAL_FOLDERS.length];
        String name = new File(path).getName();
        for (int i = 0; i < VIRTUAL_FOLDERS.length; ++i) {
            folders[i] = TestUtil.getFolder(SECONDARY_FOLDER + File.separator + VIRTUAL_FOLDERS[i] + File.separator + name);
        }
        return new VirtualFoldersSimple(path, folders, new ExtentPolicyRandom());
    }

    public static VirtualFolders getVirtualFolders(String path, String areaName, String lineName) throws SeisException {
        String[] folders = new String[VIRTUAL_FOLDERS.length];
        String name = new File(path).getName();
        for (int i = 0; i < VIRTUAL_FOLDERS.length; ++i) {
            folders[i] = TestUtil.getFolder(SECONDARY_FOLDER + File.separator + VIRTUAL_FOLDERS[i] + File.separator + areaName + File.separator + lineName + File.separator + name);
        }
        return new VirtualFoldersSimple(path, folders, new ExtentPolicyRandom());
    }

    public static String getFolder(String folder) throws SeisException {
        File f = new File(System.getProperty("user.home") + File.separator + CONTAINER + File.separator + folder);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new SeisException(f.getAbsolutePath() + " doesn't exist and can't be created");
            }
            if (!f.isDirectory()) {
                throw new SeisException(f.getAbsolutePath() + " exists but is not a folder");
            }
        }
        return f.getAbsolutePath();
    }

    public static Seisio getReferenceDataset(DSType type) throws Exception {
        String path = TestUtil.getDatasetPath(REFERENCE_DATASET);
        Seisio seisio = null;
        if (Seisio.isJavaSeis(path)) {
            Seisio.delete(path);
        }
        if (type == DSType.CMP) {
            SynthDataset4D ds = new SynthDataset4D(path);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        } else if (type == DSType.STACKED4D) {
            SynthDataset4D ds = new SynthDataset4D(path, 1, 21, 11);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        } else if (type == DSType.STACKED3D) {
            SyntheticDataset3D ds = new SyntheticDataset3D(path);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        }
        return seisio;
    }

    public static Seisio getReferenceDataset(DSType type, int numExtents, ExtentPolicy policy) throws Exception {
        String path = TestUtil.getDatasetPath(REFERENCE_DATASET_V);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(path);
        Seisio seisio = null;
        if (Seisio.isJavaSeis(path)) {
            Seisio.delete(path);
        }
        if (type == DSType.CMP || type == DSType.STACKED4D) {
            SynthDataset4D ds = new SynthDataset4D(path, vFolders, numExtents, policy);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        } else if (type == DSType.STACKED4D) {
            SynthDataset4D ds = new SynthDataset4D(path, 1, 21, 11, vFolders, numExtents, policy);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        } else if (type == DSType.STACKED3D) {
            SyntheticDataset3D ds = new SyntheticDataset3D(path, vFolders, numExtents, policy);
            seisio = ds.create();
            seisio.open("rw");
            ds.writeAllData();
        }
        return seisio;
    }

    public static enum DSType {
        CMP,
        STACKED4D,
        STACKED3D;

    }
}

