/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import org.javaseis.grid.GridDefinition;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFolders;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.properties.Units;
import org.javaseis.util.SeisException;

class SynthDataset4D {
    protected Seisio _seisio;
    protected int _numDimensions = 4;
    protected int _numSamples = 251;
    protected int _numHeaderProps = 5;
    protected DataType _dataType = DataType.CMP;
    protected DataFormat _traceFormat = DataFormat.FLOAT;
    protected int _numTraces;
    protected int _numFrames;
    protected int _numVolumes;
    protected AxisDefinition[] _axes = new AxisDefinition[this._numDimensions];
    protected GridDefinition _gridDef;
    protected DataDefinition _dataDef;
    protected String[] _presidents = new String[]{"George Washington", "Thomas Jefferson", "Abe Lincoln", "Teddy Roosevelt"};
    protected PropertyDescription[] _headerProps;
    protected TraceProperties _headerDef;
    protected int _numExtents;
    protected VirtualFolders _vFolders;
    private ExtentPolicy _policy;

    public SynthDataset4D(String path) throws SeisException {
        this(path, 50, 21, 11);
    }

    public SynthDataset4D(String path, int numTraces, int numFrames, int numVolumes) throws SeisException {
        this._numTraces = numTraces;
        this._numFrames = numFrames;
        this._numVolumes = numVolumes;
        this.init();
        this._seisio = new Seisio(path, this._gridDef, this._dataDef, this._headerDef);
    }

    public SynthDataset4D(String path, VirtualFolders vFolders, int numExtents, ExtentPolicy policy) throws SeisException {
        this(path, 50, 21, 11, vFolders, numExtents, policy);
    }

    public SynthDataset4D(String path, VirtualFolders vFolders) throws SeisException {
        this._seisio = new Seisio(path);
    }

    public SynthDataset4D(String path, int numTraces, int numFrames, int numVolumes, VirtualFolders vFolders, int numExtents, ExtentPolicy policy) throws SeisException {
        this._numTraces = numTraces;
        this._numFrames = numFrames;
        this._numVolumes = numVolumes;
        this._numExtents = numExtents;
        this._vFolders = vFolders;
        this._policy = policy;
        this.init();
        this._seisio = new Seisio(path, this._gridDef, this._dataDef, this._headerDef);
    }

    public Seisio create() throws SeisException {
        this._seisio.setMapped();
        if (this._vFolders == null) {
            this._seisio.create();
        } else {
            this._seisio.create(this._vFolders, this._numExtents);
        }
        return this._seisio;
    }

    public Seisio open(String mode) throws SeisException {
        this._seisio.open(mode);
        GridDefinition gridDef = this._seisio.getGridDefinition();
        this._numTraces = (int)gridDef.getNumTracesPerFrame();
        this._numFrames = (int)gridDef.getNumFramesPerVolume();
        this._numVolumes = (int)gridDef.getNumVolumesPerHypercube();
        this.init();
        return this._seisio;
    }

    public void writeAllData() throws SeisException {
        this.writeData(0, this._numFrames, 0, this._numVolumes);
    }

    public void writeData(int fStart, int fStop, int vStart, int vStop) throws SeisException {
        assert (fStart >= 0);
        assert (fStop <= this._numFrames);
        assert (vStart >= 0);
        assert (vStop <= this._numVolumes);
        float[][] origTraceData = this._seisio.getTraceDataArray();
        double pi = Math.PI;
        double omega1 = pi / (double)(this._numSamples - 1);
        for (int i = 0; i < this._numTraces; ++i) {
            double omega2 = (double)(i + 10) * omega1;
            for (int j = 0; j < this._numSamples; ++j) {
                double t = j;
                origTraceData[i][j] = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
            }
        }
        double[] xyz = new double[3];
        double dxy = 0.0;
        int[] origPosition = new int[this._numDimensions];
        origPosition[0] = 0;
        origPosition[1] = 0;
        for (int volumeIndex = vStart; volumeIndex < vStop; ++volumeIndex) {
            origPosition[3] = volumeIndex;
            AxisDefinition volumeAxis = this._gridDef.getAxis(3);
            int iline = (int)(volumeAxis.getLogicalOrigin() + volumeAxis.getLogicalDelta() * (long)volumeIndex);
            double xm = volumeAxis.getPhysicalOrigin() + volumeAxis.getPhysicalDelta() * (double)volumeIndex;
            int frameIndex = fStart;
            while (frameIndex < fStop) {
                AxisDefinition frameAxis = this._gridDef.getAxis(2);
                int xline = (int)(frameAxis.getLogicalOrigin() + frameAxis.getLogicalDelta() * (long)frameIndex);
                double ym = frameAxis.getPhysicalOrigin() + frameAxis.getPhysicalDelta() * (double)frameIndex;
                for (int traceIndex = 0; traceIndex < this._numTraces; ++traceIndex) {
                    AxisDefinition traceAxis = this._gridDef.getAxis(1);
                    dxy = traceAxis.getPhysicalOrigin() + traceAxis.getPhysicalDelta() * (double)traceIndex;
                    this._headerDef.setTraceIndex(traceIndex);
                    this._headerDef.putInt("ILINE_NO", iline);
                    this._headerDef.putInt("XLINE_NO", xline);
                    xyz[0] = xm;
                    xyz[1] = ym;
                    xyz[2] = 0.0;
                    this._headerDef.putDoubleArray("SRC_XYZ", xyz);
                    xyz[0] = xm + dxy;
                    xyz[1] = ym - dxy;
                    xyz[2] = 1.0;
                    this._headerDef.putDoubleArray("RECV_XYZ", xyz);
                    int presIndex = traceIndex % this._presidents.length;
                    this._headerDef.putValue("THE_PREZ", this._presidents[presIndex]);
                }
                origPosition[2] = frameIndex++;
                int count = this._seisio.writeFrame(origPosition, this._numTraces);
                if (count == this._numTraces) continue;
                throw new SeisException("Seisio: Error writing to dataset (" + count + " != " + this._numTraces);
            }
        }
    }

    public void readAllData() throws SeisException {
        this.readData(0, this._numFrames, 0, this._numVolumes);
    }

    public void readData(int fStart, int fStop, int vStart, int vStop) throws SeisException {
        assert (fStart >= 0);
        assert (fStop <= this._numFrames);
        assert (vStart >= 0);
        assert (vStop <= this._numVolumes);
        float[][] testTraceData = this._seisio.getTraceDataArray();
        int[] position = new int[this._numDimensions];
        position[0] = 0;
        position[1] = 0;
        for (int volumeIndex = vStart; volumeIndex < vStop; ++volumeIndex) {
            position[3] = volumeIndex;
            int frameIndex = fStart;
            while (frameIndex < fStop) {
                position[2] = frameIndex++;
                int count = this._seisio.readFrame(position);
                if (count == this._numTraces) continue;
                throw new SeisException("Error reading from dataset (" + count + " != " + this._numTraces);
            }
        }
    }

    void init() {
        this._axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MSEC, DataDomain.TIME, this._numSamples, 0L, 4L, 0.0, 4.0);
        this._axes[1] = new AxisDefinition(AxisLabel.OFFSET, Units.FEET, DataDomain.SPACE, this._numTraces, 50L, 50L, 50.0, 50.0);
        this._axes[2] = new AxisDefinition(AxisLabel.CROSSLINE, Units.FEET, DataDomain.SPACE, this._numFrames, 100L, 1L, 1250.0, 12.5);
        this._axes[3] = new AxisDefinition(AxisLabel.INLINE, Units.FEET, DataDomain.SPACE, this._numVolumes, 200L, 2L, 5000.0, 25.0);
        this._gridDef = new GridDefinition(this._numDimensions, this._axes);
        this._dataDef = new DataDefinition(this._dataType, this._traceFormat);
        this._headerProps = new PropertyDescription[this._numHeaderProps];
        this._headerProps[0] = new PropertyDescription("THE_PREZ", "Name of President", 9, 27);
        this._headerProps[1] = new PropertyDescription("ILINE_NO", "Inline #", 3, 1);
        this._headerProps[2] = new PropertyDescription("XLINE_NO", "Crossline #", 3, 1);
        this._headerProps[3] = new PropertyDescription("SRC_XYZ", "Source xyz-coordinates", 6, 3);
        this._headerProps[4] = new PropertyDescription("RECV_XYZ", "Receiver xyz-coordinates", 6, 3);
        this._headerDef = new TraceProperties(this._numHeaderProps, this._headerProps);
    }
}

