/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import edu.mines.jtk.dsp.FftReal;
import junit.framework.TestCase;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;

public class JTestSeisFft
extends TestCase {
    private static int NMAX = 1000;

    public static void main(String[] args) {
        JTestSeisFft test = new JTestSeisFft();
        test.testReal();
        test.testComplex();
        System.out.println("*** org.javaseis.tests.JTestSeisFft SUCCESS");
    }

    private static void debugPause() {
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doRealRoundTrip(int nsamps) {
        SeisFft fft = new SeisFft(nsamps, 0.0f, IFFT.Type.REAL);
        int arrayLen = fft.getArrayLength();
        float[] data = new float[arrayLen];
        for (int i = 0; i < nsamps; ++i) {
            data[i] = 1.0f;
        }
        fft.realToComplex(data);
        fft.complexToReal(data);
    }

    public void doComplexRoundTrip(int nsamps) {
        int i;
        double tolerance = 1.0E-5;
        SeisFft fft = new SeisFft(nsamps, 0.0f, IFFT.Type.COMPLEX);
        int arrayLen = fft.getArrayLength();
        float[] data = new float[arrayLen];
        for (int i2 = 0; i2 < nsamps; ++i2) {
            data[i2] = 1.0f;
        }
        float[] copy = new float[arrayLen];
        for (i = 0; i < copy.length; ++i) {
            copy[i] = data[i];
        }
        fft.complexForward(data);
        fft.complexInverse(data);
        for (i = 0; i < nsamps; ++i) {
            if ((double)Math.abs(copy[i] - data[i]) > tolerance) {
                System.out.println("complex round-trip is out of spec for nsamps = " + nsamps);
            }
            JTestSeisFft.assertEquals((double)copy[i], (double)data[i], (double)tolerance);
        }
    }

    public void testReal() {
        for (int i = 2; i < NMAX; ++i) {
            this.doRealRoundTrip(i);
        }
    }

    public void testComplex() {
        for (int i = 2; i < NMAX; ++i) {
            this.doComplexRoundTrip(i);
        }
    }

    public void testSetFftParms() {
        SeisFft f = new SeisFft();
        f.setFftParms(1024, IFFT.Type.REAL, IFFT.Scale.SYMMETRIC, 50.0f, -1);
        JTestSeisFft.assertEquals((int)FftReal.nfftSmall((int)1536), (int)f.getLength());
    }

    public void testRealToComplexFloatArrayInt() {
        int nt = 1040;
        SeisFft f = new SeisFft(nt, 0.0f, IFFT.Type.REAL, -1, IFFT.Scale.INVERSE);
        int nft = f.getLength();
        JTestSeisFft.assertEquals((int)1040, (int)nft);
        int xoff = 100;
        float[] x = new float[nft + 2 + xoff];
        for (int i = 0; i < nft; ++i) {
            x[i + xoff] = 1.0f;
        }
        f.realToComplex(x, xoff);
        JTestSeisFft.assertEquals((String)"SeisFft.realToComplex failure", (float)x[xoff], (float)nft, (float)0.1f);
        f.complexToReal(x, xoff);
        JTestSeisFft.assertEquals((String)"SeisFft.complexToReal failure", (double)x[xoff], (double)1.0, (double)0.1f);
    }

    public void testComplexForwardFloatArrayInt() {
        int nt = 1040;
        SeisFft f = new SeisFft(nt, 0.0f, IFFT.Type.COMPLEX, 1, IFFT.Scale.SYMMETRIC);
        int nft = f.getLength();
        JTestSeisFft.assertEquals((int)1040, (int)nft);
        int xoff = 100;
        float[] cx = new float[2 * nft + xoff];
        int ix = xoff;
        int iy = ix + 1;
        int i = 0;
        while (i < nft) {
            cx[ix] = i;
            cx[iy] = i;
            ++i;
            ix += 2;
            iy += 2;
        }
        f.complexForward(cx, xoff);
        f.complexInverse(cx, xoff);
        ix = xoff;
        iy = ix + 1;
        i = 0;
        while (i < nft) {
            JTestSeisFft.assertEquals((String)"SeisFft.complexToReal failure", (float)cx[ix], (float)i, (float)0.001f);
            JTestSeisFft.assertEquals((String)"SeisFft.complexToReal failure", (float)cx[iy], (float)i, (float)0.001f);
            ++i;
            ix += 2;
            iy += 2;
        }
    }

    public void testEvenAndOddDC() {
        int i;
        int nsamps = 195;
        SeisFft fft = new SeisFft(nsamps, 0.0f, IFFT.Type.COMPLEX);
        JTestSeisFft.assertEquals((int)nsamps, (int)fft.getLength());
        float[] dataIn = new float[2 * nsamps];
        float[] dataOut = new float[fft.getArrayLength()];
        for (i = 0; i < nsamps; ++i) {
            dataIn[i * 2] = 1.0f;
        }
        fft.complexForward(dataIn, dataOut);
        JTestSeisFft.assertEquals((double)nsamps, (double)dataOut[0], (double)1.0E-5);
        nsamps = 193;
        fft = new SeisFft(nsamps, 0.0f, IFFT.Type.COMPLEX);
        JTestSeisFft.assertEquals((int)195, (int)fft.getLength());
        dataIn = new float[2 * nsamps];
        dataOut = new float[fft.getArrayLength()];
        for (i = 0; i < nsamps; ++i) {
            dataIn[i * 2] = 1.0f;
        }
        fft.complexForward(dataIn, dataOut);
        JTestSeisFft.assertEquals((double)nsamps, (double)dataOut[0], (double)1.0E-5);
        nsamps = 198;
        fft = new SeisFft(nsamps, 0.0f, IFFT.Type.COMPLEX);
        JTestSeisFft.assertEquals((int)198, (int)fft.getLength());
        dataIn = new float[2 * nsamps];
        dataOut = new float[fft.getArrayLength()];
        for (i = 0; i < nsamps; ++i) {
            dataIn[i * 2] = 1.0f;
        }
        fft.complexForward(dataIn, dataOut);
        JTestSeisFft.assertEquals((double)nsamps, (double)dataOut[0], (double)1.0E-5);
        nsamps = 196;
        fft = new SeisFft(nsamps, 0.0f, IFFT.Type.COMPLEX);
        JTestSeisFft.assertEquals((int)198, (int)fft.getLength());
        dataIn = new float[2 * nsamps];
        dataOut = new float[fft.getArrayLength()];
        for (i = 0; i < nsamps; ++i) {
            dataIn[i * 2] = 1.0f;
        }
        fft.complexForward(dataIn, dataOut);
        JTestSeisFft.assertEquals((double)nsamps, (double)dataOut[0], (double)1.0E-5);
    }
}

