/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.javaseis.server.SocketCommands;

public class SocketTestClient {
    private Socket _clientSocket;

    private void init(String host, int port) {
        try {
            this._clientSocket = new Socket(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void test() {
        try {
            DataInputStream in = new DataInputStream(this._clientSocket.getInputStream());
            DataOutputStream out = new DataOutputStream(this._clientSocket.getOutputStream());
            SocketCommands.sendCommand(out, 701);
            SocketCommands.sendDatasetPath(out, "/df1/v4_seisspace/steve/code/main/prowess/test/promax/data/testarea/manhattan-syst/shots-geom.js");
            SocketCommands.sendCommand(out, 101);
            String str = in.readUTF();
            System.out.println(str);
            SocketCommands.sendCommand(out, 301);
            int dimensions = in.readInt();
            System.out.println("data dimensions: " + dimensions);
            for (int i = 0; i < dimensions; ++i) {
                SocketCommands.sendCommand(out, 401);
                String info = SocketCommands.getDimensionProperties(i, in, out);
                System.out.println(info);
            }
            long[] keys = new long[dimensions];
            keys[3] = 1L;
            for (int ii = 1; ii < 85; ++ii) {
                SocketCommands.sendCommand(out, 201);
                keys[2] = ii;
                SocketCommands.sendKeys(keys, out);
                float[][] traces = null;
                SocketCommands.getTraces(in, out, traces);
            }
            SocketCommands.sendCommand(out, 501);
            out.close();
            in.close();
            this._clientSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("SocketTestClient");
        String host = "localhost";
        if (args.length > 0) {
            host = args[0];
        }
        int port = 25005;
        if (args.length > 1) {
            port = new Integer(args[1]);
        }
        System.out.println("SocketTestClient - Server: " + host + " port: " + port);
        SocketTestClient client = new SocketTestClient();
        client.init(host, port);
        client.test();
    }
}

