/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.javaseis.properties.PropertiesConverter;
import org.javaseis.util.SeisException;

public class PropertyDescription
implements Serializable {
    static String[] c_formatStrings = new String[]{"UNKNOWN", "BYTE", "SHORT", "INTEGER", "LONG", "FLOAT", "DOUBLE", "COMPLEX", "DCOMPLEX", "STRING", "BYTESTRING"};
    public static final int HDR_FORMAT_UNDEFINED = 0;
    public static final int HDR_FORMAT_BYTE = 1;
    public static final int HDR_FORMAT_SHORT = 2;
    public static final int HDR_FORMAT_INTEGER = 3;
    public static final int HDR_FORMAT_LONG = 4;
    public static final int HDR_FORMAT_FLOAT = 5;
    public static final int HDR_FORMAT_DOUBLE = 6;
    public static final int HDR_FORMAT_COMPLEX = 7;
    public static final int HDR_FORMAT_DCOMPLEX = 8;
    public static final int HDR_FORMAT_STRING = 9;
    public static final int HDR_FORMAT_BYTESTRING = 10;
    public static final int HDR_OFFSET_UNDEFINED = -1;
    protected String _label;
    protected String _description;
    protected int _count;
    protected int _format;
    protected int _formatLength;
    protected int _recordLength;
    protected int _offset;

    public static int getFormat(String formatString) {
        for (int i = 0; i < c_formatStrings.length; ++i) {
            if (!c_formatStrings[i].equals(formatString)) continue;
            return i;
        }
        return -1;
    }

    public static void sort(PropertyDescription[] propertyDescriptions) {
        Arrays.sort(propertyDescriptions, new PropertiesDescriptionComparator());
    }

    public PropertyDescription() {
        this._label = null;
        this._description = null;
        this._count = 0;
        this._recordLength = 0;
        this._offset = -1;
    }

    public PropertyDescription(String label, String description, int format, int count) {
        this.set(label, description, format, count, -1);
    }

    public String getLabel() {
        return this._label;
    }

    public String getDescription() {
        return this._description;
    }

    public int getCount() {
        return this._count;
    }

    public int getFormat() {
        return this._format;
    }

    public String getFormatString() {
        return c_formatStrings[this._format];
    }

    public int getFormatLength() {
        return this._formatLength;
    }

    public int getRecordLength() {
        return this._recordLength;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public void set(String label, String description, int format, int count, int offset) {
        this._label = new String(label);
        this._description = new String(description);
        this._format = format;
        this._count = count;
        this._formatLength = 0;
        this._recordLength = 0;
        this._offset = offset;
        this.computeLengths();
    }

    public void set(String label, String propertyString) throws SeisException {
        this._label = label;
        String[] values = PropertiesConverter.stringToArray(propertyString, ";", '\"', '\"');
        if (values.length < 4) {
            throw new SeisException("Could not parse property string: '" + propertyString + "' for label='" + label + "' (expecting at least 4 values)");
        }
        if (values.length > 4) {
            String[] temp = new String[]{values[0], values[values.length - 3], values[values.length - 2], values[values.length - 1]};
            values = temp;
        }
        this._description = values[0];
        this._format = 0;
        for (int i = 1; i <= c_formatStrings.length - 1; ++i) {
            if (!values[1].equals(c_formatStrings[i])) continue;
            this._format = i;
            break;
        }
        if (this._format == 0) {
            throw new SeisException("Could not match property format: " + values[1]);
        }
        this._count = Integer.parseInt(values[2]);
        this._offset = Integer.parseInt(values[3]);
        this.computeLengths();
    }

    protected void computeLengths() {
        this._recordLength = 0;
        this._formatLength = 0;
        switch (this._format) {
            case 1: {
                this._formatLength = 1;
                break;
            }
            case 9: {
                this._formatLength = 2;
                break;
            }
            case 10: {
                this._formatLength = 1;
                break;
            }
            case 2: {
                this._formatLength = 2;
                break;
            }
            case 3: 
            case 5: {
                this._formatLength = 4;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                this._formatLength = 8;
                break;
            }
            case 8: {
                this._formatLength = 16;
                break;
            }
        }
        this._recordLength = this._formatLength * this._count;
    }

    public String toPropertyString() {
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(this._description);
        buffer.append(";");
        buffer.append(c_formatStrings[this._format]);
        buffer.append(";");
        buffer.append(Integer.toString(this._count));
        buffer.append(";");
        buffer.append(Integer.toString(this._offset));
        buffer.append("\"");
        return buffer.toString();
    }

    public PropertyDescription clone() {
        PropertyDescription element = new PropertyDescription(this._label, this._description, this._format, this._count);
        element._offset = this._offset;
        return element;
    }

    private static class PropertiesDescriptionComparator
    implements Comparator {
        private PropertiesDescriptionComparator() {
        }

        public int compare(Object o1, Object o2) {
            PropertyDescription propertyDescription1 = (PropertyDescription)o1;
            PropertyDescription propertyDescription2 = (PropertyDescription)o2;
            if (propertyDescription1.getOffset() < propertyDescription2.getOffset()) {
                return -1;
            }
            if (propertyDescription1.getOffset() > propertyDescription2.getOffset()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PropertiesDescriptionComparator;
        }
    }
}

