/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class PropertiesTree {
    static final String ROOT_NAME = "JavaSeis Metadata";
    static String CUSTOM_PROPERTIES = "CustomProperties";
    static String FILE_PROPERTIES = "FileProperties";
    static String TRACE_PROPERTIES = "TraceProperties";
    static String NAME_PROPERTIES = "NameProperties";
    static String USER_DEFINED_PROPERTIES = "UserProperties";
    protected ParameterSet _rootParameterSet;
    protected String _datasetPath;
    private boolean _mustExist;

    public static boolean exists(String datasetPath) {
        return new File(datasetPath + File.separator + "FileProperties.xml").exists();
    }

    public PropertiesTree(String datasetPath) throws SeisException {
        this(datasetPath, true);
    }

    public PropertiesTree(String datasetPath, boolean mustExist) throws SeisException {
        this._mustExist = mustExist;
        if (datasetPath == null) {
            throw new IllegalArgumentException("datasetPath is null");
        }
        this._datasetPath = datasetPath;
        if (mustExist) {
            try {
                this.read();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SeisException(e.toString());
            }
        } else {
            this._rootParameterSet = new ParameterSet(ROOT_NAME);
        }
    }

    public void read() throws SeisException {
        String filePath = this._datasetPath + File.separator + "FileProperties.xml";
        try {
            this._rootParameterSet = ParameterSetIO.readFile(filePath);
        }
        catch (IOException e) {
            throw new SeisException("Error reading file XML file '" + filePath + "'");
        }
    }

    public void write() throws SeisException {
        String filePath = this._datasetPath + File.separator + "FileProperties.xml";
        try {
            ParameterSetIO.writeFile(this._rootParameterSet, filePath);
        }
        catch (IOException e) {
            throw new SeisException("Error writing file XML file '" + filePath + "'");
        }
    }

    public ParameterSet getFileProperties() {
        if (this._mustExist) {
            ParameterSet parameterSet = this._rootParameterSet.getParameterSet(FILE_PROPERTIES);
            if (parameterSet == null) {
                throw new RuntimeException("ParameterSet '" + FILE_PROPERTIES + "' is missing");
            }
            return parameterSet;
        }
        ParameterSet parameterSet = this._rootParameterSet.getParameterSet(FILE_PROPERTIES);
        if (parameterSet == null) {
            parameterSet = this._rootParameterSet.addParameterSet(FILE_PROPERTIES);
        }
        return parameterSet;
    }

    public ParameterSet getTraceProperties() {
        if (this._mustExist) {
            ParameterSet parameterSet = this._rootParameterSet.getParameterSet(TRACE_PROPERTIES);
            if (parameterSet == null) {
                throw new RuntimeException("ParameterSet '" + TRACE_PROPERTIES + "' is missing");
            }
            return parameterSet;
        }
        ParameterSet parameterSet = this._rootParameterSet.getParameterSet(TRACE_PROPERTIES);
        if (parameterSet == null) {
            parameterSet = this._rootParameterSet.addParameterSet(TRACE_PROPERTIES);
        }
        return parameterSet;
    }

    public ParameterSet getCustomProperties() {
        if (this._mustExist) {
            ParameterSet parameterSet = this._rootParameterSet.getParameterSet(CUSTOM_PROPERTIES);
            if (parameterSet == null) {
                parameterSet = this._rootParameterSet.addParameterSet(CUSTOM_PROPERTIES);
                return parameterSet;
            }
            return parameterSet;
        }
        ParameterSet parameterSet = this._rootParameterSet.getParameterSet(CUSTOM_PROPERTIES);
        if (parameterSet == null) {
            parameterSet = this._rootParameterSet.addParameterSet(CUSTOM_PROPERTIES);
        }
        return parameterSet;
    }
}

