/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.javaseis.io.SortMap;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parallel.ParallelMapFactory;

public class ParallelMap
implements Serializable {
    private static final long serialVersionUID = 7774556954657844444L;
    private Map<String, Object>[] _map = new Map[1];
    public static final int MAP_TAG = 505050;

    public ParallelMap() {
        this._map[0] = new LinkedHashMap<String, Object>();
    }

    public void put(String key, Object value) {
        this._map[0].put(key, value);
    }

    public void putAll(Map m) {
        this._map[0].putAll(m);
    }

    public Object get(String key) {
        return this._map[0].get(key);
    }

    public Set<String> keySet() {
        return this._map[0].keySet();
    }

    public Map<String, Object> getMap() {
        return this._map[0];
    }

    public void broadcast(IParallelContext pc) {
        pc.bcast(505050, this._map, 0, 1, 0);
    }

    public void merge(IParallelContext pc) {
        Map[] tmp = new Map[]{new LinkedHashMap()};
        tmp[0].putAll(this._map[0]);
        if (!pc.isMaster()) {
            this._map[0].clear();
        }
        for (int i = 1; i < pc.size(); ++i) {
            if (pc.rank() == i) {
                pc.send(505050, tmp, 0, 1, 0);
            }
            if (pc.isMaster()) {
                pc.recv(505050, tmp, 0, 1);
                this._map[0].putAll(tmp[0]);
            }
            pc.barrier();
        }
        pc.bcast(505050, this._map, 0, 1, 0);
    }

    public static void main(String[] args) {
        String s;
        Integer i;
        int j;
        MPIContext pc = new MPIContext();
        pc.init(args);
        ParallelMap m = ParallelMapFactory.getMap("Chuck");
        SortMap sm = new SortMap(101, 21, 1234L);
        if (pc.isMaster()) {
            m.put("Integer", new Integer(0));
            m.put("String", new String("Example"));
            m.put("SortEntry", sm);
        }
        m.broadcast(pc);
        sm = (SortMap)m.get("SortEntry");
        sm.trc = pc.rank();
        for (j = 0; j < pc.size(); ++j) {
            if (pc.rank() == j) {
                i = (Integer)m.get("Integer");
                s = (String)m.get("String");
                SortMap sm2 = (SortMap)m.get("SortEntry");
                System.out.println("\nMap contents on task " + j);
                System.out.println(" Integer = " + i);
                System.out.println(" String = " + s.toString());
                System.out.println(" SortMap = " + sm2.lvol + " " + sm2.lfrm + " " + sm2.trc);
                System.out.flush();
            }
            System.out.flush();
            pc.barrier();
        }
        m.merge(pc);
        pc.masterPrint("\nContents after merge");
        for (j = 0; j < pc.size(); ++j) {
            if (pc.rank() == j) {
                i = (Integer)m.get("Integer");
                s = (String)m.get("String");
                sm = (SortMap)m.get("SortEntry");
                System.out.println("\nMap contents on task " + j);
                System.out.println(" Integer = " + i);
                System.out.println(" String = " + s.toString());
                System.out.println(" SortMap = " + sm.lvol + " " + sm.lfrm + " " + sm.trc);
                System.out.flush();
            }
            System.out.flush();
            pc.barrier();
        }
        pc.finish();
    }
}

