/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class SortIOParms {
    private static final Logger LOG = Logger.getLogger(SortIOParms.class.getName());
    public static final String PROPERTIES_NAME = "SortProperties";
    public static final String VOLUMEMAP_NAME = "SortVolumeMap";
    public static final String FRAMEMAP_NAME = "SortFrameMap";
    public static final String TRACEMAP_NAME = "SortTraceMap";
    private static final String NUMBER_OF_VOLUMES = "NumberOfVolumes";
    private static final String FRAMES_PER_VOLUME = "FramesPerVolume";
    private static final String TRACES_PER_FRAME = "TracesPerFrame";
    private static final String TOTAL_TRACES_IN_SORT = "TotalTracesInSort";
    private static final String MIN_LOGICAL_VOLUME = "MinLogicalVolume";
    private static final String MAX_LOGICAL_VOLUME = "MaxLogicalVolume";
    private static final String LOGICAL_VOLUME_INCREMENT = "LogicalVolumeIncrement";
    private static final String MIN_LOGICAL_FRAME = "MinLogicalFrame";
    private static final String MAX_LOGICAL_FRAME = "MaxLogicalFrame";
    private static final String LOGICAL_FRAME_INCREMENT = "LogicalFrameIncrement";
    private static final String MIN_LOGICAL_TRACE = "MinLogicalTrace";
    private static final String MAX_LOGICAL_TRACE = "MaxLogicalTrace";
    private static final String LOGICAL_TRACE_INCREMENT = "LogicalTraceIncrement";
    private static final String LABEL2 = "Label2";
    private static final String LABEL3 = "Label3";
    private static final String LABEL4 = "Label4";
    public static final String FRAME_SORT_SECONDARY = "FrameSortSecondary";
    public static final String FRAME_SORT_TERTIARY = "FrameSortTertiary";
    public static final String PARAMETER_SET_NAME = "SortProperties";
    public String sort3_secondary = "NONE";
    public String sort3_tertiary = "NONE";
    public int volumes;
    public int framesPerVolume;
    public int tracesPerFrame;
    public long tracesInSort;
    public int minLogVol;
    public int maxLogVol;
    public int logVolInc = 1;
    public int minLogFrm;
    public int maxLogFrm;
    public int logFrmInc = 1;
    public int minLogTrc;
    public int maxLogTrc;
    public int logTrcInc = 1;
    public String label4;
    public String label3;
    public String label2;
    private String _seisParametersPath;
    private ParameterSet _seisParameters;

    public void loadDefinition(String basePath, String sortmapName) throws IOException {
        String propertyFile;
        this._seisParametersPath = propertyFile = SortIOParms.makePropertiesFileName(basePath, sortmapName);
        this._seisParameters = ParameterSetIO.readFile(this._seisParametersPath);
        this.volumes = ParameterSetIO.getRequiredInt(this._seisParameters, NUMBER_OF_VOLUMES);
        this.framesPerVolume = ParameterSetIO.getRequiredInt(this._seisParameters, FRAMES_PER_VOLUME);
        this.tracesPerFrame = ParameterSetIO.getRequiredInt(this._seisParameters, TRACES_PER_FRAME);
        this.tracesInSort = ParameterSetIO.getRequiredLong(this._seisParameters, TOTAL_TRACES_IN_SORT);
        this.minLogVol = ParameterSetIO.getRequiredInt(this._seisParameters, MIN_LOGICAL_VOLUME);
        this.maxLogVol = ParameterSetIO.getRequiredInt(this._seisParameters, MAX_LOGICAL_VOLUME);
        this.logVolInc = this._seisParameters.getInt(LOGICAL_VOLUME_INCREMENT, 1);
        this.minLogFrm = ParameterSetIO.getRequiredInt(this._seisParameters, MIN_LOGICAL_FRAME);
        this.maxLogFrm = ParameterSetIO.getRequiredInt(this._seisParameters, MAX_LOGICAL_FRAME);
        this.logFrmInc = this._seisParameters.getInt(LOGICAL_FRAME_INCREMENT, 1);
        this.minLogTrc = this._seisParameters.getInt(MIN_LOGICAL_TRACE, -1);
        this.maxLogTrc = this._seisParameters.getInt(MAX_LOGICAL_TRACE, -1);
        this.logTrcInc = this._seisParameters.getInt(LOGICAL_TRACE_INCREMENT, 1);
        this.label4 = ParameterSetIO.getRequiredString(this._seisParameters, LABEL4);
        this.label3 = ParameterSetIO.getRequiredString(this._seisParameters, LABEL3);
        this.label2 = this._seisParameters.getString(LABEL2, "NONE");
        this.sort3_secondary = this._seisParameters.getString(FRAME_SORT_SECONDARY, "NONE");
        this.sort3_tertiary = this._seisParameters.getString(FRAME_SORT_TERTIARY, "NONE");
        if (this.getDimensions() == 4) {
            if (this.volumes <= 0 || this.framesPerVolume <= 0 || this.tracesPerFrame <= 0 || this.tracesInSort <= 0L) {
                LOG.warning("Invalid values for  size of sort tables:");
                String msg = String.format("NumberOfVolumes %d FramesPerVolume %d TracesPerFrame  %d TotalTracesInSort %d\n", this.volumes, this.framesPerVolume, this.tracesPerFrame, this.tracesInSort);
                LOG.warning(msg);
                throw new SeisException("Invalid values for size of sort tables");
            }
        } else if (this.framesPerVolume <= 0 || this.tracesPerFrame <= 0 || this.tracesInSort <= 0L) {
            LOG.warning("Invalid values for  size of sort tables:");
            String msg = String.format("FramesPerVolume %d TracesPerFrame  %d TotalTracesInSort %d\n", this.framesPerVolume, this.tracesPerFrame, this.tracesInSort);
            LOG.warning(msg);
            throw new SeisException("Invalid values for size of sort tables");
        }
    }

    public int getDimensions() {
        if (this.label4 == null || this.label4.isEmpty() || this.label4.equalsIgnoreCase("NONE")) {
            return 3;
        }
        return 4;
    }

    static String makePropertiesFileName(String basePath, String sortName) {
        return basePath + File.separator + "SortProperties" + "." + sortName + ".xml";
    }

    public String getSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("---\n");
        buf.append("Sort ParameterSet\n");
        buf.append("Volumes = " + this.volumes + "\n");
        buf.append("FramePerVolume = " + this.framesPerVolume + "\n");
        buf.append("TracesPerFrame = " + this.tracesPerFrame + "\n");
        buf.append("TracesInSort = " + this.tracesInSort + "\n");
        buf.append("Min logical volume = " + this.minLogVol + "\n");
        buf.append("Max logical volume = " + this.maxLogVol + "\n");
        buf.append("Logical volume increment = " + this.logVolInc + "\n");
        buf.append("Min logical frame = " + this.minLogFrm + "\n");
        buf.append("Max logical frame = " + this.maxLogFrm + "\n");
        buf.append("Locial frame increment = " + this.logFrmInc + "\n");
        buf.append("Min logical trace = " + this.minLogTrc + "\n");
        buf.append("Max logical trace = " + this.maxLogTrc + "\n");
        buf.append("Locial trace increment = " + this.logTrcInc + "\n");
        buf.append("Label4 = " + this.label4 + "\n");
        buf.append("Label3 = " + this.label3 + "\n");
        buf.append("Label2 = " + this.label2 + "\n");
        buf.append("sort3_secondary = " + this.sort3_secondary + "\n");
        buf.append("sort3_tertiary = " + this.sort3_tertiary + "\n");
        buf.append("---\n");
        return buf.toString();
    }

    public static void writeparms(String basePath, String sortmapName, SortIOParms parms) throws IOException {
        if (parms.sort3_secondary.isEmpty()) {
            throw new IOException("sort3_secondary has not been specified");
        }
        if (parms.sort3_tertiary.isEmpty()) {
            throw new IOException("sort3_tertiary has not been specified");
        }
        if (parms.logVolInc < 1) {
            throw new IOException("Logical volume increment is not valid " + parms.logVolInc);
        }
        if (parms.logFrmInc < 1) {
            throw new IOException("Logical frame increment is not valid " + parms.logFrmInc);
        }
        if (parms.logTrcInc < 1) {
            throw new IOException("Logical trace increment is not valid " + parms.logTrcInc);
        }
        String path = SortIOParms.makePropertiesFileName(basePath, sortmapName);
        ParameterSet seisParameters = new ParameterSet();
        seisParameters.setString(LABEL2, parms.label2);
        seisParameters.setString(LABEL3, parms.label3);
        seisParameters.setString(LABEL4, parms.label4);
        seisParameters.setString(FRAME_SORT_SECONDARY, parms.sort3_secondary);
        seisParameters.setString(FRAME_SORT_TERTIARY, parms.sort3_tertiary);
        seisParameters.setInt(NUMBER_OF_VOLUMES, parms.volumes);
        seisParameters.setInt(FRAMES_PER_VOLUME, parms.framesPerVolume);
        seisParameters.setInt(TRACES_PER_FRAME, parms.tracesPerFrame);
        seisParameters.setLong(TOTAL_TRACES_IN_SORT, parms.tracesInSort);
        seisParameters.setInt(MIN_LOGICAL_VOLUME, parms.minLogVol);
        seisParameters.setInt(MAX_LOGICAL_VOLUME, parms.maxLogVol);
        seisParameters.setInt(LOGICAL_VOLUME_INCREMENT, parms.logVolInc);
        seisParameters.setInt(MIN_LOGICAL_FRAME, parms.minLogFrm);
        seisParameters.setInt(MAX_LOGICAL_FRAME, parms.maxLogFrm);
        seisParameters.setInt(LOGICAL_FRAME_INCREMENT, parms.logFrmInc);
        seisParameters.setInt(MIN_LOGICAL_TRACE, parms.minLogTrc);
        seisParameters.setInt(MAX_LOGICAL_TRACE, parms.maxLogTrc);
        seisParameters.setInt(LOGICAL_TRACE_INCREMENT, parms.logTrcInc);
        ParameterSetIO.writeFile(seisParameters, path);
        new File(basePath + File.separator + "SortVolumeMap." + sortmapName).createNewFile();
        new File(basePath + File.separator + "SortFrameMap." + sortmapName).createNewFile();
        new File(basePath + File.separator + "SortTraceMap." + sortmapName).createNewFile();
    }
}

