/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.javaseis.io.JSUtilFile;

public class JSRandomAccessFile {
    private RandomAccessFile _data_stream = null;
    private FileChannel _data_channel = null;
    private final int _block_count;
    private boolean _initialized = false;
    private ByteBuffer _buf = null;
    private int _num_buffers = 0;
    private int _limit = 0;
    private int[] _limits = null;
    private int[] _positions = null;
    private int[] _alt_limits = null;
    private final String _pathName;
    private final boolean _isReadOnly;
    private static final int DEFAULT_BLOCK_COUNT = 1024;
    private static final int BLOCK_SIZE = 512;

    public JSRandomAccessFile(String name, String mode) throws FileNotFoundException, IOException {
        this(name, mode, JSRandomAccessFile.getBlockCount());
    }

    public JSRandomAccessFile(String name, String mode, int block_count) throws FileNotFoundException, IOException {
        this._pathName = name;
        this._block_count = block_count;
        this._isReadOnly = !mode.contains("w");
        JSUtilFile.setSparse(name);
        this._data_stream = new RandomAccessFile(name, mode);
        if (!this._isReadOnly) {
            JSUtilFile.setODirect(this._data_stream.getFD(), name, 1);
        }
        this._data_channel = this._data_stream.getChannel();
    }

    public String getAbsolutePath() {
        return this._pathName;
    }

    private static int getBlockCount() {
        int retval = 1024;
        try {
            String js_block_count = System.getenv("JS_BLOCK_COUNT");
            if (js_block_count != null) {
                retval = Integer.parseInt(js_block_count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public int read(ByteBuffer buf) throws IOException {
        int retval = 0;
        int limit = buf.limit();
        this.initialize(buf);
        for (int k2 = 0; k2 < this._num_buffers; ++k2) {
            if (this._limits[k2] < limit) {
                buf.limit(this._limits[k2]);
            } else {
                buf.limit(limit);
                k2 = this._num_buffers;
            }
            retval += this._data_channel.read(buf);
        }
        buf.limit(limit);
        return retval;
    }

    public int limitedRead(ByteBuffer buf, int len) throws IOException {
        int retval = 0;
        int limit = buf.limit();
        if (this.limit(buf, len) == len) {
            for (int k2 = 0; k2 < this._num_buffers; ++k2) {
                if (this._alt_limits[k2] < limit) {
                    buf.limit(this._alt_limits[k2]);
                } else {
                    buf.limit(limit);
                }
                retval += this._data_channel.read(buf);
            }
        }
        buf.limit(limit);
        return retval;
    }

    public int write(ByteBuffer buf) throws IOException {
        int retval = 0;
        int limit = buf.limit();
        this.initialize(buf);
        for (int k2 = 0; k2 < this._num_buffers; ++k2) {
            if (this._limits[k2] < limit) {
                buf.limit(this._limits[k2]);
            } else {
                buf.limit(limit);
            }
            retval += this._data_channel.write(buf);
        }
        buf.limit(limit);
        return retval;
    }

    public void position(long newposition) throws IOException {
        if (this._data_channel != null) {
            this._data_channel.position(newposition);
        }
    }

    public void flush() throws IOException {
        try {
            if (this._isReadOnly) {
                this._data_channel.force(false);
            } else {
                this._data_channel.force(true);
            }
        }
        catch (ClosedChannelException e) {
            throw new IOException("JSRandomAccessFile.flush: channel is closed");
        }
    }

    public void close() throws IOException {
        this.flush();
        this._data_channel.close();
        this._data_channel = null;
        this._data_stream.close();
        this._data_stream = null;
    }

    public FileDescriptor getFD() throws IOException {
        FileDescriptor retval = this._data_stream.getFD();
        return retval;
    }

    private void initialize(ByteBuffer buf) throws IOException {
        if (!this.initialized(buf)) {
            this._initialized = false;
            if (this._data_stream != null && buf != null && this._block_count > 0) {
                int limit = buf.limit();
                int position = buf.position();
                int length = buf.remaining();
                if (length > 0) {
                    int num_buffers;
                    int blength = this._block_count * 512;
                    double d_num_buffers = (double)length / (double)blength;
                    this._num_buffers = num_buffers = (int)Math.ceil(d_num_buffers);
                    this._limits = new int[num_buffers];
                    this._positions = new int[num_buffers];
                    int last_length = length - (num_buffers - 1) * blength;
                    int offset = position;
                    for (int k2 = 0; k2 < num_buffers - 1; ++k2) {
                        this._positions[k2] = offset;
                        this._limits[k2] = offset += blength;
                    }
                    this._positions[num_buffers - 1] = offset;
                    this._limits[num_buffers - 1] = offset + last_length;
                    if (this._limits[num_buffers - 1] != limit) {
                        throw new IOException("JSRandomAccessFile.initialize: unexpected limit");
                    }
                    this._initialized = true;
                    this._alt_limits = null;
                    this._buf = buf;
                }
            } else {
                throw new IOException("JSRandomAccessFile.initialize: data stream or buffer bad");
            }
        }
    }

    private boolean initialized(ByteBuffer buf) {
        boolean retval;
        boolean bl = retval = this._data_stream != null && this._initialized && this._buf == buf && buf != null && this._limits != null && this._num_buffers > 0;
        if (retval) {
            retval = this._limits[this._num_buffers - 1] >= this._buf.limit();
        }
        return retval;
    }

    private int limit(ByteBuffer buf, int newlimit) throws IOException {
        int retval = 0;
        this.initialize(buf);
        if (this._num_buffers > 0 && newlimit < buf.limit()) {
            if (this._limit != newlimit || this._alt_limits == null) {
                boolean finished = false;
                this._alt_limits = new int[this._limits.length];
                for (int k2 = 0; k2 < this._limits.length; ++k2) {
                    if (!finished) {
                        int limit = newlimit - retval;
                        int next_len = this._limits[k2] - this._positions[k2];
                        if (limit < next_len) {
                            finished = true;
                            if (limit > 0) {
                                this._alt_limits[k2] = limit;
                            }
                            this._limit = retval += limit;
                            continue;
                        }
                        this._alt_limits[k2] = next_len;
                        retval += next_len;
                        continue;
                    }
                    this._alt_limits[k2] = this._positions[k2];
                }
            } else {
                retval = newlimit;
            }
        } else {
            retval = newlimit;
        }
        return retval;
    }
}

