/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.grid;

import edu.mines.jtk.util.ParameterSet;
import org.javaseis.grid.IBinGrid;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class BinGrid
implements IBinGrid {
    public static final String BIN_GRID = "BinGrid";
    double _wx0;
    double _wy0;
    double _gx0;
    double _gy0;
    double _gdx;
    double _gdy;
    long _lx0;
    long _ly0;
    long _ldx;
    long _ldy;
    double[] _a;
    double[] _b;
    double _wx1;
    double _wy1;
    double _wx2;
    double _wy2;
    long _lx1;
    long _ly1;
    long _lx2;
    long _ly2;
    static final double EPS = (double)1.4E-45f;

    public BinGrid(ParameterSet parset) throws SeisException {
        if (parset == null) {
            throw new SeisException("Dataset definition does not contain a Geometry definition");
        }
        double wx0 = ParameterSetIO.getRequiredDouble(parset, "WorldX0");
        double wy0 = ParameterSetIO.getRequiredDouble(parset, "WorldY0");
        double wx1 = ParameterSetIO.getRequiredDouble(parset, "WorldX1");
        double wy1 = ParameterSetIO.getRequiredDouble(parset, "WorldY1");
        double wx2 = ParameterSetIO.getRequiredDouble(parset, "WorldX2");
        double wy2 = ParameterSetIO.getRequiredDouble(parset, "WorldY2");
        double gx0 = ParameterSetIO.getRequiredDouble(parset, "GridX0");
        double gy0 = ParameterSetIO.getRequiredDouble(parset, "GridY0");
        double gdx = ParameterSetIO.getRequiredDouble(parset, "GridDX");
        double gdy = ParameterSetIO.getRequiredDouble(parset, "GridDY");
        long lx0 = ParameterSetIO.getRequiredLong(parset, "LogicalX0");
        long ly0 = ParameterSetIO.getRequiredLong(parset, "LogicalY0");
        long lx1 = ParameterSetIO.getRequiredLong(parset, "LogicalX1");
        long ly1 = ParameterSetIO.getRequiredLong(parset, "LogicalY1");
        long lx2 = ParameterSetIO.getRequiredLong(parset, "LogicalX2");
        long ly2 = ParameterSetIO.getRequiredLong(parset, "LogicalY2");
        long ldx = ParameterSetIO.getRequiredLong(parset, "LogicalDX");
        long ldy = ParameterSetIO.getRequiredLong(parset, "LogicalDY");
        this.setBinGrid(wx0, wy0, wx1, wy1, wx2, wy2, lx0, ly0, lx1, ly1, lx2, ly2, ldx, ldy, gx0, gy0, gdx, gdy);
    }

    public BinGrid(double wx0, double wy0, double degrees, double gx0, double gy0, double gdx, double gdy, long nx, long lx0, long ldx, long ny, long ly0, long ldy) throws SeisException {
        double theta = degrees * Math.PI / 180.0;
        double phi = theta + 1.5707963267948966;
        double wx1 = wx0 + gdx * (double)(nx - 1L) * Math.cos(theta);
        double wx2 = wx0 + gdy * (double)(ny - 1L) * Math.cos(phi);
        double wy1 = wy0 + gdx * (double)(nx - 1L) * Math.sin(theta);
        double wy2 = wy0 + gdy * (double)(ny - 1L) * Math.sin(phi);
        long lx1 = lx0 + ldx * (nx - 1L);
        long ly1 = ly0;
        long lx2 = lx0;
        long ly2 = ly0 + ldy * (ny - 1L);
        this.setBinGrid(wx0, wy0, wx1, wy1, wx2, wy2, lx0, ly0, lx1, ly1, lx2, ly2, ldx, ldy, gx0, gy0, gdx, gdy);
    }

    public BinGrid(double wx0, double wy0, double wx1, double wy1, double wdy, long lx0, long ly0, long lx1, long ly1, long ldx, long ldy, double gx0, double gy0, double gdx, double gdy) throws SeisException {
        double phi = Math.atan2(wy1 - wy0, wx1 - wx0) + 1.5707963267948966;
        double wx2 = wx0 + wdy * Math.cos(phi);
        double wy2 = wy0 + wdy * Math.sin(phi);
        long lx2 = lx1;
        long ly2 = ly0 + ldy;
        this.setBinGrid(wx0, wy0, wx1, wy1, wx2, wy2, lx0, ly0, lx1, ly1, lx2, ly2, ldx, ldy, gx0, gy0, gdx, gdy);
    }

    public BinGrid(double wx0, double wy0, double wx1, double wy1, double wx2, double wy2, long lx0, long ly0, long lx1, long ly1, long lx2, long ly2, long ldx, long ldy, double gx0, double gy0, double gdx, double gdy) throws SeisException {
        this.setBinGrid(wx0, wy0, wx1, wy1, wx2, wy2, lx0, ly0, lx1, ly1, lx2, ly2, ldx, ldy, gx0, gy0, gdx, gdy);
    }

    public void setBinGrid(double wx0, double wy0, double wx1, double wy1, double wx2, double wy2, long lx0, long ly0, long lx1, long ly1, long lx2, long ly2, long ldx, long ldy, double gx0, double gy0, double gdx, double gdy) throws SeisException {
        if (gdx <= 0.0 || gdy <= 0.0 || ldx == 0L || ldy == 0L) {
            throw new SeisException("Grid delta values must be > 0");
        }
        double x1 = wx1 - wx0;
        double x2 = wx2 - wx0;
        double y1 = wy1 - wy0;
        double y2 = wy2 - wy0;
        double u1 = gdx * (double)(lx1 - lx0) / (double)ldx;
        double u2 = gdx * (double)(lx2 - lx0) / (double)ldx;
        double v1 = gdy * (double)(ly1 - ly0) / (double)ldy;
        double v2 = gdy * (double)(ly2 - ly0) / (double)ldy;
        double detx = x2 * y1 - x1 * y2;
        double detu = u2 * v1 - u1 * v2;
        if (Math.abs(detx) < (double)1.4E-45f || Math.abs(detu) < (double)1.4E-45f) {
            throw new SeisException("Grid determinants are numerically indefinite.\nA valid 3d poststack binning definition is required to construct a bingrid object`.\nIn many cases this information is loaded from the binning parameters of the ProMAX LIN.\n");
        }
        this._a = new double[4];
        this._b = new double[4];
        this._wx0 = wx0;
        this._wy0 = wy0;
        this._wx1 = wx1;
        this._wy1 = wy1;
        this._wx2 = wx2;
        this._wy2 = wy2;
        this._lx0 = lx0;
        this._ly0 = ly0;
        this._lx1 = lx1;
        this._ly1 = ly1;
        this._lx2 = lx2;
        this._ly2 = ly2;
        this._ldx = ldx;
        this._ldy = ldy;
        this._gx0 = gx0;
        this._gy0 = gy0;
        this._gdx = gdx;
        this._gdy = gdy;
        this._a[0] = (y1 * u2 - y2 * u1) / detx;
        this._a[1] = (x2 * u1 - x1 * u2) / detx;
        this._a[2] = (y1 * v2 - y2 * v1) / detx;
        this._a[3] = (x2 * v1 - x1 * v2) / detx;
        this._b[0] = (v1 * x2 - v2 * x1) / detu;
        this._b[1] = (u2 * x1 - u1 * x2) / detu;
        this._b[2] = (v1 * y2 - v2 * y1) / detu;
        this._b[3] = (u2 * y1 - u1 * y2) / detu;
    }

    @Override
    public void setProjection(int projectionType) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setWorldCoords(double[] worldXY, long[] worldLX) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setGridCoords(double gx0, double gy0, double dx, double dy) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public void setLogicalCoords(long lx0, long ly0, long ldx, long ldy) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public double[] getWorldCoords() {
        return null;
    }

    @Override
    public double[] getGridCoords() {
        return null;
    }

    @Override
    public long[] getLogicalCoords() {
        return null;
    }

    @Override
    public double[] worldToGrid(double[] worldXY) {
        if (worldXY.length < 2) {
            throw new IllegalArgumentException("worldXY must have length greater than 1");
        }
        double x = worldXY[0] - this._wx0;
        double y = worldXY[1] - this._wy0;
        double gx = this._a[0] * x + this._a[1] * y + this._gx0;
        double gy = this._a[2] * x + this._a[3] * y + this._gy0;
        return new double[]{gx, gy};
    }

    @Override
    public long[] worldToLogical(double[] worldXY) {
        return this.worldToLogical(worldXY, false);
    }

    public long[] worldToLogical(double[] worldXY, boolean roundOff) {
        return this.gridToLogical(this.worldToGrid(worldXY), roundOff);
    }

    @Override
    public double[] gridToWorld(double[] gridXY) {
        if (gridXY.length < 2) {
            throw new IllegalArgumentException("gridXY array must have length greater than 1");
        }
        double x = gridXY[0] - this._gx0;
        double y = gridXY[1] - this._gy0;
        double wx = this._b[0] * x + this._b[1] * y + this._wx0;
        double wy = this._b[2] * x + this._b[3] * y + this._wy0;
        return new double[]{wx, wy};
    }

    @Override
    public long[] gridToLogical(double[] gridXY) {
        return this.gridToLogical(gridXY, false);
    }

    public long[] gridToLogical(double[] gridXY, boolean roundOff) {
        return this.indexToLogical(this.gridToIndex(gridXY, roundOff));
    }

    public long[] gridToIndex(double[] gridXY) {
        return this.gridToIndex(gridXY, false);
    }

    public long[] gridToIndex(double[] gridXY, boolean roundOff) {
        long iy;
        long ix;
        if (gridXY.length < 2) {
            throw new IllegalArgumentException("gridXY array must have length greater than 1");
        }
        if (roundOff) {
            ix = Math.round((gridXY[0] - this._gx0) / this._gdx);
            iy = Math.round((gridXY[1] - this._gy0) / this._gdy);
        } else {
            ix = (long)((gridXY[0] - this._gx0) / this._gdx);
            iy = (long)((gridXY[1] - this._gy0) / this._gdy);
        }
        return new long[]{ix, iy};
    }

    @Override
    public double[] logicalToWorld(long[] logicalXY) {
        return this.gridToWorld(this.logicalToGrid(logicalXY));
    }

    @Override
    public double[] logicalToGrid(long[] logicalXY) {
        return this.indexToGrid(this.logicalToIndex(logicalXY));
    }

    public long[] logicalToIndex(long[] logicalXY) {
        if (logicalXY.length < 2) {
            throw new IllegalArgumentException("logicalXY array must have length greater than 1");
        }
        long ix = (logicalXY[0] - this._lx0) / this._ldx;
        long iy = (logicalXY[1] - this._ly0) / this._ldy;
        return new long[]{ix, iy};
    }

    public double[] indexToGrid(long[] index) {
        if (index.length < 2) {
            throw new IllegalArgumentException("index array must have length greater than 1");
        }
        double gx = this._gx0 + this._gdx * (double)index[0];
        double gy = this._gy0 + this._gdy * (double)index[1];
        return new double[]{gx, gy};
    }

    public long[] indexToLogical(long[] index) {
        if (index.length < 2) {
            throw new IllegalArgumentException("index array must have length greater than 1");
        }
        long lx = this._lx0 + this._ldx * index[0];
        long ly = this._ly0 + this._ldy * index[1];
        return new long[]{lx, ly};
    }

    public ParameterSet toParameterSet() {
        ParameterSet ps = new ParameterSet(BIN_GRID);
        ps.addParameter("WorldX0");
        ps.setDouble("WorldX0", this._wx0);
        ps.addParameter("WorldY0");
        ps.setDouble("WorldY0", this._wy0);
        ps.addParameter("WorldX1");
        ps.setDouble("WorldX1", this._wx1);
        ps.addParameter("WorldY1");
        ps.setDouble("WorldY1", this._wy1);
        ps.addParameter("WorldX2");
        ps.setDouble("WorldX2", this._wx2);
        ps.addParameter("WorldY2");
        ps.setDouble("WorldY2", this._wy2);
        ps.addParameter("GridX0");
        ps.setDouble("GridX0", this._gx0);
        ps.addParameter("GridY0");
        ps.setDouble("GridY0", this._gy0);
        ps.addParameter("GridDX");
        ps.setDouble("GridDX", this._gdx);
        ps.addParameter("GridDY");
        ps.setDouble("GridDY", this._gdy);
        ps.addParameter("LogicalX0");
        ps.setLong("LogicalX0", this._lx0);
        ps.addParameter("LogicalY0");
        ps.setLong("LogicalY0", this._ly0);
        ps.addParameter("LogicalX1");
        ps.setLong("LogicalX1", this._lx1);
        ps.addParameter("LogicalY1");
        ps.setLong("LogicalY1", this._ly1);
        ps.addParameter("LogicalX2");
        ps.setLong("LogicalX2", this._lx2);
        ps.addParameter("LogicalY2");
        ps.setLong("LogicalY2", this._ly2);
        ps.addParameter("LogicalDX");
        ps.setLong("LogicalDX", this._ldx);
        ps.addParameter("LogicalDY");
        ps.setLong("LogicalDY", this._ldy);
        return ps;
    }

    public double getWX0() {
        return this._wx0;
    }

    public double getWY0() {
        return this._wy0;
    }

    public double getWX1() {
        return this._wx1;
    }

    public double getWY1() {
        return this._wy1;
    }

    public double getWX2() {
        return this._wx2;
    }

    public double getWY2() {
        return this._wy2;
    }

    public double getGDX() {
        return this._gdx;
    }

    public double getGDY() {
        return this._gdy;
    }

    public double getGX0() {
        return this._gx0;
    }

    public double getGY0() {
        return this._gy0;
    }

    public long getLDX() {
        return this._ldx;
    }

    public long getLDY() {
        return this._ldy;
    }

    public long getLX0() {
        return this._lx0;
    }

    public long getLY0() {
        return this._ly0;
    }

    public long getLX1() {
        return this._lx1;
    }

    public long getLY1() {
        return this._ly1;
    }

    public long getLX2() {
        return this._lx2;
    }

    public long getLY2() {
        return this._ly2;
    }

    public static void main(String[] args) throws SeisException {
        double wx0 = 0.0;
        double wy0 = 0.0;
        double theta = 45.0;
        double gx0 = 0.0;
        double gy0 = 0.0;
        double gdx = 10.0;
        double gdy = 10.0;
        long nx = 103L;
        long ny = 101L;
        long lx0 = 1L;
        long ly0 = 1L;
        long ldx = 1L;
        long ldy = 1L;
        BinGrid bin = new BinGrid(wx0, wy0, theta, gx0, gy0, gdx, gdy, nx, lx0, ldx, ny, ly0, ldy);
        BinGrid.exerciseGrid(bin, theta);
        theta = 0.0;
        bin = new BinGrid(wx0, wy0, theta, gx0, gy0, gdx, gdy, nx, lx0, ldx, ny, ly0, ldy);
        BinGrid.exerciseGrid(bin, theta);
        theta = 90.0;
        bin = new BinGrid(wx0, wy0, theta, gx0, gy0, gdx, gdy, nx, lx0, ldx, ny, ly0, ldy);
        BinGrid.exerciseGrid(bin, theta);
        theta = 180.0;
        bin = new BinGrid(wx0, wy0, theta, gx0, gy0, gdx, gdy, nx, lx0, ldx, ny, ly0, ldy);
        BinGrid.exerciseGrid(bin, theta);
        theta = 270.0;
        bin = new BinGrid(wx0, wy0, theta, gx0, gy0, gdx, gdy, nx, lx0, ldx, ny, ly0, ldy);
        BinGrid.exerciseGrid(bin, theta);
    }

    protected static void exerciseGrid(BinGrid bin, double theta) {
        double[] wxy = new double[]{-10.0, 90.0};
        double[] gxy = bin.worldToGrid(wxy);
        long[] lxy = bin.worldToLogical(wxy, true);
        System.out.format("     World X     World Y      Grid X      Grid Y   Logical X   Logical Y : theta=" + theta + "  \n", new Object[0]);
        for (int i = 0; i < 9; ++i) {
            System.out.format("%12.1f%12.1f%12.1f%12.1f%12d%12d\n", wxy[0], wxy[1], gxy[0], gxy[1], lxy[0], lxy[1]);
            wxy[0] = wxy[0] - 10.0;
            wxy[1] = wxy[1] - 10.0;
            gxy = bin.worldToGrid(wxy);
            lxy = bin.worldToLogical(wxy, true);
        }
    }
}

