/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.CleanHandler;
import java.util.Arrays;
import java.util.List;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.test.JPerfTestShapes;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.util.MXBeanReporter;
import org.javaseis.util.RandomRange;

public class JPerfTestMultiArrayTranspose {
    private boolean _doInverse = true;

    protected IFlexArray<int[]> createTestArray(int[] shape) {
        IFlexArray<int[]> m = FlexArray.createIntArray(shape);
        return m;
    }

    protected String createLogRecord(String operation, long size, double startTime, double endTime, int[] shape) {
        double arraySize = (double)size / 1048576.0;
        double elapsedTime = endTime - startTime;
        String record = operation + ": size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(shape);
        return record;
    }

    private void testTransposeT21(int i0, int i1) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1});
        this.fillArray(m);
        this.transpose(m, TransposeType.T21, TransposeType.T21);
    }

    void testTransposeT213(int i0, int i1, int i2) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1, i2});
        this.fillArray(m);
        this.transpose(m, TransposeType.T213, TransposeType.T213);
    }

    void testTransposeT132(int i0, int i1, int i2) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1, i2});
        this.fillArray(m);
        this.transpose(m, TransposeType.T132, TransposeType.T132);
    }

    void testTransposeT312(int i0, int i1, int i2) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1, i2});
        this.fillArray(m);
        this.transpose(m, TransposeType.T312, TransposeType.T312);
    }

    void testTransposeT231(int i0, int i1, int i2) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1, i2});
        this.fillArray(m);
        this.transpose(m, TransposeType.T231, TransposeType.T312);
    }

    void testTransposeT321(int i0, int i1, int i2) {
        IFlexArray<int[]> m = this.createTestArray(new int[]{i0, i1, i2});
        this.fillArray(m);
        this.transpose(m, TransposeType.T321, TransposeType.T321);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transpose(IFlexArray<int[]> m, TransposeType operationForward, TransposeType operationInverse) {
        try {
            long size = 4L;
            int[] shape = m.getShape();
            for (int i = 0; i < shape.length; ++i) {
                size *= (long)shape[i];
            }
            double startTime = JPerfTestMultiArrayTranspose.getTime();
            m.transpose(operationForward);
            double stopTime = JPerfTestMultiArrayTranspose.getTime();
            String record = this.createLogRecord(operationForward.name(), size, startTime, stopTime, m.getShape());
            this.logInfo(record);
            System.gc();
            if (operationInverse != null && this._doInverse) {
                startTime = JPerfTestMultiArrayTranspose.getTime();
                m.transpose(operationInverse);
                stopTime = JPerfTestMultiArrayTranspose.getTime();
                record = this.createLogRecord(operationForward.name(), size, startTime, stopTime, m.getShape());
                this.logInfo(record);
                System.gc();
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        finally {
            System.gc();
        }
    }

    private void fillArray(IFlexArray<int[]> m) {
        int imin = 0;
        int imax = Integer.MAX_VALUE;
        IPositionIterator<int[]> it = m.newPositionIterator();
        RandomRange r = new RandomRange(1L, 0.0, 1.0);
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            int[] buf = m.getTrace(pos);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = imin + Math.round((float)imax * r.nextFloat());
            }
        }
    }

    protected void logInfo(String message) {
        System.out.println(message);
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    public static void main(String[] args) {
        CleanHandler.setDefaultHandler();
        Boolean memoryPrint = false;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        MXBeanReporter m = JPerfTestShapes.startMemoryThread(memoryPrint);
        JPerfTestMultiArrayTranspose tester = new JPerfTestMultiArrayTranspose();
        List<int[]> shapes2 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.TWO);
        for (int[] shape : shapes2) {
            tester.testTransposeT21(shape[0], shape[1]);
            if (memoryPrint.booleanValue()) {
                m.printReport();
            }
            System.gc();
            if (!memoryPrint.booleanValue()) continue;
            m.printReport();
        }
        List<int[]> shapes3 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        for (int[] shape : shapes3) {
            tester.testTransposeT213(shape[0], shape[1], shape[2]);
            tester.testTransposeT132(shape[0], shape[1], shape[2]);
            tester.testTransposeT312(shape[0], shape[1], shape[2]);
            tester.testTransposeT231(shape[0], shape[1], shape[2]);
            tester.testTransposeT321(shape[0], shape[1], shape[2]);
            if (memoryPrint.booleanValue()) {
                m.printReport();
            }
            System.gc();
            if (!memoryPrint.booleanValue()) continue;
            m.printReport();
        }
    }
}

