/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import java.util.Arrays;
import java.util.Iterator;
import org.javaseis.iterators.beta.IPositionIterator;

public class PositionIterator
implements IPositionIterator<int[]> {
    private static int FORWARD = 1;
    private static int REVERSE = -1;
    private static int EMPTY = 0;
    private int ndim;
    private int ndim1;
    private int scope;
    private int[] position;
    private int[] shape;
    private int incr = IPositionIterator.Direction.FORWARD.ordinal();
    private boolean flagOneEnsemble;

    public PositionIterator(int[] shapeIn, int[] positionIn, IPositionIterator.Direction directionIn, IPositionIterator.Scope scopeIn) {
        this.ndim = shapeIn.length;
        this.ndim1 = this.ndim - 1;
        if (positionIn.length < this.ndim) {
            throw new IllegalArgumentException("Dimensions of position do not match the shape");
        }
        if (scopeIn.ordinal() > this.ndim) {
            throw new IllegalArgumentException("Rank must be less than the shape dimensions");
        }
        this.incr = shapeIn[this.ndim - 1] == 0 ? EMPTY : (directionIn.equals((Object)IPositionIterator.Direction.REVERSE) ? REVERSE : FORWARD);
        this.position = positionIn;
        this.shape = shapeIn;
        this.scope = scopeIn.ordinal();
        if (this.scope >= this.position.length) {
            Arrays.fill(this.position, 0);
        } else {
            Arrays.fill(this.position, 0, this.scope, 0);
        }
        this.reset();
    }

    public PositionIterator(int[] shapeIn, int[] positionIn, IPositionIterator.Direction directionIn, int axisIndex) {
        this.ndim = shapeIn.length;
        this.ndim1 = this.ndim - 1;
        if (positionIn.length < this.ndim) {
            throw new IllegalArgumentException("Dimensions of position do not match the shape");
        }
        if (axisIndex > this.ndim) {
            throw new IllegalArgumentException("Rank must be less than the shape dimensions");
        }
        this.incr = shapeIn[this.ndim - 1] == 0 ? EMPTY : (directionIn.equals((Object)IPositionIterator.Direction.REVERSE) ? REVERSE : FORWARD);
        this.position = positionIn;
        this.shape = shapeIn;
        this.scope = axisIndex;
        if (this.scope >= this.position.length) {
            Arrays.fill(this.position, 0);
        } else {
            Arrays.fill(this.position, 0, this.scope, 0);
        }
        this.reset();
    }

    public PositionIterator(int[] shapeIn, int[] positionIn, IPositionIterator.Direction directionIn) {
        this(shapeIn, positionIn, directionIn, IPositionIterator.Scope.TRACE_AXIS);
    }

    public PositionIterator(int[] shapeIn, int[] positionIn) {
        this(shapeIn, positionIn, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
    }

    public PositionIterator(int[] shapeIn, IPositionIterator.Direction direction) {
        this(shapeIn, new int[shapeIn.length], direction, IPositionIterator.Scope.TRACE_AXIS);
    }

    public PositionIterator(int[] shapeIn) {
        this(shapeIn, new int[shapeIn.length], IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Shape = " + Arrays.toString(this.shape) + "\n");
        buf.append("Current position = " + Arrays.toString(this.getPosition()) + "\n");
        buf.append("Direction = " + (Object)((Object)this.getDirection()) + "\n");
        buf.append("Scope = " + (Object)((Object)this.getScope()) + "\n");
        return buf.toString();
    }

    @Override
    public final boolean hasNext() {
        block4: {
            block3: {
                if (this.ndim == this.scope && this.flagOneEnsemble) {
                    this.flagOneEnsemble = false;
                    return true;
                }
                if (this.incr != REVERSE) break block3;
                for (int i = this.scope; i < this.ndim; ++i) {
                    if (this.position[i] == 0) continue;
                    return true;
                }
                break block4;
            }
            if (this.incr != FORWARD) break block4;
            for (int i = this.scope; i < this.ndim; ++i) {
                if (this.position[i] >= this.shape[i] - 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final int[] next() {
        if (this.scope >= this.position.length) {
            return this.position;
        }
        if (this.incr == REVERSE) {
            int n = this.scope;
            this.position[n] = this.position[n] - 1;
            int i = this.scope;
            while (i < this.ndim1 && this.position[i] < 0) {
                this.position[i] = this.shape[i] - 1;
                int n2 = ++i;
                this.position[n2] = this.position[n2] - 1;
            }
            if (this.position[this.ndim1] < 0) {
                throw new IllegalStateException("Call to next() when hasNext() is false");
            }
        } else {
            int n = this.scope;
            this.position[n] = this.position[n] + 1;
            int i = this.scope;
            while (i < this.ndim1 && this.position[i] >= this.shape[i]) {
                this.position[i] = 0;
                int n3 = ++i;
                this.position[n3] = this.position[n3] + 1;
            }
            if (this.position[this.ndim1] >= this.shape[this.ndim1]) {
                throw new IllegalStateException("Call to next() when hasNext() is false");
            }
        }
        return (int[])this.position.clone();
    }

    @Override
    public void reset() {
        this.flagOneEnsemble = true;
        if (this.incr == REVERSE) {
            int i;
            for (i = 0; i < this.scope; ++i) {
                this.position[i] = 0;
            }
            for (i = this.scope + 1; i < this.ndim; ++i) {
                this.position[i] = this.shape[i] - 1;
            }
            this.position[this.scope] = this.shape[this.scope];
        } else if (this.incr == FORWARD) {
            Arrays.fill(this.position, 0);
            if (this.position.length > this.scope) {
                this.position[this.scope] = -1;
            }
        }
    }

    @Override
    public void setPosition(int[] positionIn) {
        if (positionIn.length < this.ndim) {
            throw new IllegalArgumentException("positionIn must be of length ndim or greater");
        }
        System.arraycopy(positionIn, this.scope, this.position, this.scope, this.ndim - this.scope);
        if (this.scope < this.position.length) {
            int n = this.scope;
            this.position[n] = this.position[n] - this.incr;
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public IPositionIterator.Direction getDirection() {
        if (this.incr == EMPTY) {
            return IPositionIterator.Direction.EMPTY;
        }
        if (this.incr == FORWARD) {
            return IPositionIterator.Direction.FORWARD;
        }
        if (this.incr == REVERSE) {
            return IPositionIterator.Direction.REVERSE;
        }
        return IPositionIterator.Direction.EMPTY;
    }

    @Override
    public void setDirection(IPositionIterator.Direction direction) {
        if (direction.equals((Object)IPositionIterator.Direction.EMPTY)) {
            this.incr = EMPTY;
        } else if (direction.equals((Object)IPositionIterator.Direction.FORWARD)) {
            this.incr = FORWARD;
        } else if (direction.equals((Object)IPositionIterator.Direction.REVERSE)) {
            this.incr = REVERSE;
        }
        this.incr = EMPTY;
    }

    @Override
    public IPositionIterator.Scope getScope() {
        return IPositionIterator.Scope.values()[this.scope];
    }

    @Override
    public void setScope(IPositionIterator.Scope s) {
        this.scope = s.ordinal();
        this.reset();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }

    @Override
    public Iterator<int[]> iterator() {
        return new PositionIterator(this.shape, this.position, this.getDirection(), this.getScope());
    }
}

