/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Iterator;
import org.javaseis.array.IMultiArray;

public class MultiArrayFrameIterator
implements Iterable,
Iterator {
    private IMultiArray _a;
    private int _ndim;
    private int _nframes;
    private int _iframe;
    private int _incr;
    private int[] _position;
    private int[] _shape;
    private int[] _frameMultiplier;
    private boolean _forward = true;

    public MultiArrayFrameIterator(IMultiArray a) {
        this.constructIterator(a, true);
    }

    public MultiArrayFrameIterator(IMultiArray a, boolean forward) {
        this.constructIterator(a, forward);
    }

    private void constructIterator(IMultiArray a, boolean forward) {
        this._ndim = a.getDimensions();
        if (this._ndim < 2) {
            throw new IllegalArgumentException("Number of dimensions must be 2 or larger");
        }
        this._a = a;
        this._shape = this._a.getShape();
        this._position = new int[this._ndim];
        this._frameMultiplier = new int[this._ndim];
        this._nframes = 1;
        for (int i = 2; i < this._ndim; ++i) {
            this._nframes *= this._shape[i];
            this._frameMultiplier[i] = this._nframes;
        }
        this._forward = forward;
        if (this._forward) {
            this._iframe = 0;
            this._incr = 1;
        } else {
            this._iframe = this._nframes;
            this._incr = -1;
        }
    }

    public Iterator iterator() {
        return new MultiArrayFrameIterator(this._a);
    }

    @Override
    public boolean hasNext() {
        if (this._forward) {
            return this._iframe < this._nframes;
        }
        return this._iframe > 0;
    }

    public IMultiArray next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Call to MultiArrayFrameIterator.next() when hasNext() is false");
        }
        this.frameToPosition();
        this._iframe += this._incr;
        return this._a.view(2, this._position);
    }

    private void frameToPosition() {
        this._position[1] = 0;
        this._position[0] = 0;
        int iframe = this._iframe;
        for (int i = this._ndim - 1; i >= 2; --i) {
            this._position[i] = iframe % this._frameMultiplier[i];
            iframe -= this._frameMultiplier[i] * this._position[i];
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("MultiArrayFrameIterator.remove() is not supported");
    }
}

