/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.ArrayList;
import java.util.List;
import org.javaseis.array.JPerfTestMultiArrayTranspose;

public class JPerfTestShapes {
    private JPerfTestShapes() {
    }

    public static List<int[]> getShapes(Size s, Dimensions dimensions) {
        int frames;
        int traces;
        long size;
        int i;
        ArrayList<int[]> shapes = new ArrayList<int[]>();
        int SAMPLES = 1601;
        int TPF_SMALL = 251;
        int TPF = 1001;
        if (s.equals((Object)Size.ONE_G)) {
            long size2 = 0x40000000L;
            int i2 = 1;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces2 = (int)((double)((long)i2 * size2) / 6404.0);
                shapes.add(new int[]{1601, traces2});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames2 = (int)((double)((long)i2 * size2) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames2});
            }
            return shapes;
        }
        if (s.equals((Object)Size.TWO_G)) {
            long size3 = 0x40000000L;
            int i3 = 2;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces3 = (int)((double)((long)i3 * size3) / 6404.0);
                shapes.add(new int[]{1601, traces3});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames3 = (int)((double)((long)i3 * size3) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames3});
            }
            return shapes;
        }
        if (s.equals((Object)Size.FOUR_G)) {
            long size4 = 0x40000000L;
            int i4 = 4;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces4 = (int)((double)((long)i4 * size4) / 6404.0);
                shapes.add(new int[]{1601, traces4});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames4 = (int)((double)((long)i4 * size4) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames4});
            }
            return shapes;
        }
        if (s.equals((Object)Size.EIGHT_G)) {
            long size5 = 0x40000000L;
            int i5 = 8;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces5 = (int)((double)((long)i5 * size5) / 6404.0);
                shapes.add(new int[]{1601, traces5});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames5 = (int)((double)((long)i5 * size5) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames5});
            }
            return shapes;
        }
        if (s.equals((Object)Size.SIXTEEN_G)) {
            long size6 = 0x40000000L;
            int i6 = 16;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces6 = (int)((double)((long)i6 * size6) / 6404.0);
                shapes.add(new int[]{1601, traces6});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames6 = (int)((double)((long)i6 * size6) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames6});
            }
            return shapes;
        }
        if (s.equals((Object)Size.THIRTYTWO_G)) {
            long size7 = 0x40000000L;
            int i7 = 32;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces7 = (int)((double)((long)i7 * size7) / 6404.0);
                shapes.add(new int[]{1601, traces7});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames7 = (int)((double)((long)i7 * size7) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames7});
            }
            return shapes;
        }
        if (s.equals((Object)Size.SIXTYFOUR_G)) {
            long size8 = 0x40000000L;
            int i8 = 64;
            if (dimensions.equals((Object)Dimensions.TWO)) {
                int traces8 = (int)((double)((long)i8 * size8) / 6404.0);
                shapes.add(new int[]{1601, traces8});
            } else if (dimensions.equals((Object)Dimensions.THREE)) {
                int frames8 = (int)((double)((long)i8 * size8) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames8});
            }
            return shapes;
        }
        if (s.equals((Object)Size.SMALL) || s.equals((Object)Size.ALL)) {
            for (i = 8; i <= 512; i *= 4) {
                size = 0x100000L;
                if (dimensions.equals((Object)Dimensions.TWO)) {
                    traces = (int)((double)((long)i * size) / 6404.0);
                    shapes.add(new int[]{1601, traces});
                    continue;
                }
                if (!dimensions.equals((Object)Dimensions.THREE)) continue;
                frames = (int)((double)((long)i * size) / 1607404.0);
                shapes.add(new int[]{1601, 251, frames});
            }
        }
        if (s.equals((Object)Size.MEDIUM) || s.equals((Object)Size.ALL)) {
            for (i = 1; i <= 12; ++i) {
                size = 0x40000000L;
                if (dimensions.equals((Object)Dimensions.TWO)) {
                    traces = (int)((double)((long)i * size) / 6404.0);
                    shapes.add(new int[]{1601, traces});
                    continue;
                }
                if (!dimensions.equals((Object)Dimensions.THREE)) continue;
                frames = (int)((double)((long)i * size) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames});
            }
        }
        if (s.equals((Object)Size.LARGE) || s.equals((Object)Size.ALL)) {
            for (i = 16; i <= 64; i *= 2) {
                size = 0x40000000L;
                if (dimensions.equals((Object)Dimensions.TWO)) {
                    traces = (int)((double)((long)i * size) / 6404.0);
                    shapes.add(new int[]{1601, traces});
                    continue;
                }
                if (!dimensions.equals((Object)Dimensions.THREE)) continue;
                frames = (int)((double)((long)i * size) / 6410404.0);
                shapes.add(new int[]{1601, 1001, frames});
            }
        }
        return shapes;
    }

    public static Size parseArgs(String[] args, Boolean memoryPrint) {
        Size s = Size.SMALL;
        if (args.length == 0) {
            s = Size.SMALL;
        } else {
            for (String arg : args) {
                if (arg.equals("-1G")) {
                    s = Size.ONE_G;
                    continue;
                }
                if (arg.equals("-2G")) {
                    s = Size.TWO_G;
                    continue;
                }
                if (arg.equals("-4G")) {
                    s = Size.FOUR_G;
                    continue;
                }
                if (arg.equals("-8G")) {
                    s = Size.EIGHT_G;
                    continue;
                }
                if (arg.equals("-16G")) {
                    s = Size.SIXTEEN_G;
                    continue;
                }
                if (arg.equals("-32G")) {
                    s = Size.THIRTYTWO_G;
                    continue;
                }
                if (arg.equals("-64G")) {
                    s = Size.SIXTYFOUR_G;
                    continue;
                }
                if (arg.equals("-small")) {
                    s = Size.SMALL;
                    continue;
                }
                if (arg.equals("-medium")) {
                    s = Size.MEDIUM;
                    continue;
                }
                if (arg.equals("-large")) {
                    s = Size.LARGE;
                    continue;
                }
                if (arg.equals("-all")) {
                    s = Size.ALL;
                    continue;
                }
                if (arg.equals("-memoryPrint")) {
                    memoryPrint = true;
                    continue;
                }
                if (arg.equals("-h")) {
                    System.out.println("Usage: " + JPerfTestMultiArrayTranspose.class.getCanonicalName() + " [-h] [-small] [-medium] [-large] [-all]\n" + "  -h         Print this help message\n" + "  -1G, -2G .... -32G, -64G Run a specific size\n" + "  -small     Run small size performance tests (up to 512MB)\n" + "  -medium    Run medium size performance tests (1GB to 12GB)\n" + "  -large     Run large size performance tests (16GB to 64GB)\n" + "  -all       Run all performance tests" + "  -memoryPrint   Print verbose memory usage information");
                    System.exit(0);
                    continue;
                }
                System.out.println("Unknown argument: " + arg);
                System.exit(-1);
            }
        }
        return s;
    }

    public static enum Dimensions {
        TWO,
        THREE;

    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE,
        ALL,
        ONE_G,
        TWO_G,
        FOUR_G,
        EIGHT_G,
        SIXTEEN_G,
        THIRTYTWO_G,
        SIXTYFOUR_G;

    }
}

