#ifndef _JMWRAPPER_H_
#define _JMWRAPPER_H_

#include <jni.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
  JMW_IN,
  JMW_OUT,
  JMW_BOTH
};

struct _JMWrapper
{
  jclass _cls;
  jobject _obj;

  jarray _jarray_byts;
  jbyte *_byts;
  jsize _byts_size;

  jarray _jarray_flts;
  jfloat *_flts;
  jsize _flts_size;

  jarray _jarray_dbls;
  jdouble *_dbls;
  jsize _dbls_size;
  
  jarray _jarray_ints;
  jint *_ints;
  jsize _ints_size;
  
  jarray _jarray_lngs;
  jlong *_lngs;
  jsize _lngs_size;
};

typedef struct _JMWrapper JMWrapper;

/* limited to a constructor with no arguments                          */
JMWrapper *jmwrapper_create  /* constructor                            */
  (const char *class_name);  /*   name of Java class                   */

/* "none" Java method has 1 arg: an in Java String with an int returned*/
int jmwrapper_none           /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc);              /*   a description of the method to call  */

/* "bytes" Java method has 2 args: an in Java String and an in/out byte*/
/*   array with an int returned                                        */
int jmwrapper_chars          /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc,               /*   a description of the method to call  */
   char *chrs,               /*   the in/out array parameter           */
   size_t max_size,          /*   the maximum size of the array        */
   int io);                  /*   either JMW_IN, JMW_OUT, or JMW_BOTH  */

  /* "floats" Java method has 2 args: an in Java String and an in/out  */
  /*   float array with an int returned                                */
int jmwrapper_floats         /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc,               /*   a description of the method to call  */
   float *flts,              /*   the in/out array parameter           */
   size_t size,              /*   the size of the array                */
   int io);                  /*   either JMW_IN, JMW_OUT, or JMW_BOTH  */

/* "doubles" Java method has 2 args: an in Java String and an in/out   */
/*   double array with an int returned                                 */
int jmwrapper_doubles        /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc,               /*   a description of the method to call  */
   double *dbls,             /*   the in/out array parameter           */
   size_t size,              /*   the size of the array                */
   int io);                  /*   either JMW_IN, JMW_OUT, or JMW_BOTH  */

/* "ints" Java method has 2 args: an in Java String and an in/out int  */
/*   array with an int returned                                        */
int jmwrapper_ints           /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc,               /*   a description of the method to call  */
   int *ints,                /*   the in/out array parameter           */
   size_t size,              /*   the size of the array                */
   int io);                  /*   either JMW_IN, JMW_OUT, or JMW_BOTH  */

/* "longs" Java method has 2 args: an in Java String and an in/out long*/
/*   array with an int returned                                        */
int jmwrapper_longs          /* Return an int                          */
  (JMWrapper *jmw,           /*   given JMWrapper object               */
   char *desc,               /*   a description of the method to call  */
   long *lngs,               /*   the in/out array parameter           */
   size_t size,              /*   the size of the array                */
   int io);                  /*   either JMW_IN, JMW_OUT, or JMW_BOTH  */

void jmwrapper_delete        /* destructor                             */
  (JMWrapper *jmw);          /*   given JMWrapper object               */

#ifdef __cplusplus
}
#endif

#endif
