/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import java.nio.ByteOrder;
import java.util.ArrayList;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.properties.Units;
import org.javaseis.util.SeisException;

public class JavaSeisDescriptor {
    private DataType _data_type = DataType.UNKNOWN;
    private DataFormat _data_format = DataFormat.FLOAT;
    private ByteOrder _byte_order = ByteOrder.nativeOrder();
    private ArrayList<AxisDefinition> _axes = new ArrayList();
    private TraceProperties _header_defn = new TraceProperties();
    private boolean _zero_size;

    public JavaSeisDescriptor(Seisio seisio) {
        this.setDataType(seisio.getDataDefinition().getDataTypeString());
        this.setFormat(seisio.getDataDefinition().getTraceFormatString());
        this.setByteOrder(seisio.getDataDefinition().getByteOrderString());
        try {
            int ndim = seisio.getGridDefinition().getNumDimensions();
            for (int k2 = 0; k2 < ndim; ++k2) {
                this.setAxis(k2, (int)seisio.getGridDefinition().getAxisLength(k2), seisio.getGridDefinition().getAxisLabel(k2).getName(), seisio.getGridDefinition().getAxisLabel(k2).getDescription(), seisio.getGridDefinition().getAxisDomainString(k2), seisio.getGridDefinition().getAxisUnitsString(k2), seisio.getGridDefinition().getAxisLogicalOrigin(k2), seisio.getGridDefinition().getAxisLogicalDelta(k2), seisio.getGridDefinition().getAxisPhysicalOrigin(k2), seisio.getGridDefinition().getAxisPhysicalDelta(k2));
            }
            TraceProperties props = seisio.getTraceProperties();
            if (props != null) {
                this.setHeaders(props.getTraceProperties());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("JavaSeisDescriptor: failure to instantiate");
        }
    }

    public JavaSeisDescriptor() {
        this.setDataType("STACK");
        this.setFormat("FLOAT");
        this.setByteOrder(ByteOrder.nativeOrder().toString());
    }

    public void setDataType(String data_type_name) {
        this._data_type = data_type_name.equalsIgnoreCase("CMP") ? DataType.CMP : (data_type_name.equalsIgnoreCase("CUSTOM") ? DataType.CUSTOM : (data_type_name.equalsIgnoreCase("OFFSET_BIN") ? DataType.OFFSET_BIN : (data_type_name.equalsIgnoreCase("RECEIVER") ? DataType.RECEIVER : (data_type_name.equalsIgnoreCase("SOURCE") ? DataType.SOURCE : (data_type_name.equalsIgnoreCase("STACK") ? DataType.STACK : DataType.UNKNOWN)))));
    }

    public void setFormat(String data_format_name) {
        this._data_format = data_format_name.equalsIgnoreCase("COMPRESSED_INT16") ? DataFormat.COMPRESSED_INT16 : (data_format_name.equalsIgnoreCase("INT16") ? DataFormat.INT16 : (data_format_name.equalsIgnoreCase("INT08") ? DataFormat.INT08 : (data_format_name.equalsIgnoreCase("COMPRESSED_INT08") ? DataFormat.COMPRESSED_INT08 : (data_format_name.equalsIgnoreCase("SEISPEG") ? DataFormat.SEISPEG : DataFormat.FLOAT))));
    }

    public void setByteOrder(String byte_order_str) {
        this._byte_order = byte_order_str.equalsIgnoreCase("BIG_ENDIAN") ? ByteOrder.BIG_ENDIAN : (byte_order_str.equalsIgnoreCase("LITTLE_ENDIAN") ? ByteOrder.LITTLE_ENDIAN : ByteOrder.nativeOrder());
    }

    public void setAxis(int dim, int length, String domain, String units, double physical_origin, double physical_delta) {
        this.setAxis(dim, length, domain, units, 0L, 1L, physical_origin, physical_delta);
    }

    public void setAxis(int dim, int length, String domain, String units, long logical_origin, long logical_delta, double physical_origin, double physical_delta) {
        AxisLabel[] axes = AxisLabel.getDefault(dim + 1);
        this.setAxis(dim, length, axes[dim].getName(), axes[dim].getDescription(), domain, units, logical_origin, logical_delta, physical_origin, physical_delta);
    }

    public void setAxis(int dim, int length, String name, String description, String domain, String units, long logical_origin, long logical_delta, double physical_origin, double physical_delta) {
        int k2 = 0;
        try {
            for (k2 = 0; k2 < dim; ++k2) {
                this._axes.get(k2);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Object null_axis = null;
            for (int k3 = k2; k3 < dim; ++k3) {
                this._axes.add(k3, (AxisDefinition)null_axis);
            }
        }
        AxisLabel label_obj = new AxisLabel(name, description);
        DataDomain domain_obj = new DataDomain(domain);
        Units units_obj = new Units(units);
        AxisDefinition axis = new AxisDefinition(label_obj, units_obj, domain_obj, length, logical_origin, logical_delta, physical_origin, physical_delta);
        try {
            this._axes.get(dim);
            this._axes.set(dim, axis);
        }
        catch (IndexOutOfBoundsException e) {
            this._axes.add(dim, axis);
        }
    }

    public void setHeaders(PropertyDescription[] props) {
        this._header_defn = new TraceProperties(props.length, props);
    }

    public void addProperty(String name, String description, int hdr_format, int count) throws Exception {
        this.addProperty(new PropertyDescription(name, description, hdr_format, count));
    }

    public void addProperties(PropertyDescription[] props) throws Exception {
        for (int k2 = 0; k2 < props.length; ++k2) {
            this.addProperty(props[k2]);
        }
    }

    public void addProperty(PropertyDescription prop) {
        if (!this._header_defn.exists(prop.getLabel())) {
            this._header_defn.addTraceProperty(prop);
        }
    }

    public GridDefinition getGridDefinition() throws SeisException {
        AxisDefinition[] axes = this.checkAxes();
        if (this._zero_size) {
            throw new SeisException("JavaSeisDescriptor.getGridDefinition: At least one axis is zero length");
        }
        GridDefinition retval = new GridDefinition(axes.length, axes);
        return retval;
    }

    public DataDefinition getDataDefinition() {
        DataDefinition retval = new DataDefinition(this._data_type, this._data_format, this._byte_order);
        return retval;
    }

    public TraceProperties getHeaderDefinition() {
        TraceProperties retval = this._header_defn.getNumProperties() > 0 ? this._header_defn : null;
        return retval;
    }

    public long getSampleCount() {
        return this.getSize(0);
    }

    public long getTraceCount() {
        return this.getSize(1);
    }

    private long getSize(int start_index) {
        long retval = 0L;
        try {
            AxisDefinition[] axes = this.checkAxes();
            if (this._zero_size) {
                return retval;
            }
            for (int k2 = start_index; k2 < axes.length; ++k2) {
                if (k2 == start_index) {
                    retval = 1L;
                }
                retval *= axes[k2].getLength();
            }
        }
        catch (SeisException e) {
            // empty catch block
        }
        return retval;
    }

    public long[] getLengths() {
        long[] retval = null;
        try {
            AxisDefinition[] axes = this.checkAxes();
            retval = new long[axes.length];
            for (int k2 = 0; k2 < axes.length; ++k2) {
                retval[k2] = axes[k2].getLength();
            }
        }
        catch (SeisException seisException) {
            // empty catch block
        }
        return retval;
    }

    public AxisDefinition[] getAxes() {
        AxisDefinition[] retval = null;
        try {
            retval = this.checkAxes();
        }
        catch (SeisException seisException) {
            // empty catch block
        }
        return retval;
    }

    public int getNumDimensions() {
        int retval = 0;
        if (!this._axes.isEmpty()) {
            retval = this._axes.toArray().length;
        }
        return retval;
    }

    private AxisDefinition[] checkAxes() throws SeisException {
        AxisDefinition[] retval = null;
        String errmes0 = "JavaSeisDescriptor.checkAxes: At least one axes is not defined";
        String errmes1 = "JavaSeisDescriptor.checkAxes: Must define at least two axes";
        if (!this._axes.isEmpty()) {
            retval = this._axes.toArray(new AxisDefinition[0]);
            if (retval.length < 2) {
                throw new SeisException(errmes1);
            }
            this._zero_size = false;
            for (int k2 = 0; !this._zero_size && k2 < retval.length; ++k2) {
                if (retval[k2] == null) {
                    throw new SeisException(errmes0);
                }
                if (retval[k2].getLength() >= 1L) continue;
                this._zero_size = true;
            }
        } else {
            throw new SeisException(errmes1);
        }
        return retval;
    }

    public void setAxes(AxisDefinition[] axes) {
        this._axes.clear();
        for (int k2 = 0; k2 < axes.length; ++k2) {
            this._axes.add(k2, axes[k2]);
        }
    }
}

