/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.access;

import edu.mines.jtk.util.ParameterSet;
import java.nio.ByteBuffer;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.util.ArrayUtil;
import org.javaseis.util.SeisException;

public class Frame {
    private long _first_trace = -1L;
    private long _last_trace = -1L;
    private int _traces_in_frame;
    private float[][] _trace_data_array;
    private TraceProperties _properties;
    private int _trace_index = -1;
    private boolean _trace_array_accessed;
    private boolean _trace_array_modified;
    private boolean _trace_array_initialized;
    private boolean _header_accessed;
    private boolean _header_modified;
    private boolean _headers_initialized;
    private boolean _read_write;
    private boolean _using_headers;

    public Frame(boolean read_write) {
        this(read_write, true);
    }

    public Frame(boolean read_write, boolean using_headers) {
        this._read_write = read_write;
        this._using_headers = using_headers;
    }

    public boolean valid() {
        boolean retval = this._first_trace > -1L && this._last_trace > -1L && (long)this._traces_in_frame == this._last_trace - this._first_trace + 1L && this._trace_array_initialized && this.headersValid();
        return retval;
    }

    public long getFirstTrace() {
        return this._first_trace;
    }

    public int getTraceCount() {
        return (int)(this._last_trace - this._first_trace + 1L);
    }

    public TraceProperties getProperties() {
        return this.getHeader();
    }

    public float[][] getArray() {
        if (this._read_write && this._trace_array_initialized) {
            this._trace_array_accessed = true;
        }
        return this._trace_data_array;
    }

    public TraceProperties getHeader() {
        TraceProperties retval = this._properties;
        if (!this._using_headers) {
            retval = null;
        } else if (this._read_write && this._headers_initialized) {
            this._header_accessed = true;
        }
        return retval;
    }

    public float[] readTrace() throws SeisException {
        if (!this._trace_array_initialized) {
            throw new SeisException("Trace array not initialized");
        }
        float[] retval = new float[this._trace_data_array[this._trace_index].length];
        for (int k2 = 0; k2 < retval.length; ++k2) {
            retval[k2] = this._trace_data_array[this._trace_index][k2];
        }
        return retval;
    }

    public int writeTrace(float[] trace) throws SeisException {
        if (!this._trace_array_initialized) {
            throw new SeisException("Trace array not initialized");
        }
        if (!this._read_write) {
            throw new SeisException("Frame not writeable");
        }
        if (trace == null) {
            return 0;
        }
        int retval = Math.min(this._trace_data_array[this._trace_index].length, trace.length);
        for (int k2 = 0; k2 < retval; ++k2) {
            this._trace_data_array[this._trace_index][k2] = trace[k2];
        }
        this._trace_array_modified = true;
        return retval;
    }

    public boolean includes(long trace) {
        boolean retval = trace >= this._first_trace && trace <= this._last_trace && this.headersValid();
        return retval;
    }

    public boolean couldHaveChanged() {
        boolean retval = this._read_write && this._trace_array_initialized && this.headersValid() && (this._trace_array_accessed || this._header_accessed || this._trace_array_modified || this._header_modified);
        return retval;
    }

    public boolean setTraceIndex(long index) {
        boolean retval;
        boolean bl = retval = index >= Integer.MIN_VALUE && index <= Integer.MAX_VALUE && this.headersValid() && this._traces_in_frame > 0;
        if (retval) {
            this._trace_index = (int)index % this._traces_in_frame;
            if (this._using_headers) {
                this._properties.setTraceIndex(this._trace_index);
            }
        }
        return retval;
    }

    public void setFrom(Frame input) {
        this._first_trace = input._first_trace;
        this._last_trace = input._last_trace;
        this._traces_in_frame = input._traces_in_frame;
        this._trace_index = input._trace_index;
        this._trace_data_array = input._trace_data_array;
        this._properties = input._properties;
        this._using_headers = input._using_headers;
        this._header_accessed = input._header_accessed;
        this._header_modified = input._header_modified;
        this._headers_initialized = input._headers_initialized;
        this._trace_array_accessed = input._trace_array_accessed;
        this._trace_array_initialized = input._trace_array_initialized;
        this._trace_array_modified = input._trace_array_modified;
        this._read_write = input._read_write;
    }

    public void setRange(long first_trace, long last_trace) {
        assert (!this.couldHaveChanged());
        this._first_trace = first_trace;
        this._last_trace = last_trace;
        this._traces_in_frame = (int)(last_trace - first_trace) + 1;
    }

    public void setArray(float[][] trace_data_array) {
        if (trace_data_array != null) {
            this._trace_array_initialized = true;
            this._trace_array_modified = true;
        } else {
            this._trace_array_initialized = false;
            this._trace_array_modified = false;
        }
        this._trace_array_accessed = false;
        this._trace_data_array = trace_data_array;
    }

    public void setProperties(TraceProperties properties) {
        if (!this._using_headers) {
            properties = null;
        }
        if (properties != null) {
            this._headers_initialized = true;
            this._header_modified = true;
        } else {
            this._headers_initialized = false;
            this._header_modified = false;
        }
        this._header_accessed = false;
        this._properties = properties;
    }

    public boolean copyTo(Frame output) {
        boolean retval = true;
        if (this._using_headers) {
            output._properties = this.copyTo(output._properties);
            boolean bl = retval = output._properties != null;
        }
        if (retval) {
            output._trace_data_array = this.copyTo(output._trace_data_array);
            boolean bl = retval = output._trace_data_array != null;
            if (retval) {
                output._first_trace = this._first_trace;
                output._last_trace = this._last_trace;
                output._traces_in_frame = this._traces_in_frame;
                output._trace_index = this._trace_index;
                output._using_headers = this._using_headers;
                output._header_accessed = this._header_accessed;
                output._header_modified = this._header_modified;
                output._headers_initialized = this._headers_initialized;
                output._trace_array_accessed = this._trace_array_accessed;
                output._trace_array_initialized = this._trace_array_initialized;
                output._trace_array_modified = this._trace_array_modified;
                output._read_write = this._read_write;
            }
        }
        return retval;
    }

    private float[][] copyTo(float[][] output) {
        if (!this.compatible(this._trace_data_array, output)) {
            output = this.createFrom(this._trace_data_array);
        }
        return this.copy(this._trace_data_array, output);
    }

    private TraceProperties copyTo(TraceProperties output) {
        if (!this.compatible(this._properties, output)) {
            output = this.createFrom(this._properties);
        }
        return this.copy(this._properties, output);
    }

    public boolean copyFrom(Frame input) {
        boolean retval = this.copyFrom(input._properties);
        if (retval) {
            retval = this.copyFrom(input._trace_data_array);
        }
        if (retval) {
            this._first_trace = input._first_trace;
            this._last_trace = input._last_trace;
            this._traces_in_frame = input._traces_in_frame;
            this._trace_index = input._trace_index;
            this._using_headers = input._using_headers;
            this._header_accessed = input._header_accessed;
            this._header_modified = input._header_modified;
            this._headers_initialized = input._headers_initialized;
            this._trace_array_accessed = input._trace_array_accessed;
            this._trace_array_initialized = input._trace_array_initialized;
            this._trace_array_modified = input._trace_array_modified;
            this._read_write = input._read_write;
        }
        return retval;
    }

    private boolean copyFrom(float[][] from) {
        boolean retval = false;
        if (!this.compatible(from, this._trace_data_array)) {
            this._trace_data_array = this.createFrom(from);
            if (this._trace_data_array != null) {
                this._trace_array_initialized = true;
            }
        }
        this._trace_data_array = this.copy(from, this._trace_data_array);
        if (this._trace_data_array != null) {
            this._trace_array_modified = true;
            retval = true;
        }
        return retval;
    }

    private boolean copyFrom(TraceProperties from) {
        boolean retval = false;
        if (!this._using_headers) {
            retval = true;
        } else {
            if (!this.compatible(from, this._properties)) {
                this._properties = this.createFrom(from);
                if (this._properties != null) {
                    this._headers_initialized = true;
                }
            }
            this._properties = this.copy(from, this._properties);
            if (this._properties != null) {
                this._header_modified = true;
                retval = true;
            }
        }
        return retval;
    }

    private float[][] createFrom(float[][] input) {
        Object retval;
        if (input == null) {
            return null;
        }
        try {
            retval = new float[input.length][];
            for (int k2 = 0; k2 < input.length; ++k2) {
                retval[k2] = new float[input[k2].length];
            }
        }
        catch (Exception e) {
            retval = null;
        }
        return retval;
    }

    private TraceProperties createFrom(TraceProperties input) {
        TraceProperties output;
        if (input == null) {
            return null;
        }
        ParameterSet ps = new ParameterSet();
        input.toParameterSet(ps);
        try {
            output = new TraceProperties(ps);
        }
        catch (SeisException e) {
            return null;
        }
        return output;
    }

    private float[][] copy(float[][] input, float[][] output) {
        if (input == null || output == null) {
            return null;
        }
        try {
            for (int k2 = 0; k2 < input.length; ++k2) {
                ArrayUtil.arraycopy(input[k2], 0, output[k2], 0, input[k2].length);
            }
        }
        catch (Exception e) {
            return null;
        }
        return output;
    }

    private TraceProperties copy(TraceProperties input, TraceProperties output) {
        if (input == null || output == null) {
            return null;
        }
        ByteBuffer ibb = input.getBuffer();
        int position = ibb.position();
        int limit = ibb.limit();
        ByteBuffer obb = output.getBuffer();
        if (obb == null) {
            obb = ByteBuffer.allocateDirect(ibb.capacity());
            obb.order(ibb.order());
            output.setBuffer(obb);
        }
        try {
            ibb.position(0);
            ibb.limit(ibb.capacity());
            obb.position(0);
            obb.limit(ibb.capacity());
            for (int k2 = 0; k2 < ibb.capacity(); ++k2) {
                obb.put(ibb.get());
            }
            ibb.position(position);
            ibb.limit(limit);
            obb.position(position);
            obb.limit(limit);
        }
        catch (Exception e) {
            return null;
        }
        return output;
    }

    private boolean compatible(float[][] input, float[][] output) {
        if (input == null || output == null) {
            return false;
        }
        boolean retval = input.length == output.length;
        for (int k2 = 0; retval && k2 < input.length; ++k2) {
            retval = input[k2].length == output[k2].length;
        }
        return retval;
    }

    private boolean compatible(TraceProperties input, TraceProperties output) {
        PropertyDescription[] opd;
        if (input == null || output == null) {
            return false;
        }
        PropertyDescription[] ipd = input.getTraceProperties();
        boolean retval = ipd.length == (opd = output.getTraceProperties()).length;
        ByteBuffer ibb = input.getBuffer();
        ByteBuffer obb = output.getBuffer();
        boolean test = ibb != null && obb != null;
        boolean bl = retval = ibb == null && obb == null || test;
        if (test) {
            retval = ibb.capacity() == obb.capacity();
        }
        for (int k2 = 0; retval && k2 < ipd.length; ++k2) {
            retval = ipd[k2].getCount() == opd[k2].getCount() && ipd[k2].getFormat() == opd[k2].getFormat() && ipd[k2].getLabel().equalsIgnoreCase(opd[k2].getLabel());
        }
        return retval;
    }

    public void resetWrite() {
        this._header_accessed = false;
        this._header_modified = false;
        this._trace_array_accessed = false;
        this._trace_array_modified = false;
    }

    public void init() {
        this._first_trace = -1L;
        this._last_trace = -1L;
        this._traces_in_frame = 0;
        this._trace_index = -1;
        this._properties = null;
        this._trace_data_array = null;
        this._header_accessed = false;
        this._header_modified = false;
        this._headers_initialized = false;
        this._trace_array_accessed = false;
        this._trace_array_initialized = false;
        this._trace_array_modified = false;
    }

    private boolean headersValid() {
        boolean retval = this._properties != null ? this._headers_initialized : !this._using_headers;
        return retval;
    }
}

