/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualFoldersSimple;
import org.javaseis.io.VirtualIO;
import org.javaseis.parallel.MPIContext;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.tests.TestUtil;

public class ParallelVirtualIOTest {
    public static void main(String[] args) throws Exception {
        int i;
        ParameterSet seisParameters = null;
        String[] vfioDirs = null;
        String path = null;
        String host = null;
        int numExtents = 0;
        long fileSize = 0L;
        long frameSize = 0L;
        int bufSize = 0;
        int frameCount = 0;
        MPIContext pc = new MPIContext();
        pc.init(args);
        int rank = pc.rank();
        pc.masterPrint("Parallel Virtual I/O Test");
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        pc.serialPrint(" Task " + rank + " host " + host);
        String defaultPath = TestUtil.getScratchPath("VioTest.properties");
        VirtualFolders vFolders = TestUtil.getVirtualFolders(defaultPath);
        if (pc.isMaster()) {
            seisParameters = ParameterSetIO.argsToParameters(args);
            path = seisParameters.getString("path", defaultPath);
            frameSize = seisParameters.getLong("frameSize", 786432L);
            frameCount = seisParameters.getInt("frameCount", 25);
            bufSize = 4 * (int)frameSize;
            vfioDirs = seisParameters.getStrings("vfioDirs", null);
            if (vfioDirs == null) {
                VirtualFolder[] folders = vFolders.getFolders();
                vfioDirs = new String[folders.length];
                for (int i2 = 0; i2 < folders.length; ++i2) {
                    vfioDirs[i2] = folders[i2].getPath();
                }
            }
            numExtents = seisParameters.getInt("numExtents", 20 * vfioDirs.length);
            fileSize = bufSize * frameCount * pc.size();
            seisParameters.setString("path", path);
            seisParameters.setLong("frameSize", frameSize);
            seisParameters.setInt("frameCount", frameCount);
            seisParameters.setStrings("vfioDirs", vfioDirs);
            seisParameters.setInt("numExtents", numExtents);
            seisParameters.setLong("fileSize", fileSize);
            System.out.format("\nNumber of Extents  : %d\n", numExtents);
            System.out.format("Frame Size,  bytes   : %d\n", frameSize);
            System.out.format("Buf Size,  bytes     : %d\n", bufSize);
            System.out.format("Frame count per task : %d\n", frameCount);
            System.out.format("File Size, bytes     : %d\n", fileSize);
            System.out.format("Virtual file path    : %s\n", path);
            System.out.println("Virtual directories:");
            for (String dir : vfioDirs) {
                System.out.println("  - " + dir);
            }
            File f = new File(path);
            if (f.exists()) {
                f.delete();
            }
            ExtentPolicyRandom policy = new ExtentPolicyRandom();
            VirtualIO vio = new VirtualIO(path, "TraceFile", new VirtualFoldersSimple(path, vfioDirs, new ExtentPolicyRandom()), fileSize, numExtents, frameSize);
            vio.close();
            vio = null;
            System.gc();
        }
        System.out.flush();
        seisParameters = ParameterSetIO.broadcast(seisParameters, pc);
        path = ParameterSetIO.getRequiredString(seisParameters, "path");
        fileSize = ParameterSetIO.getRequiredLong(seisParameters, "fileSize");
        frameSize = ParameterSetIO.getRequiredLong(seisParameters, "frameSize");
        frameCount = ParameterSetIO.getRequiredInt(seisParameters, "frameCount");
        numExtents = ParameterSetIO.getRequiredInt(seisParameters, "numExtents");
        bufSize = 4 * (int)frameSize;
        vfioDirs = ParameterSetIO.getRequiredStrings(seisParameters, "vfioDirs");
        VirtualIO vio = new VirtualIO(path, "rw", new VirtualFoldersSimple(path, vfioDirs, new ExtentPolicyRandom()));
        ByteBuffer buf = ByteBuffer.allocateDirect(bufSize);
        IntBuffer ibuf = buf.asIntBuffer();
        int[] ival = new int[(int)frameSize];
        vio.trackTime(true);
        pc.masterPrint("\nBegin parallel write");
        pc.barrier();
        int jval = frameCount * pc.rank();
        long position = jval * bufSize;
        for (i = 0; i < frameCount; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            Arrays.fill(ival, jval + i);
            ibuf.put(ival);
            vio.write(buf);
            position += (long)bufSize;
        }
        pc.barrier();
        pc.masterPrint("Parallel write completed\n Task    I/O Time   Load Time   Lock Time   Virt Time    I/O Rate   Virt Rate");
        pc.serialPrint(String.format("%5d%12.2f%12.4f%12.4f%12.2f%12.2f%12.2f", pc.rank(), Float.valueOf(vio.getIoTime()), Float.valueOf(vio.getLoadTime()), Float.valueOf(vio.getLockTime()), Float.valueOf(vio.getVirtualTime()), Float.valueOf(vio.getIoRate()), Float.valueOf(vio.getVirtualRate())));
        vio.close();
        vio = null;
        System.gc();
        vio = new VirtualIO(path, "r");
        vio.trackTime(true);
        pc.masterPrint("\nBegin parallel read");
        pc.barrier();
        jval = frameCount * pc.rank();
        position = jval * bufSize;
        for (i = 0; i < frameCount; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            vio.read(buf);
            ibuf.get(ival);
            int j = 0;
            while ((long)j < frameSize) {
                assert (ival[j] == jval + i) : "VirtualIO Read Verification Failed:\n rank " + pc.rank() + " frame " + i + " ival " + ival[j] + " jval " + (jval + i);
                ++j;
            }
            position += (long)bufSize;
        }
        pc.barrier();
        pc.masterPrint("Parallel read completed\n Task    I/O Time   Load Time   Virt Time    I/O Rate   Virt Rate");
        pc.serialPrint(String.format("%5d%12.2f%12.2f%12.2f%12.2f%12.2f", pc.rank(), Float.valueOf(vio.getIoTime()), Float.valueOf(vio.getLoadTime()), Float.valueOf(vio.getVirtualTime()), Float.valueOf(vio.getIoRate()), Float.valueOf(vio.getVirtualRate())));
        vio.close();
        pc.barrier();
        pc.masterPrint("\n*** Parallel Virtual I/O Test Succeeded ***");
        pc.finish();
    }
}

