/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Arrays;
import java.util.logging.Logger;
import mpi.MPI;
import mpi.MPIException;
import org.javaseis.array.BackingArray;
import org.javaseis.array.LongArrayStorage;
import org.javaseis.array.TransposeType;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayTraceIterator;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.MPIContext;

public class DistributedArrayLongArrayTest {
    private static final Logger LOG = Logger.getLogger(DistributedArrayLongArrayTest.class.getPackage().getName());
    public IParallelContext _pc = new MPIContext();

    public DistributedArrayLongArrayTest(String[] args) throws MPIException {
        this._pc.init(args);
        this._pc.masterPrint("DistributedArray Tests");
        this._pc.serialPrint(MPI.Get_processor_name() + " Task " + this._pc.rank());
        LongArrayStorage.TEST_MODE = true;
        int[] l1 = new int[]{11, 13, 3};
        int[] l2 = new int[]{13, 101, 55};
        int inc = 5;
        for (int i = l1[0]; i <= l2[0]; i += inc) {
            for (int j = l1[1]; j <= l2[1]; j += inc) {
                for (int k = l1[2]; k <= l2[2]; k += inc) {
                    int[] shape = new int[]{i, j, k};
                    DistributedArray da = this.createDistributedArray(BackingArray.Type.JAVA_LONG_ARRAY, shape);
                    da.transpose(TransposeType.T132);
                    DistributedArrayLongArrayTest.validateData(da);
                }
            }
        }
        this._pc.finish();
    }

    public static void main(String[] args) throws MPIException {
        new DistributedArrayLongArrayTest(args);
        LOG.info("*** org.javaseis.tests.DistributedArrayTest SUCCESS ***");
    }

    public DistributedArray createDistributedArray(BackingArray.Type type, int[] lengths) {
        int rank = this._pc.rank();
        String className = new DistributedArray().getClass().toString();
        if (rank == 0) {
            LOG.info(className);
            LOG.info("Shape = " + Arrays.toString(lengths) + "  backing array type = " + (Object)((Object)type));
        }
        this._pc.barrier();
        int ndim = 3;
        long maxArrayLength = lengths[0] * lengths[1] * lengths[2];
        int[] decomp = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
        DistributedArray da = new DistributedArray(this._pc, Float.TYPE, ndim, 1, lengths, decomp, maxArrayLength, type);
        DistributedArrayLongArrayTest.putData(da);
        DistributedArrayLongArrayTest.validateData(da);
        da.reshape(lengths);
        DistributedArrayLongArrayTest.validateData(da);
        return da;
    }

    private static void putData(DistributedArray da) {
        int[] shape = da.getShape();
        float[] t = new float[shape[0]];
        DistributedArrayTraceIterator<float[]> it = new DistributedArrayTraceIterator<float[]>(da, t);
        while (it.hasNext()) {
            t = it.next();
            for (int i = 0; i < t.length; ++i) {
                t[i] = i;
            }
            it.putData(t);
        }
    }

    private static void validateData(DistributedArray da) {
        int[] shape = da.getShape();
        float[] t = new float[shape[0]];
        DistributedArrayTraceIterator<float[]> it = new DistributedArrayTraceIterator<float[]>(da, t);
        while (it.hasNext()) {
            t = it.next();
            for (int i = 0; i < t.length; ++i) {
                assert (t[i] == (float)i);
            }
        }
    }
}

