/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.Transcaler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayFrameIterator;
import org.javaseis.parallel.DistributedArrayGlobalTraceAccessor;
import org.javaseis.parallel.IParallelContext;
import org.javaseis.parallel.UniprocessorContext;

public class DistributedArrayMosaicPlot
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public static boolean INCLUDE_SHAPE_INFORMATION_IN_TITLE = true;
    public static boolean INCLUDE_PLOT_COUNTER_IN_TITLE = true;
    public static boolean SHOW_FRAME_VIEW = true;
    public static boolean SHOW_CROSSFRAME_VIEW = true;
    public static boolean SHOW_SLICE_VIEW = true;
    public static final int ORIENTATION_FRAME = 2;
    public static final int ORIENTATION_CROSSFRAME = 1;
    public static final int ORIENTATION_SLICE = 0;
    private int _plotOrientation = 2;
    private static final boolean VERBOSE = false;
    private DistributedArray _a;
    private DistributedArrayGlobalTraceAccessor _traceAccessor;
    private final int _elementOffset;
    private static int _plotCounter;
    private final IParallelContext _parallelContext;
    private final int _rank;
    private int _nFrames;
    private int _nTraces;
    private int _nSamples;
    private int _elementCount;
    private MyPlotPanel _plotPanel;
    private JSlider _slider;
    private MyIntegerTextField _planeValueField;
    private float[][] _plotData;
    private Sampling _xSampling;
    private Sampling _ySampling;
    private float _minAmpFrame;
    private float _maxAmpFrame;
    private float _minAmpCrossframe;
    private float _maxAmpCrossframe;
    private float _minAmpSlice;
    private float _maxAmpSlice;
    private static MyControlPanel _myControlPanel;
    private static Point _saveWindowLocation;
    private static Dimension _saveWindowSize;
    private final long[] _axisLogicalOrigins;
    private final long[] _axisLogicalDeltas;
    private JTextField _mouseTrackingField;

    private DistributedArrayMosaicPlot() {
        throw new RuntimeException("don't use this constructor");
    }

    private DistributedArrayMosaicPlot(DistributedArray a, DistributedArrayGlobalTraceAccessor traceAccessor, int plotOrientation, long[] axisLogicalOrigins, long[] axisLogicalDeltas, int elementOffset) {
        if (a.getDimensions() < 3) {
            throw new IllegalArgumentException("DistributedArray dimensions must be >= 3");
        }
        if (a.getElementCount() > 2) {
            throw new IllegalArgumentException("DistributedArray element count must be <= 2");
        }
        if (elementOffset + 1 > a.getElementCount()) {
            throw new IllegalArgumentException("illegal elementOffset = " + elementOffset);
        }
        MyControlPanel.getAmplitudeJTextField().addActionListener(this);
        MyControlPanel.getAmplitudeClipMinJTextField().addActionListener(this);
        MyControlPanel.getAmplitudeClipMaxJTextField().addActionListener(this);
        MyControlPanel.getRangeScalingButton().addActionListener(this);
        MyControlPanel.getScaleFactorButton().addActionListener(this);
        this._a = a;
        this._plotOrientation = plotOrientation;
        this._axisLogicalOrigins = axisLogicalOrigins;
        this._axisLogicalDeltas = axisLogicalDeltas;
        this._elementOffset = elementOffset;
        this._parallelContext = a.getParallelContext();
        this._rank = this._parallelContext.rank();
        int[] shape = this._a.getShape();
        this._nFrames = shape[2];
        this._nTraces = shape[1];
        this._nSamples = shape[0];
        this._elementCount = this._a.getElementCount();
        this._traceAccessor = traceAccessor;
        if (this._rank == 0) {
            this._plotPanel = new MyPlotPanel();
            this._plotPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 15));
            this._plotPanel.getTile(0, 0).addMouseMotionListener((MouseMotionListener)new MyMouseMotionHandler("tile00"));
            this.setUpGUI();
            switch (this._plotOrientation) {
                case 2: {
                    this._slider.setValue(this._nFrames / 2);
                    break;
                }
                case 1: {
                    this._slider.setValue(this._nTraces / 2);
                    break;
                }
                case 0: {
                    this._slider.setValue(this._nSamples / 2);
                }
            }
        }
    }

    private void setUpGUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        int N = this._a.getShape()[this._plotOrientation] - 1;
        int MAX_TICKS = 12;
        int majorTickSpacing = 10;
        if (this._axisLogicalOrigins != null && this._axisLogicalDeltas != null) {
            int annotationStart = (int)this._axisLogicalOrigins[this._plotOrientation];
            int annotationEnd = (int)(this._axisLogicalOrigins[this._plotOrientation] + this._axisLogicalDeltas[this._plotOrientation] * (long)N);
            while ((annotationEnd - annotationStart) / majorTickSpacing > MAX_TICKS) {
                majorTickSpacing += 10;
            }
            int minorTickSpacing = majorTickSpacing / 10;
            this._slider = new JSlider(0, annotationStart, annotationEnd, annotationStart);
            this._slider.setPaintLabels(true);
            this._slider.setPaintTicks(true);
            this._slider.setPaintTrack(false);
            this._slider.setMajorTickSpacing(majorTickSpacing);
            this._slider.setMinorTickSpacing(minorTickSpacing);
            if ((long)minorTickSpacing <= this._axisLogicalDeltas[this._plotOrientation]) {
                this._slider.setSnapToTicks(true);
            } else {
                this._slider.setSnapToTicks(false);
            }
        } else {
            while (N / majorTickSpacing > MAX_TICKS) {
                majorTickSpacing += 10;
            }
            int minorTickSpacing = majorTickSpacing / 10;
            this._slider = new JSlider(0, 0, N, 0);
            this._slider.setPaintLabels(true);
            this._slider.setPaintTicks(true);
            this._slider.setPaintTrack(false);
            this._slider.setMajorTickSpacing(majorTickSpacing);
            this._slider.setMinorTickSpacing(minorTickSpacing);
            if (minorTickSpacing <= 1) {
                this._slider.setSnapToTicks(true);
            } else {
                this._slider.setSnapToTicks(false);
            }
        }
        this._slider.addChangeListener(this);
        JPanel planeValuePanel = new JPanel();
        this._planeValueField = new MyIntegerTextField(this._slider.getValue(), this._slider.getMinimum(), this._slider.getMaximum(), 10);
        this._planeValueField.setHorizontalAlignment(0);
        this._planeValueField.addActionListener(this);
        switch (this._plotOrientation) {
            case 2: {
                planeValuePanel.add(new JLabel("Go To Frame:"));
                break;
            }
            case 1: {
                planeValuePanel.add(new JLabel("Go To Crossframe:"));
                break;
            }
            case 0: {
                planeValuePanel.add(new JLabel("Go To Slice:"));
                break;
            }
            default: {
                planeValuePanel.add(new JLabel("Value:"));
            }
        }
        planeValuePanel.add(this._planeValueField);
        JPanel mouseTrackingPanel = new JPanel();
        this._mouseTrackingField = new JTextField(25);
        this._mouseTrackingField.setHorizontalAlignment(2);
        mouseTrackingPanel.add(new JLabel("Position:"));
        mouseTrackingPanel.add(this._mouseTrackingField);
        JPanel widgetPanel = new JPanel(new BorderLayout());
        JPanel accessoryPanel = new JPanel(new BorderLayout());
        accessoryPanel.add("North", planeValuePanel);
        accessoryPanel.add("South", mouseTrackingPanel);
        this.add("Center", (Component)((Object)this._plotPanel));
        this.add("South", widgetPanel);
        widgetPanel.add("North", this._slider);
        widgetPanel.add("South", accessoryPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == MyControlPanel.getAmplitudeJTextField()) {
            this._plotPanel.updatePlot();
        } else if (src == MyControlPanel.getAmplitudeClipMinJTextField()) {
            this._plotPanel.updatePlot();
        } else if (src == MyControlPanel.getAmplitudeClipMaxJTextField()) {
            this._plotPanel.updatePlot();
        } else if (src == MyControlPanel.getRangeScalingButton()) {
            MyControlPanel.setScaleType(MyControlPanel.getRangeScalingButton().getActionCommand());
            this._plotPanel.updatePlot();
        } else if (src == MyControlPanel.getScaleFactorButton()) {
            MyControlPanel.setScaleType(MyControlPanel.getScaleFactorButton().getActionCommand());
            this._plotPanel.updatePlot();
        } else if (src == this._planeValueField) {
            this._slider.setValue(this._planeValueField.getValue());
        } else if (src == this._mouseTrackingField) {
            // empty if block
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this._slider) {
            boolean isAdjusting = this._slider.getValueIsAdjusting();
            int val = this._slider.getValue();
            if (isAdjusting) {
                return;
            }
            try {
                this._planeValueField.setValue(val);
                this.setPlaneValue(val);
            }
            catch (Exception ex) {
                System.out.println("setPlaneIndex exception = " + ex.getMessage());
            }
            catch (Error er) {
                System.out.println("setPlaneIndex error = " + er.getMessage());
            }
        }
    }

    public DistributedArrayGlobalTraceAccessor getGlobalTraceAccessor() {
        return this._traceAccessor;
    }

    public synchronized void setPlaneValue(int sliderVal) {
        if (this._axisLogicalOrigins == null || this._axisLogicalDeltas == null) {
            this.setPlaneIndex(sliderVal);
        } else {
            long index = ((long)sliderVal - this._axisLogicalOrigins[this._plotOrientation]) / this._axisLogicalDeltas[this._plotOrientation];
            this.setPlaneIndex((int)index);
        }
    }

    public synchronized void setPlaneIndex(int planeIndex) {
        switch (this._plotOrientation) {
            case 2: {
                this.setFrame(planeIndex);
                break;
            }
            case 1: {
                this.setCrossframe(planeIndex);
                break;
            }
            case 0: {
                this.setSlice(planeIndex);
            }
        }
    }

    public void setFrame(int frameIndex) {
        long t0 = System.currentTimeMillis();
        float[][] traceBuf = new float[this._nTraces][this._nSamples * this._elementCount];
        int[] position = new int[3];
        position[2] = frameIndex;
        for (int traceIndex = 0; traceIndex < this._nTraces; ++traceIndex) {
            position[1] = traceIndex;
            position[0] = 0;
            this._traceAccessor.getGlobalTrace(traceBuf[traceIndex], position);
        }
        this.plotPlane(traceBuf);
        long t1 = System.currentTimeMillis();
    }

    public void setCrossframe(int traceIndex) {
        long t0 = System.currentTimeMillis();
        float[][] traceBuf = new float[this._nFrames][this._nSamples * this._elementCount];
        int[] position = new int[3];
        position[1] = traceIndex;
        for (int frameIndex = 0; frameIndex < this._nFrames; ++frameIndex) {
            position[2] = frameIndex;
            position[0] = 0;
            this._traceAccessor.getGlobalTrace(traceBuf[frameIndex], position);
        }
        this.plotPlane(traceBuf);
        long t1 = System.currentTimeMillis();
    }

    public void setSlice(int sliceIndex) {
        long t0 = System.currentTimeMillis();
        float[] tmpBuf = new float[this._elementCount];
        float[][] traceBuf = this._elementCount == 2 ? new float[this._nFrames][this._nTraces * 2] : new float[this._nFrames][this._nTraces];
        int[] position = new int[3];
        for (int frameIndex = 0; frameIndex < this._nFrames; ++frameIndex) {
            position[2] = frameIndex;
            for (int traceIndex = 0; traceIndex < this._nTraces; ++traceIndex) {
                position[1] = traceIndex;
                position[0] = sliceIndex;
                this._traceAccessor.getGlobalSubTrace(tmpBuf, position, 0, this._elementCount);
                if (this._elementCount == 2) {
                    traceBuf[frameIndex][2 * traceIndex] = tmpBuf[0];
                    traceBuf[frameIndex][2 * traceIndex + 1] = tmpBuf[1];
                    continue;
                }
                traceBuf[frameIndex][traceIndex] = tmpBuf[0];
            }
        }
        this.plotPlane(traceBuf);
        long t1 = System.currentTimeMillis();
    }

    public void plotPlane(float[][] data) {
        this._plotData = this._elementCount == 2 && this._elementOffset < 0 ? new float[data.length][data[0].length / 2] : new float[data.length][data[0].length];
        int imax = this._plotData.length;
        int jmax = this._plotData[0].length;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < imax; ++i) {
            for (int j = 0; j < jmax; ++j) {
                float plotVal;
                if (this._elementCount == 1) {
                    plotVal = data[i][j];
                } else if (this._elementOffset < 0) {
                    float val0 = data[i][2 * j];
                    float val1 = data[i][2 * j + 1];
                    plotVal = (float)Math.sqrt(val0 * val0 + val1 * val1);
                } else {
                    plotVal = data[i][this._elementCount * j + this._elementOffset];
                }
                if (plotVal < min) {
                    min = plotVal;
                }
                if (plotVal > max) {
                    max = plotVal;
                }
                this._plotData[i][j] = plotVal;
            }
        }
        switch (this._plotOrientation) {
            case 2: {
                this._minAmpFrame = min;
                this._maxAmpFrame = max;
                break;
            }
            case 1: {
                this._minAmpCrossframe = min;
                this._maxAmpCrossframe = max;
                break;
            }
            case 0: {
                this._minAmpSlice = min;
                this._maxAmpSlice = max;
            }
        }
        this._xSampling = new Sampling(this._plotData[0].length, 1.0, 0.0);
        this._ySampling = new Sampling(this._plotData.length, 1.0, 0.0);
        this._plotPanel.updatePlot();
    }

    public static void showAsModalDialog(DistributedArray a, String title) {
        DistributedArrayMosaicPlot.showAsModalDialog(a, null, null, title, a.getParallelContext().rank(), -1);
    }

    public static void showAsModalDialog(DistributedArray a, String title, int rank) {
        DistributedArrayMosaicPlot.showAsModalDialog(a, null, null, title, rank, -1);
    }

    public static void showAsModalDialog(DistributedArray a, String title, int rank, int elementOffset) {
        DistributedArrayMosaicPlot.showAsModalDialog(a, null, null, title, rank, elementOffset);
    }

    public static void showAsModalDialog(DistributedArray a, long[] axisLogicalOrigins, long[] axisLogicalDeltas, String title, int rank) {
        DistributedArrayMosaicPlot.showAsModalDialog(a, axisLogicalOrigins, axisLogicalDeltas, title, rank, -1);
    }

    public static void showAsModalDialog(DistributedArray a, long[] axisLogicalOrigins, long[] axisLogicalDeltas, String title, int rank, int elementOffset) {
        ++_plotCounter;
        a.getParallelContext().barrier();
        DistributedArrayGlobalTraceAccessor traceAccessor = new DistributedArrayGlobalTraceAccessor("DistributedArrayMosaicPlot", 999, a, false);
        if (rank == 0 && _myControlPanel == null) {
            _myControlPanel = new MyControlPanel();
        }
        int nviews = 0;
        DistributedArrayMosaicPlot[] plot = new DistributedArrayMosaicPlot[3];
        if (SHOW_FRAME_VIEW) {
            plot[nviews] = new DistributedArrayMosaicPlot(a, traceAccessor, 2, axisLogicalOrigins, axisLogicalDeltas, elementOffset);
            ++nviews;
        }
        if (SHOW_CROSSFRAME_VIEW) {
            plot[nviews] = new DistributedArrayMosaicPlot(a, traceAccessor, 1, axisLogicalOrigins, axisLogicalDeltas, elementOffset);
            ++nviews;
        }
        if (SHOW_SLICE_VIEW) {
            plot[nviews] = new DistributedArrayMosaicPlot(a, traceAccessor, 0, axisLogicalOrigins, axisLogicalDeltas, elementOffset);
            ++nviews;
        }
        if (rank == 0) {
            if (INCLUDE_SHAPE_INFORMATION_IN_TITLE) {
                title = _plotCounter + ":    " + title;
            }
            if (INCLUDE_SHAPE_INFORMATION_IN_TITLE) {
                int[] shape = a.getShape();
                title = title + String.format("    Shape = %d %d %d", shape[0], shape[1], shape[2]);
            }
            JDialog f = new JDialog(new JFrame(), title, true);
            f.setDefaultCloseOperation(2);
            JPanel gridPanel = new JPanel(new GridLayout(1, nviews));
            for (int i = 0; i < nviews; ++i) {
                gridPanel.add(plot[i]);
            }
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add("Center", gridPanel);
            mainPanel.add("South", _myControlPanel);
            f.getContentPane().add(mainPanel);
            if (_saveWindowLocation != null && _saveWindowSize != null) {
                f.setLocation(_saveWindowLocation);
                f.setSize(_saveWindowSize);
            } else {
                f.setSize(new Dimension(1500, 500));
            }
            f.setVisible(true);
            _saveWindowLocation = f.getLocation();
            _saveWindowSize = f.getSize();
            plot[0].getGlobalTraceAccessor().killWorkers(0);
        }
    }

    public static void main(String[] args) {
        UniprocessorContext pc = new UniprocessorContext();
        int[] lengths = new int[]{201, 301, 401};
        int[] decompTypes = new int[]{Decomposition.NONE, Decomposition.BLOCK, Decomposition.BLOCK};
        long maxlen = DistributedArray.getShapeLength(3, 1, lengths);
        DistributedArray da = new DistributedArray((IParallelContext)pc, Float.TYPE, 3, 1, lengths, decompTypes, maxlen);
        float[][] frame = new float[lengths[1]][lengths[0]];
        DistributedArrayFrameIterator<float[][]> dafi = new DistributedArrayFrameIterator<float[][]>(da, frame);
        double denominator = 0.5 * Math.sqrt(lengths[2] * lengths[2] + lengths[1] * lengths[1] + lengths[0] * lengths[0]);
        while (dafi.hasNext()) {
            dafi.next();
            int frameNum = dafi.getPosition()[2];
            double frameSq = frameNum - lengths[2] / 2;
            frameSq *= frameSq;
            for (int j = 0; j < lengths[1]; ++j) {
                double traceSq = j - lengths[1] / 2;
                traceSq *= traceSq;
                for (int i = 0; i < lengths[0]; ++i) {
                    double sampleSq = i - lengths[0] / 2;
                    sampleSq *= sampleSq;
                    frame[j][i] = (float)(1.0 - Math.sqrt(frameSq + traceSq + sampleSq) / denominator);
                }
            }
            da.putFrame(frame, dafi.getPosition());
        }
        long[] logicalOrigins = new long[]{0L, 0L, 0L};
        long[] logicalDeltas = new long[]{1L, 1L, 1L};
        DistributedArrayMosaicPlot.showAsModalDialog(da, logicalOrigins, logicalDeltas, "Distributed Array Plot Test", pc.rank());
    }

    public class MyIntegerTextField
    extends JTextField {
        private static final int _defaultColumns = 10;
        private int _minValue;
        private int _maxValue;

        public MyIntegerTextField(int value) {
            this(value, 10);
        }

        public MyIntegerTextField(int value, int columns) {
            this(value, columns, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public MyIntegerTextField(int value, int min, int max, int columns) {
            super(Integer.toString(value), columns);
            this._minValue = min;
            this._maxValue = max;
        }

        public void setMinValue(int value) {
            this._minValue = value;
        }

        public void setMaxValue(int value) {
            this._maxValue = value;
        }

        public void setValue(int value) {
            super.setText(Integer.toString(Math.max(this._minValue, Math.min(this._maxValue, value))));
        }

        public int getValue() {
            return Integer.parseInt(super.getText());
        }
    }

    private class MyMouseMotionHandler
    implements MouseMotionListener {
        private String _name = "";

        public MyMouseMotionHandler() {
            this("");
        }

        public MyMouseMotionHandler(String name) {
            this._name = name;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.updateLocation(event);
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.updateLocation(event);
        }

        private void updateLocation(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            if (event.getSource().getClass() == Tile.class) {
                Tile tile = (Tile)event.getSource();
                Transcaler t = tile.getTranscaler();
                Projector hp = tile.getHorizontalProjector();
                Projector vp = tile.getVerticalProjector();
                double xVal = hp.v(t.x(x));
                double yVal = vp.v(t.y(y));
                int xpos = (int)Math.round(xVal);
                int ypos = (int)Math.round(yVal);
                if (xpos >= 0 && xpos < DistributedArrayMosaicPlot.this._plotData.length && ypos >= 0 && ypos < DistributedArrayMosaicPlot.this._plotData[xpos].length) {
                    String s = String.format("(x,y,val) = (%d, %d, %f)", xpos, ypos, Float.valueOf(DistributedArrayMosaicPlot.this._plotData[xpos][ypos]));
                    DistributedArrayMosaicPlot.this._mouseTrackingField.setText(s);
                }
                int n1 = DistributedArrayMosaicPlot.this._plotData[0].length;
                int n2 = DistributedArrayMosaicPlot.this._plotData.length;
            }
        }
    }

    private static class MyControlPanel
    extends JPanel {
        public static final String SCALE_FACTOR = "scaleFactor";
        public static final String RANGE_SCALING = "rangeScaling";
        private static final long serialVersionUID = 1L;
        private static final JTextField _ampScaleField = new JTextField(8);
        private static final JTextField _ampClipMinField = new JTextField(8);
        private static final JTextField _ampClipMaxField = new JTextField(8);
        private static final JRadioButton _scaleFactorButton = new JRadioButton("Use amplitude scale factor:");
        private static final JRadioButton _rangeScalingButton = new JRadioButton("Use clip range:");
        private static String _scaleType;

        public MyControlPanel() {
            ButtonGroup group = new ButtonGroup();
            group.add(_scaleFactorButton);
            group.add(_rangeScalingButton);
            _scaleFactorButton.setActionCommand(SCALE_FACTOR);
            _scaleFactorButton.setSelected(true);
            MyControlPanel.setScaleType(SCALE_FACTOR);
            _rangeScalingButton.setActionCommand(RANGE_SCALING);
            JPanel scalePanel = new JPanel();
            scalePanel.add(_scaleFactorButton);
            scalePanel.add(_ampScaleField);
            scalePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 30));
            JPanel clipPanel = new JPanel();
            clipPanel.add(_rangeScalingButton);
            clipPanel.add(new JLabel("Min:"));
            clipPanel.add(_ampClipMinField);
            clipPanel.add(new JLabel("Max:"));
            clipPanel.add(_ampClipMaxField);
            clipPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            _ampScaleField.setText("1");
            _ampScaleField.setHorizontalAlignment(0);
            _ampClipMinField.setText("-1");
            _ampClipMaxField.setText("1");
            this.add(scalePanel);
            this.add(clipPanel);
        }

        public static final float getAmplitudeScaleFactor() {
            try {
                float scaleFactor = new Float(_ampScaleField.getText()).floatValue();
                if (scaleFactor != 0.0f) {
                    return scaleFactor;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1.0f;
        }

        public static final JTextField getAmplitudeJTextField() {
            return _ampScaleField;
        }

        public static final float getAmplitudeClipMin() {
            try {
                return Float.parseFloat(_ampClipMinField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return -1.0f;
            }
        }

        public static final JTextField getAmplitudeClipMinJTextField() {
            return _ampClipMinField;
        }

        public static final float getAmplitudeClipMax() {
            try {
                return Float.parseFloat(_ampClipMaxField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return 1.0f;
            }
        }

        public static final JTextField getAmplitudeClipMaxJTextField() {
            return _ampClipMaxField;
        }

        public static final JRadioButton getRangeScalingButton() {
            return _rangeScalingButton;
        }

        public static final JRadioButton getScaleFactorButton() {
            return _scaleFactorButton;
        }

        public static final void setScaleType(String type) {
            if (type.equalsIgnoreCase(RANGE_SCALING)) {
                _scaleType = RANGE_SCALING;
                _ampScaleField.setEnabled(false);
                _ampClipMinField.setEnabled(true);
                _ampClipMaxField.setEnabled(true);
            } else if (type.equalsIgnoreCase(SCALE_FACTOR)) {
                _scaleType = SCALE_FACTOR;
                _ampScaleField.setEnabled(true);
                _ampClipMinField.setEnabled(false);
                _ampClipMaxField.setEnabled(false);
            }
        }

        public static final String getScaleType() {
            return _scaleType;
        }

        public static final float getClipMin(float min) {
            float clipMin = _scaleType.equalsIgnoreCase(RANGE_SCALING) ? MyControlPanel.getAmplitudeClipMin() : (_scaleType.equalsIgnoreCase(SCALE_FACTOR) ? min / MyControlPanel.getAmplitudeScaleFactor() : min);
            return clipMin;
        }

        public static final float getClipMax(float max) {
            float clipMax = _scaleType.equalsIgnoreCase(RANGE_SCALING) ? MyControlPanel.getAmplitudeClipMax() : (_scaleType.equalsIgnoreCase(SCALE_FACTOR) ? max / MyControlPanel.getAmplitudeScaleFactor() : max);
            return clipMax;
        }
    }

    private class MyPlotPanel
    extends PlotPanel {
        private static final long serialVersionUID = 1L;
        private IndexColorModel _indexColorModel;
        private PixelsView _pixelsView;

        public MyPlotPanel() {
            this.makeColorModel();
            switch (DistributedArrayMosaicPlot.this._plotOrientation) {
                case 2: {
                    this.setTitle("Frames");
                    break;
                }
                case 1: {
                    this.setTitle("Crossframes");
                    break;
                }
                case 0: {
                    this.setTitle("Slices");
                }
            }
        }

        private void makeColorModel() {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            for (int i = 0; i < 256; ++i) {
                g[i] = b[i] = (byte)(255 - i);
                r[i] = b[i];
            }
            this._indexColorModel = new IndexColorModel(8, 256, r, g, b);
        }

        public void updatePlot() {
            float max;
            float min;
            if (this._pixelsView == null) {
                this._pixelsView = this.addPixels(DistributedArrayMosaicPlot.this._xSampling, DistributedArrayMosaicPlot.this._ySampling, DistributedArrayMosaicPlot.this._plotData);
            } else {
                this._pixelsView.set(DistributedArrayMosaicPlot.this._xSampling, DistributedArrayMosaicPlot.this._ySampling, DistributedArrayMosaicPlot.this._plotData);
            }
            this._pixelsView.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
            switch (DistributedArrayMosaicPlot.this._plotOrientation) {
                case 2: {
                    min = DistributedArrayMosaicPlot.this._minAmpFrame;
                    max = DistributedArrayMosaicPlot.this._maxAmpFrame;
                    break;
                }
                case 1: {
                    min = DistributedArrayMosaicPlot.this._minAmpCrossframe;
                    max = DistributedArrayMosaicPlot.this._maxAmpCrossframe;
                    break;
                }
                case 0: {
                    min = DistributedArrayMosaicPlot.this._minAmpSlice;
                    max = DistributedArrayMosaicPlot.this._maxAmpSlice;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown _plotOrientation");
                }
            }
            if (min == 0.0f && max == 0.0f) {
                min = -1.0f;
                max = 1.0f;
            } else {
                min = -Math.abs(max);
            }
            this._pixelsView.setClips(MyControlPanel.getClipMin(min), MyControlPanel.getClipMax(max));
            this._pixelsView.setInterpolation(PixelsView.Interpolation.LINEAR);
            this._pixelsView.setColorModel(this._indexColorModel);
            this.repaint();
        }
    }
}

