/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Arrays;
import java.util.Random;
import org.javaseis.array.ArrayStorage;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.MultiArrayPositionIterator;
import org.javaseis.array.Transpose;
import org.javaseis.array.TransposeType;

public class MultiArray
implements IMultiArray {
    protected int _ndim;
    protected int[] _lengths;
    protected long _arrayLength;
    protected long _bufLength;
    protected long[] _offsetMultiplier;
    protected int _elementCount;
    protected int _traceLength;
    protected long _frameLength;
    protected long _volumeLength;
    protected long _hypercubeLength;
    protected Class _classType;
    protected IBackingArray _backingArray;
    protected BackingArray.Type _backingArrayType;

    public MultiArray() {
        this._ndim = 0;
        this._arrayLength = 0L;
        this._bufLength = 0L;
        this._elementCount = 1;
        this._lengths = null;
        this._classType = null;
        this._backingArray = null;
    }

    public MultiArray(int ndim, Class classType, int[] lengths) {
        this();
        this.setClassType(classType);
        this.setDimensions(ndim);
        this.setElementCount(1);
        this.setShape(lengths);
        this.setBackingArrayType(BackingArray.Type.JAVA_ARRAY);
        if (this._arrayLength > Integer.MAX_VALUE) {
            this.setBackingArrayType(BackingArray.Type.JAVA_LONG_ARRAY);
        }
    }

    public MultiArray(int ndim, Class classType, int elementCount, int[] lengths) {
        this();
        this.setClassType(classType);
        this.setDimensions(ndim);
        this.setElementCount(elementCount);
        this.setShape(lengths);
        this.setBackingArrayType(BackingArray.Type.JAVA_ARRAY);
        if (this._arrayLength > Integer.MAX_VALUE) {
            this.setBackingArrayType(BackingArray.Type.JAVA_LONG_ARRAY);
        }
    }

    public MultiArray(int ndim, Class classType, int elementCount, int[] lengths, int backingArrayType) {
        this();
        this.setClassType(classType);
        this.setDimensions(ndim);
        this.setElementCount(elementCount);
        this.setShape(lengths);
    }

    public MultiArray(IMultiArray a) {
        this.setClassType(a.getClassType());
        this.setElementCount(a.getElementCount());
        this.setDimensions(a.getDimensions());
        this.setShape(a.getShape());
        IBackingArray ab = a.getBackingArray();
        this.setBackingArrayType(ab.getBackingArrayType());
        this.allocate(a.getBufferLength());
        IBackingArray ba = this.getBackingArray();
        ba.arraycopy(ab, 0L, ba, 0L, this._arrayLength);
    }

    public static MultiArray factory(int ndim, Class classType, int elementCount, int[] lengths, BackingArray.Type backingArrayType) {
        MultiArray sa = new MultiArray();
        sa.setClassType(classType);
        sa.setElementCount(elementCount);
        sa.setDimensions(ndim);
        sa.setShape(lengths);
        sa.setBackingArrayType(backingArrayType);
        sa.allocate(MultiArray.arrayLength(ndim, elementCount, lengths));
        return sa;
    }

    public static MultiArray factory(int ndim, Class classType, int elementCount, int[] lengths) {
        MultiArray sa = new MultiArray();
        sa.setClassType(classType);
        sa.setElementCount(elementCount);
        sa.setDimensions(ndim);
        sa.setShape(lengths);
        sa.setBackingArrayType(BackingArray.Type.JAVA_ARRAY);
        if (sa._arrayLength > Integer.MAX_VALUE) {
            sa.setBackingArrayType(BackingArray.Type.JAVA_LONG_ARRAY);
        }
        sa.allocate(MultiArray.arrayLength(ndim, elementCount, lengths));
        return sa;
    }

    public static MultiArray float2D(int n1, int n2) {
        MultiArray sa = MultiArray.factory(2, Float.TYPE, 1, new int[]{n1, n2});
        return sa;
    }

    public static MultiArray float3D(int n1, int n2, int n3) {
        MultiArray sa = MultiArray.factory(3, Float.TYPE, 1, new int[]{n1, n2, n3});
        return sa;
    }

    public static <T> MultiArray factory(int ndim, T[] obuf, int elementCount, int[] lengths) {
        MultiArray sa = new MultiArray();
        sa.setClassType(obuf.getClass());
        sa.setElementCount(elementCount);
        sa.setDimensions(ndim);
        sa.setShape(lengths);
        sa.setBackingArray(new ArrayStorage(obuf));
        return sa;
    }

    public static MultiArray view(MultiArray old, int ndim, Class classType, int elementCount, int[] lengths) {
        if (classType != old.getClassType()) {
            throw new RuntimeException("Change of class type is not supported");
        }
        MultiArray sa = new MultiArray();
        sa.setClassType(classType);
        sa.setElementCount(elementCount);
        sa.setDimensions(ndim);
        sa.setShape(lengths);
        sa.setBackingArray(old.getBackingArray());
        sa._bufLength = (int)sa.getBackingArray().getBackingArrayLength();
        return sa;
    }

    @Override
    public IMultiArray view(int ndim, Class classType, int elementCount, int[] lengths) {
        return MultiArray.view(this, ndim, classType, elementCount, lengths);
    }

    @Override
    public IMultiArray view() {
        return MultiArray.view(this, this._ndim, this._classType, this._elementCount, this._lengths);
    }

    @Override
    public IMultiArray view(int ndim, int[] position) {
        MultiArray sa = new MultiArray();
        sa.setClassType(this._classType);
        sa.setElementCount(this._elementCount);
        sa.setDimensions(ndim);
        sa.setShape(this._lengths);
        long offset = this.index(position) + this.getBackingArray().getOffset();
        long length = this._offsetMultiplier[ndim];
        sa.setBackingArray(this.getBackingArray().view(length, offset));
        sa._bufLength = (int)sa.getBackingArray().getLength();
        return sa;
    }

    public static long arrayLength(int ndim, int elementCount, int[] lengths) {
        long arrayLength = elementCount;
        for (int i = 0; i < ndim; ++i) {
            arrayLength *= (long)lengths[i];
        }
        return arrayLength;
    }

    public void allocate(long maxLength, BackingArray.Type backingArrayType) {
        this._backingArrayType = backingArrayType;
        this.allocate(maxLength);
    }

    @Override
    public void allocate(long maxLength) {
        if (maxLength < this._arrayLength) {
            throw new IllegalArgumentException("Requested maxLength is less than the array length");
        }
        this._bufLength = maxLength;
        this.allocate();
    }

    @Override
    public void allocate() {
        if (this._bufLength < 0L) {
            throw new IllegalArgumentException("Buffer length must be >= 0, but is currently " + this._bufLength);
        }
        if (this._bufLength < this._arrayLength) {
            this._bufLength = this._arrayLength;
        }
        this._backingArray = BackingArray.factory(this._classType, this._bufLength, this._backingArrayType);
    }

    @Override
    public void setClassType(Class classType) {
        this._classType = classType;
    }

    @Override
    public Class getClassType() {
        return this._classType;
    }

    @Override
    public void setElementCount(int elementCount) {
        this._elementCount = elementCount;
    }

    @Override
    public void setDimensions(int ndim) {
        this._ndim = ndim;
        this._lengths = null;
    }

    public void setBackingArrayType(BackingArray.Type type) {
        this._backingArrayType = type;
    }

    public BackingArray.Type getBackingArrayType() {
        return this._backingArrayType;
    }

    @Override
    public void setBackingArray(IBackingArray buf) {
        this._backingArrayType = buf.getBackingArrayType();
        this._backingArray = buf;
    }

    @Override
    public IBackingArray getBackingArray() {
        return this._backingArray;
    }

    public long getArrayLength() {
        return this._arrayLength;
    }

    public void setShape(int elementCount, int[] lengths) {
        this._elementCount = elementCount;
        this.setShape(lengths);
    }

    @Override
    public void setShape(int[] lengths) {
        int i;
        assert (this._ndim > 0 && this._elementCount > 0) : "dimensions or element count is zero";
        assert (lengths.length >= this._ndim) : "Invalid lengths.length";
        this._arrayLength = this._elementCount;
        for (i = 0; i < this._ndim; ++i) {
            assert (lengths[i] > 0) : "Zero length is not allowed: " + Arrays.toString(lengths);
            this._arrayLength *= (long)lengths[i];
        }
        this._lengths = (int[])lengths.clone();
        this._traceLength = this._lengths[0] * this._elementCount;
        if (this._ndim > 1) {
            this._frameLength = this._traceLength * this._lengths[1];
        }
        if (this._ndim > 2) {
            this._volumeLength = this._frameLength * (long)this._lengths[2];
        }
        if (this._ndim > 3) {
            this._hypercubeLength = this._volumeLength * (long)this._lengths[3];
        }
        this._offsetMultiplier = new long[this._ndim];
        this._offsetMultiplier[0] = this._elementCount;
        for (i = 1; i < this._ndim; ++i) {
            this._offsetMultiplier[i] = this._offsetMultiplier[i - 1] * (long)this._lengths[i - 1];
        }
        if (this._bufLength > 0L) assert (this._arrayLength <= this._bufLength) : "shape " + Arrays.toString(lengths) + " exceeds available array length (" + this._arrayLength + " > " + this._bufLength + ")";
    }

    @Override
    public void reshape(int[] lengths) {
        MultiArray.reshape(this, this._elementCount, lengths);
    }

    @Override
    public void reshape(int elementCount, int[] lengths) {
        MultiArray.reshape(this, elementCount, lengths);
    }

    public static MultiArray reshapeOld(MultiArray b, int ndim, int elementCount, int[] lengths) {
        IMultiArray a = b.view();
        b.setDimensions(ndim);
        b.setElementCount(elementCount);
        b.setShape(lengths);
        int[] position = new int[a.getDimensions()];
        int direction = 1;
        boolean expand = false;
        if (((MultiArray)a)._arrayLength < b._arrayLength) {
            expand = true;
            direction = -1;
        }
        int lena = a.getLength(0) * a.getElementCount();
        int lenb = b.getLength(0) * b.getElementCount();
        float[] trc = new float[Math.max(lena, lenb)];
        MultiArrayPositionIterator mapa = new MultiArrayPositionIterator(a, position, direction);
        while (mapa.hasNext()) {
            mapa.next();
            a.getTrace(trc, position);
            b.putTrace(trc, position);
        }
        if (expand) {
            MultiArray.zeroFill(b, a.getShape());
        }
        return b;
    }

    public static void reshape(MultiArray b, int elementCount, int[] lengths) {
        boolean same = true;
        int ndim = b.getDimensions();
        int ndim1 = ndim - 1;
        for (int i = 0; i < ndim1; ++i) {
            if (b.getLength(i) == lengths[i]) continue;
            same = false;
        }
        if (elementCount != b.getElementCount()) {
            same = false;
        }
        if (same) {
            if (b.getLength(ndim1) == lengths[ndim1]) {
                return;
            }
            int[] pos = b.getShape();
            int i = 0;
            while (i < ndim) {
                int n = i++;
                pos[n] = pos[n] - 1;
            }
            b.setShape(lengths);
            long start = b.index(pos);
            pos[ndim1] = lengths[ndim1 - 1];
            long end = b.index(pos);
            long count = end - start + 1L;
            if (count > 0L) {
                b.getBackingArray().fill(0, start, 1L, count);
            }
            return;
        }
        boolean expand = false;
        boolean contract = false;
        for (int i = 0; i < ndim; ++i) {
            if (i == 0) {
                if (lengths[i] * elementCount > b.getLength(i) * b.getElementCount()) {
                    expand = true;
                }
            } else if (lengths[i] > b.getLength(i)) {
                expand = true;
            }
            if (i == 0) {
                if (lengths[i] * elementCount >= b.getLength(i) * b.getElementCount()) continue;
                contract = true;
                continue;
            }
            if (lengths[i] >= b.getLength(i)) continue;
            contract = true;
        }
        if (contract && expand) {
            MultiArray.reshapeMixed(b, elementCount, lengths);
        }
        IMultiArray a = b.view();
        b.setElementCount(elementCount);
        b.setShape(lengths);
        int[] position = new int[ndim];
        int direction = 1;
        if (expand) {
            direction = -1;
        }
        MultiArrayPositionIterator mapa = new MultiArrayPositionIterator(a, position, direction);
        int lena = a.getLength(0) * a.getElementCount();
        int lenb = b.getLength(0) * b.getElementCount();
        Class cls = a.getClassType();
        if (cls == Float.TYPE) {
            float[] trc = new float[Math.max(lena, lenb)];
            while (mapa.hasNext()) {
                mapa.next();
                a.getTrace(trc, position);
                if (!b.checkPosition(position)) continue;
                try {
                    b.putTrace(trc, position);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("putTrace failed at position " + Arrays.toString(position));
                }
            }
        } else if (cls == Integer.TYPE) {
            int[] trc = new int[Math.max(lena, lenb)];
            while (mapa.hasNext()) {
                mapa.next();
                a.getTrace(trc, position);
                if (!b.checkPosition(position)) continue;
                try {
                    b.putTrace(trc, position);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("putTrace failed at position " + Arrays.toString(position));
                }
            }
        }
        if (expand) {
            MultiArray.zeroFill(b, a.getShape());
        }
    }

    public static void reshapeMixed(MultiArray b, int elementCount, int[] newShape) {
        Object[] trc;
        int ndim = b.getDimensions();
        MultiArray a = new MultiArray(b);
        b.setElementCount(elementCount);
        b.setShape(newShape);
        int lena = a.getLength(0) * a.getElementCount();
        int lenb = b.getLength(0) * b.getElementCount();
        int[] position = new int[ndim];
        MultiArrayPositionIterator mapa = new MultiArrayPositionIterator(a, position);
        Class cls = a.getClassType();
        if (cls == Float.TYPE) {
            trc = new float[Math.max(lena, lenb)];
            while (mapa.hasNext()) {
                mapa.next();
                a.getTrace((float[])trc, position);
                if (!b.checkPosition(position)) continue;
                try {
                    b.putTrace((float[])trc, position);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("putTrace failed at position " + Arrays.toString(position));
                }
            }
        } else if (cls == Integer.TYPE) {
            trc = new int[Math.max(lena, lenb)];
            while (mapa.hasNext()) {
                mapa.next();
                a.getTrace((int[])trc, position);
                if (!b.checkPosition(position)) continue;
                try {
                    b.putTrace((int[])trc, position);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("putTrace failed at position " + Arrays.toString(position));
                }
            }
        }
        int count = b.getLength(0);
        MultiArrayPositionIterator mapb = new MultiArrayPositionIterator(b, position);
        if (cls == Float.TYPE) {
            while (mapb.hasNext()) {
                mapb.next();
                if (a.checkPosition(position)) continue;
                try {
                    b.fill(0.0f, position, count);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("fill failed at position " + Arrays.toString(position));
                }
            }
        } else {
            while (mapb.hasNext()) {
                mapb.next();
                if (a.checkPosition(position)) continue;
                try {
                    b.fill(0, position, count);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("fill failed at position " + Arrays.toString(position));
                }
            }
        }
    }

    public static void zeroCompletely(MultiArray sa) {
        if (sa.getClassType() == Byte.TYPE) {
            sa._backingArray.fill((byte)0, 0L, 1L, sa._backingArray.getBackingArrayLength());
        } else if (sa.getClassType() == Integer.TYPE) {
            sa._backingArray.fill(0, 0L, 1L, sa._backingArray.getBackingArrayLength());
        } else if (sa.getClassType() == Long.TYPE) {
            sa._backingArray.fill(0L, 0L, 1L, sa._backingArray.getBackingArrayLength());
        } else if (sa.getClassType() == Float.TYPE) {
            sa._backingArray.fill(0.0f, 0L, 1L, sa._backingArray.getBackingArrayLength());
        } else if (sa.getClassType() == Double.TYPE) {
            sa._backingArray.fill(0.0, 0L, 1L, sa._backingArray.getBackingArrayLength());
        } else {
            throw new IllegalArgumentException("class type not handled = " + sa.getClassType());
        }
    }

    public static void zeroFill(MultiArray sa) {
        MultiArray.zeroFill(sa, new int[sa.getDimensions()]);
    }

    public static void zeroFill(MultiArray sa, int[] lengths) {
        int ndim = sa.getDimensions();
        int[] position = new int[ndim];
        MultiArrayPositionIterator sapi = new MultiArrayPositionIterator(sa, position);
        int nz = sa.getLength(0);
        int nzp = 0;
        boolean padTrace = false;
        if (lengths[0] < sa.getLength(0)) {
            padTrace = true;
            nzp = sa.getLength(0) - lengths[0];
        }
        Class cls = sa.getClassType();
        while (sapi.hasNext()) {
            sapi.next();
            boolean zeroTrace = false;
            for (int i = 0; i < ndim; ++i) {
                if (position[i] < lengths[i]) continue;
                zeroTrace = true;
            }
            if (zeroTrace) {
                if (cls == Byte.TYPE) {
                    sa.fill((byte)0, position, nz);
                    continue;
                }
                if (cls == Integer.TYPE) {
                    sa.fill(0, position, nz);
                    continue;
                }
                if (cls == Long.TYPE) {
                    sa.fill(0L, position, nz);
                    continue;
                }
                if (cls == Float.TYPE) {
                    sa.fill(0.0f, position, nz);
                    continue;
                }
                if (cls == Double.TYPE) {
                    sa.fill(0.0, position, nz);
                    continue;
                }
                throw new RuntimeException("unhandled class type = " + cls.toString());
            }
            if (!padTrace) continue;
            position[0] = lengths[0];
            if (cls == Byte.TYPE) {
                sa.fill((byte)0, position, nzp);
                continue;
            }
            if (cls == Integer.TYPE) {
                sa.fill(0, position, nzp);
                continue;
            }
            if (cls == Long.TYPE) {
                sa.fill(0L, position, nzp);
                continue;
            }
            if (cls == Float.TYPE) {
                sa.fill(0.0f, position, nzp);
                continue;
            }
            if (cls == Double.TYPE) {
                sa.fill(0.0, position, nzp);
                continue;
            }
            throw new RuntimeException("unhandled class type = " + cls.toString());
        }
    }

    @Override
    public <T> void fill(T value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(byte value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(short value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(int value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(long value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(float value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public void fill(double value, int[] position, int count) {
        long start = this.index(position);
        long lcount = count * this._elementCount;
        this._backingArray.fill(value, start, 1L, lcount);
    }

    @Override
    public <T> void putSample(T[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(byte[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(short[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(int[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(long[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(float[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void putSample(double[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public <T> void putSample(T buf, int[] position, int element) {
        this._backingArray.putObject(buf, this.index(element, position));
    }

    @Override
    public void putSample(byte buf, int[] position, int element) {
        this._backingArray.putByte(buf, this.index(element, position));
    }

    @Override
    public void putSample(short buf, int[] position, int element) {
        this._backingArray.putShort(buf, this.index(element, position));
    }

    @Override
    public void putSample(int buf, int[] position, int element) {
        this._backingArray.putInt(buf, this.index(element, position));
    }

    @Override
    public void putSample(long buf, int[] position, int element) {
        this._backingArray.putLong(buf, this.index(element, position));
    }

    @Override
    public void putSample(float buf, int[] position, int element) {
        this._backingArray.putFloat(buf, this.index(element, position));
    }

    @Override
    public void putSample(double buf, int[] position, int element) {
        this._backingArray.putDouble(buf, this.index(element, position));
    }

    @Override
    public <T> void putSample(T buf, int[] position) {
        this._backingArray.putObject(buf, this.index(position));
    }

    @Override
    public void putSample(byte buf, int[] position) {
        this._backingArray.putByte(buf, this.index(position));
    }

    @Override
    public void putSample(short buf, int[] position) {
        this._backingArray.putShort(buf, this.index(position));
    }

    @Override
    public void putSample(int buf, int[] position) {
        this._backingArray.putInt(buf, this.index(position));
    }

    @Override
    public void putSample(long buf, int[] position) {
        this._backingArray.putLong(buf, this.index(position));
    }

    @Override
    public void putSample(float buf, int[] position) {
        this._backingArray.putFloat(buf, this.index(position));
    }

    @Override
    public void putSample(double buf, int[] position) {
        this._backingArray.putDouble(buf, this.index(position));
    }

    @Override
    public <T> void getSample(T[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(byte[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(short[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(int[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(long[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(float[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public void getSample(double[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, this._elementCount, this.index(position));
    }

    @Override
    public <T> T getObject(int[] position, int element) {
        return this._backingArray.getObject(this.index(element, position));
    }

    @Override
    public byte getByte(int[] position, int element) {
        return this._backingArray.getByte(this.index(element, position));
    }

    @Override
    public short getShort(int[] position, int element) {
        return this._backingArray.getShort(this.index(element, position));
    }

    @Override
    public int getInt(int[] position, int element) {
        return this._backingArray.getInt(this.index(element, position));
    }

    @Override
    public long getLong(int[] position, int element) {
        return this._backingArray.getLong(this.index(element, position));
    }

    @Override
    public float getFloat(int[] position, int element) {
        return this._backingArray.getFloat(this.index(element, position));
    }

    @Override
    public double getDouble(int[] position, int element) {
        return this._backingArray.getDouble(this.index(element, position));
    }

    @Override
    public <T> T getObject(int[] position) {
        return this._backingArray.getObject(this.index(position));
    }

    @Override
    public byte getByte(int[] position) {
        return this._backingArray.getByte(this.index(position));
    }

    @Override
    public short getShort(int[] position) {
        return this._backingArray.getShort(this.index(position));
    }

    @Override
    public int getInt(int[] position) {
        return this._backingArray.getInt(this.index(position));
    }

    @Override
    public long getLong(int[] position) {
        return this._backingArray.getLong(this.index(position));
    }

    @Override
    public float getFloat(int[] position) {
        return this._backingArray.getFloat(this.index(position));
    }

    @Override
    public double getDouble(int[] position) {
        return this._backingArray.getDouble(this.index(position));
    }

    @Override
    public <T> void putTrace(T[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(byte[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(short[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(int[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(float[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(long[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void putTrace(double[] buf, int[] position) {
        this._backingArray.putArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public <T> void getTrace(T[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(byte[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(short[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(int[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(float[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(long[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    @Override
    public void getTrace(double[] buf, int[] position) {
        this._backingArray.getArray(buf, 0, Math.min(this._traceLength, buf.length), this.index(position));
    }

    public void getSubTrace(float[] buf, int[] position, int offset, int length) {
        this._backingArray.getArray(buf, offset, length, this.index(position));
    }

    @Override
    public <T> void putFrame(T[][] buf, int[] position) {
        assert (buf.getClass() == this._classType) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(byte[][] buf, int[] position) {
        assert (this._classType == Byte.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(short[][] buf, int[] position) {
        assert (this._classType == Short.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(int[][] buf, int[] position) {
        assert (this._classType == Integer.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(float[][] buf, int[] position) {
        assert (this._classType == Float.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(long[][] buf, int[] position) {
        assert (this._classType == Long.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public void putFrame(double[][] buf, int[] position) {
        assert (this._classType == Double.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.putTrace(buf[j], position);
        }
    }

    @Override
    public <T> void getFrame(T[][] buf, int[] position) {
        assert (buf.getClass() == this._classType) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(byte[][] buf, int[] position) {
        assert (this._classType == Byte.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(short[][] buf, int[] position) {
        assert (this._classType == Short.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(int[][] buf, int[] position) {
        assert (this._classType == Integer.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(float[][] buf, int[] position) {
        assert (this._classType == Float.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(long[][] buf, int[] position) {
        assert (this._classType == Long.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public void getFrame(double[][] buf, int[] position) {
        assert (this._classType == Double.TYPE) : "Object mismatch";
        assert (buf.length <= this._lengths[1]) : "Frame array size mismatch " + buf.length + ">" + this._lengths[1];
        position[0] = 0;
        for (int j = 0; j < buf.length; ++j) {
            position[1] = j;
            this.getTrace(buf[j], position);
        }
    }

    @Override
    public <T> void putFrame(T[] buf, int[] position) {
        assert (buf.getClass() == this._classType) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(byte[] buf, int[] position) {
        assert (this._classType == Byte.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(short[] buf, int[] position) {
        assert (this._classType == Short.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(int[] buf, int[] position) {
        assert (this._classType == Integer.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(float[] buf, int[] position) {
        assert (this._classType == Float.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(long[] buf, int[] position) {
        assert (this._classType == Long.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void putFrame(double[] buf, int[] position) {
        assert (this._classType == Double.TYPE) : "Object mismatch";
        this._backingArray.putArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public <T> void getFrame(T[] buf, int[] position) {
        assert (buf.getClass() == this._classType) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(byte[] buf, int[] position) {
        assert (this._classType == Byte.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(short[] buf, int[] position) {
        assert (this._classType == Short.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(int[] buf, int[] position) {
        assert (this._classType == Integer.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(float[] buf, int[] position) {
        assert (this._classType == Float.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(long[] buf, int[] position) {
        assert (this._classType == Long.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public void getFrame(double[] buf, int[] position) {
        assert (this._classType == Double.TYPE) : "Object mismatch";
        this._backingArray.getArray(buf, 0, (int)Math.min(this._frameLength, (long)buf.length), this.index(position));
    }

    @Override
    public int getDimensions() {
        return this._ndim;
    }

    @Override
    public int[] getShape() {
        return (int[])this._lengths.clone();
    }

    @Override
    public int getLength(int index) {
        assert (index >= 0 && index < this._ndim) : "index out of bounds";
        return this._lengths[index];
    }

    @Override
    public int getElementCount() {
        return this._elementCount;
    }

    @Override
    public long getFrameLength() {
        return this._frameLength;
    }

    @Override
    public long getVolumeLength() {
        return this._volumeLength;
    }

    @Override
    public long getHypercubeLength() {
        return this._hypercubeLength;
    }

    @Override
    public long getTotalHypercubeCount() {
        long hypercubeCount = 1L;
        for (int i = 4; i < this._ndim; ++i) {
            hypercubeCount *= (long)this._lengths[i];
        }
        return hypercubeCount;
    }

    @Override
    public long getTotalVolumeCount() {
        long volumeCount = 1L;
        for (int i = 3; i < this._ndim; ++i) {
            volumeCount *= (long)this._lengths[i];
        }
        return volumeCount;
    }

    @Override
    public long getTotalFrameCount() {
        long frameCount = 1L;
        for (int i = 2; i < this._ndim; ++i) {
            frameCount *= (long)this._lengths[i];
        }
        return frameCount;
    }

    @Override
    public long getTotalTraceCount() {
        long traceCount = 1L;
        for (int i = 1; i < this._ndim; ++i) {
            traceCount *= (long)this._lengths[i];
        }
        return traceCount;
    }

    @Override
    public long getTotalSampleCount() {
        long sampleCount = 1L;
        for (int i = 0; i < this._ndim; ++i) {
            sampleCount *= (long)this._lengths[i];
        }
        return sampleCount;
    }

    @Override
    public long getOffset(int[] position) {
        long offset = 0L;
        for (int i = 0; i < this._ndim; ++i) {
            offset += this._offsetMultiplier[i] * (long)position[i];
        }
        return offset;
    }

    public long index(int[] position) {
        assert (position.length >= this._ndim) : "position.length < _ndim";
        long offset = 0L;
        for (int i = 0; i < this._ndim; ++i) {
            assert (position[i] >= 0 && position[i] < this._lengths[i]) : "\nposition out of range: " + Arrays.toString(position) + " for _lengths: " + Arrays.toString(this._lengths);
            offset += this._offsetMultiplier[i] * (long)position[i];
        }
        return offset;
    }

    public long index(int element, int[] position) {
        assert (element >= 0 && element < this._elementCount) : "element out of range";
        return this.index(position) + (long)element;
    }

    public boolean checkPosition(int[] position) {
        for (int i = 0; i < this._ndim; ++i) {
            if (position[i] >= 0 && position[i] < this._lengths[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transpose(TransposeType type) {
        switch (type) {
            case T12: 
            case T123: 
            case T1234: {
                break;
            }
            case T21: 
            case T213: {
                this.tran21();
                break;
            }
            case T132: {
                this.tran132();
                break;
            }
            case T231: {
                this.tran21();
                this.tran132();
                break;
            }
            case T312: {
                this.tran132();
                this.tran21();
                break;
            }
            case T321: {
                this.tran21();
                this.tran132();
                this.tran21();
                break;
            }
            case T1243: {
                this.tran1243();
                break;
            }
        }
    }

    protected void tran21() {
        Transpose.transpose21(this);
        int[] lengths = (int[])this._lengths.clone();
        lengths[0] = this._lengths[1];
        lengths[1] = this._lengths[0];
        this.setShape(lengths);
    }

    protected void tran132() {
        Transpose.transpose132(this);
        int[] lengths = (int[])this._lengths.clone();
        lengths[1] = this._lengths[2];
        lengths[2] = this._lengths[1];
        this.setShape(lengths);
    }

    protected void tran1243() {
        Transpose.transpose1243(this);
        int[] lengths = (int[])this._lengths.clone();
        lengths[2] = this._lengths[3];
        lengths[3] = this._lengths[2];
        this.setShape(lengths);
    }

    @Override
    public long getBufferLength() {
        return this._backingArray.getBackingArrayLength();
    }

    public static void main(String[] args) {
        MultiArray sb;
        MultiArray sa;
        int ib;
        int ia;
        int itest;
        int ntest = 10;
        int ndim = 4;
        int[] maxLengths = new int[]{51, 51, 51, 51};
        int[] lengths = new int[ndim];
        int[] newLengths = new int[ndim];
        Random r = new Random(12345L);
        System.out.println("Shape Contraction Tests:");
        for (itest = 0; itest < ntest; ++itest) {
            for (int i = 0; i < ndim; ++i) {
                ia = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0);
                if (ia < (ib = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0))) {
                    lengths[i] = ib;
                    newLengths[i] = ia;
                    continue;
                }
                lengths[i] = ia;
                newLengths[i] = ib;
            }
            System.out.println("Reshape " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            sa = MultiArray.initArrayFloat(lengths, maxLengths);
            sb = new MultiArray(sa);
            sb.reshape(newLengths);
            MultiArray.checkContents("testReshape iteration " + itest, sb, newLengths);
            sa = null;
            sb = null;
            System.gc();
        }
        System.out.println("Shape Expansion Tests:");
        for (itest = 0; itest < ntest; ++itest) {
            for (int i = 0; i < ndim; ++i) {
                ia = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0);
                if (ia > (ib = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0))) {
                    lengths[i] = ib;
                    newLengths[i] = ia;
                    continue;
                }
                lengths[i] = ia;
                newLengths[i] = ib;
            }
            System.out.println("Reshape " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            sa = MultiArray.initArrayFloat(lengths, maxLengths);
            sb = new MultiArray(sa);
            sb.reshape(newLengths);
            MultiArray.checkContents("testReshape iteration " + itest, sb, lengths);
            sa = null;
            sb = null;
            System.gc();
        }
        System.out.println("Arbitrary Shape Tests:");
        int[] checklen = new int[ndim];
        for (int itest2 = 0; itest2 < ntest; ++itest2) {
            for (int i = 0; i < ndim; ++i) {
                ia = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0);
                ib = (int)Math.max(r.nextDouble() * (double)maxLengths[i], 2.0);
                lengths[i] = ia;
                newLengths[i] = ib;
                checklen[i] = Math.min(ia, ib);
            }
            System.out.println("Reshape " + Arrays.toString(lengths) + " to " + Arrays.toString(newLengths));
            MultiArray sa2 = MultiArray.initArrayFloat(lengths, maxLengths);
            MultiArray sb2 = new MultiArray(sa2);
            sb2.reshape(newLengths);
            MultiArray.checkContents("Arbitrary Shape iteration " + itest2, sb2, checklen);
            sa2 = null;
            sb2 = null;
            System.gc();
        }
        System.out.println("*** org.javaseis.array.MultiArray SUCCESS ***");
    }

    public static MultiArray initArrayFloat(int[] lengths, int[] lengthsMax) {
        int ndim = 4;
        MultiArray sa = MultiArray.factory(ndim, Float.TYPE, 1, lengthsMax, BackingArray.Type.JAVA_ARRAY);
        sa.setShape(lengths);
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = 0; m < lengths[3]; ++m) {
            position[3] = m;
            for (int k = 0; k < lengths[2]; ++k) {
                position[2] = k;
                for (int j = 0; j < lengths[1]; ++j) {
                    position[1] = j;
                    for (int i = 0; i < lengths[0]; ++i) {
                        position[0] = i;
                        sa.putSample(MultiArray.testFloat(i, j, k, m), position);
                    }
                }
            }
        }
        return sa;
    }

    public static int testFn(int i, int j) {
        return i + 100 * j;
    }

    public static int testFn(int i, int j, int k) {
        return i + 100 * j + 10000 * k;
    }

    public static int testFn(int i, int j, int k, int m) {
        return i + 100 * j + 10000 * k + 1000000 * m;
    }

    public static float testFloat(int i, int j, int k, int m) {
        return 1.0f * (float)i + 100.0f * (float)j + 1000.0f * (float)k + 100000.0f * (float)m;
    }

    public static void checkContents(String title, MultiArray sa, int[] lengths) {
        int[] position = new int[]{0, 0, 0, 0};
        for (int m = lengths[3] - 1; m >= 0; --m) {
            position[3] = m;
            for (int k = lengths[2] - 1; k >= 0; --k) {
                position[2] = k;
                for (int j = lengths[1] - 1; j >= 0; --j) {
                    position[1] = j;
                    for (int i = lengths[0] - 1; i >= 0; --i) {
                        position[0] = i;
                        float f2 = sa.getFloat(position);
                        float f1 = MultiArray.testFloat(i, j, k, m);
                        MultiArray.assertEquals(title, f1, f2, 1.0E-6f);
                    }
                }
            }
        }
    }

    private static void assertEquals(String title, float arg1, float arg2, float tol) {
        assert (Math.abs(arg2 - arg1) < tol) : title + " Expected " + arg1 + " got " + arg2;
    }

    private void assertEquals(String title, int arg1, int arg2) {
        assert (arg1 == arg2) : title + " Expected " + arg1 + " got " + arg2;
    }
}

