/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class HpvInternetId
extends HostId
implements FlexlmConstants {
    private static final int WILDCARD = -1;
    private int[] id;

    public HpvInternetId() throws FlexlmException {
        this("HPV_INTERNET=1.2.3.4");
    }

    public HpvInternetId(String string) throws FlexlmException {
        if (!string.startsWith(this.getKeyword() + "=")) {
            throw new FlexlmException(-504, 2049);
        }
        String string2 = string.substring(string.indexOf("=") + 1);
        if (string2.length() < 1) {
            throw new FlexlmException(-503, 2050);
        }
        this.id = string2.indexOf(":") != -1 ? HpvInternetId.parseV6AddrString(string2) : HpvInternetId.parseOctetString(string2);
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new HpvInternetId(string);
    }

    private static int[] parseOctetString(String string) throws FlexlmException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new FlexlmException(-503, 2051);
        }
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                nArray[i] = -1;
                continue;
            }
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmException(-503, 2052);
            }
            if (n < 0 || n > 255) {
                throw new FlexlmException(-503, 2053);
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private static int[] parseV6AddrString(String string) throws FlexlmException {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 2 || stringTokenizer.countTokens() > 8) {
            throw new FlexlmException(-503, 2054);
        }
        if (string.indexOf(46) != -1) {
            if (string.indexOf(42) != -1) {
                throw new FlexlmException(-503, 2055);
            }
            String string2 = string.substring(string.lastIndexOf(58) + 1);
            return HpvInternetId.parseOctetString(string2);
        }
        int[] nArray = new int[32];
        if (stringTokenizer.countTokens() != 8) {
            int n;
            String string3 = string;
            if (string.indexOf("::") == -1) {
                throw new FlexlmException(-503, 2056);
            }
            int n2 = 0;
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c != ':') continue;
                ++n2;
            }
            n = 8 - n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(":0");
            }
            charSequence = new StringBuffer(string);
            charSequence = ((StringBuffer)charSequence).insert(string.indexOf("::"), stringBuffer);
            charSequence = ((StringBuffer)charSequence).insert(string.indexOf("::") + 1, "0");
            string3 = ((StringBuffer)charSequence).toString();
            stringTokenizer = new StringTokenizer(string3, ":");
        }
        if (stringTokenizer.countTokens() != 8) {
            throw new FlexlmException(-503, 2057);
        }
        for (int i = 0; i < 8; ++i) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("*") || string4.equals("****")) {
                nArray[4 * i + 0] = -1;
                nArray[4 * i + 1] = -1;
                nArray[4 * i + 2] = -1;
                nArray[4 * i + 3] = -1;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            if (string4.length() > 4) {
                throw new FlexlmException(-503, 2058);
            }
            while (stringBuffer.length() < 4) {
                stringBuffer = stringBuffer.insert(0, "0");
            }
            for (int j = 0; j < 4; ++j) {
                charSequence = stringBuffer.substring(j, j + 1);
                if (((String)charSequence).equals("*")) {
                    nArray[4 * i + j] = -1;
                    continue;
                }
                int n = -1;
                try {
                    n = Integer.parseInt((String)charSequence, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmException(-503, 2059);
                }
                if (n < 0 || n > 15) {
                    throw new FlexlmException(-503, 2060);
                }
                nArray[4 * i + j] = n;
            }
        }
        return nArray;
    }

    @Override
    public boolean isCurrentHost() {
        HpvInternetId hpvInternetId = null;
        hpvInternetId = this.getLocalIp();
        return this.matches(hpvInternetId);
    }

    @Override
    public HostId[] getCurrentHostIds() {
        HpvInternetId hpvInternetId = this.getLocalIp();
        if (hpvInternetId != null) {
            HostId[] hostIdArray = new HpvInternetId[]{hpvInternetId};
            return hostIdArray;
        }
        return null;
    }

    protected HpvInternetId getLocalIp() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string = inetAddress.getHostAddress();
        HpvInternetId hpvInternetId = null;
        try {
            hpvInternetId = new HpvInternetId(this.getKeyword() + "=" + string);
        }
        catch (FlexlmException flexlmException) {
            throw new RuntimeException("unexpected FlexlmException in HpvInternetId.getLocalIp()");
        }
        return hpvInternetId;
    }

    @Override
    public String getKeyword() {
        return "HPV_INTERNET";
    }

    @Override
    public int getType() {
        return 143;
    }

    @Override
    public boolean matches(HostId hostId) {
        boolean bl = true;
        if (hostId == null || !(hostId instanceof HpvInternetId)) {
            bl = false;
        } else {
            HpvInternetId hpvInternetId = (HpvInternetId)hostId;
            int[] nArray = (int[])hpvInternetId.getValue();
            if (this.id.length != nArray.length) {
                return false;
            }
            for (int i = 0; i < this.id.length; ++i) {
                if (this.id[i] == -1 || nArray[i] == -1 || this.id[i] == nArray[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public int compareValueTo(Object object) {
        int[] nArray = (int[])object;
        if (this.id.length != nArray.length) {
            return this.id.length - nArray.length;
        }
        for (int i = 0; i < this.id.length; ++i) {
            if (this.id[i] == nArray[i]) continue;
            return this.id[i] - nArray[i];
        }
        return 0;
    }

    @Override
    public Object getValue() {
        return this.id;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ".";
        if (this.id.length == 32) {
            string = ":";
        }
        if (this.id.length == 4) {
            for (int i = 0; i < this.id.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(string);
                }
                if (this.id[i] == -1) {
                    stringBuffer.append("*");
                    continue;
                }
                stringBuffer.append(this.id[i]);
            }
        } else {
            for (int i = 0; i < this.id.length; ++i) {
                if (i != 0 && i % 4 == 0) {
                    stringBuffer.append(string);
                }
                if (this.id[i] == -1) {
                    stringBuffer.append("*");
                    continue;
                }
                stringBuffer.append(Integer.toHexString(this.id[i]));
            }
        }
        return this.getKeyword() + "=" + new String(stringBuffer);
    }

    public boolean isIP() {
        if (this.isIP4()) {
            return true;
        }
        return this.isIP6();
    }

    public boolean isIP4() {
        return this.checkOctets(4);
    }

    public boolean isIP6() {
        return this.checkOctets(32);
    }

    private boolean checkOctets(int n) {
        if (this.id.length != n) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (this.id[i] == 0) continue;
            return true;
        }
        return bl;
    }
}

