/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.Message;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ShutdownMessage
extends Message
implements FlexlmConstants,
FlexlmInternalConstants {
    private String szUser;
    private String szHost;
    private String szDaemon;
    private InetAddress ipAddress;
    private boolean force;
    private String quorumReset;

    public ShutdownMessage(String string, String string2) {
        this.szUser = string;
        this.szHost = string2;
        this.szDaemon = null;
        this.ipAddress = ShutdownMessage.getIp();
        this.force = false;
        this.quorumReset = "noreset";
    }

    public ShutdownMessage() {
        this.szUser = null;
        this.szHost = null;
        this.szDaemon = null;
        this.ipAddress = ShutdownMessage.getIp();
        this.force = false;
        this.quorumReset = "noreset";
    }

    public ShutdownMessage(String string, String string2, String string3) {
        this.szUser = string;
        this.szHost = string2;
        this.szDaemon = string3;
        this.ipAddress = ShutdownMessage.getIp();
        this.force = false;
        this.quorumReset = "noreset";
    }

    @Override
    public void send(OutputStream outputStream, int n, CommRev commRev) throws IOException {
        byte[] byArray = commRev.encodeShutdown(this);
        super.sendIt(outputStream, byArray, commRev, n);
    }

    public String getUser() {
        return this.szUser;
    }

    public String getQuorum() {
        return this.quorumReset;
    }

    public String setUser(String string) {
        this.szUser = string;
        return this.getUser();
    }

    public String getHost() {
        return this.szHost;
    }

    public String setHost(String string) {
        this.szHost = string;
        return this.getHost();
    }

    public String getDaemon() {
        return this.szDaemon;
    }

    public String setDaemon(String string) {
        this.szDaemon = string;
        return this.getDaemon();
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public InetAddress setIpAddress(InetAddress inetAddress) {
        this.ipAddress = inetAddress;
        return this.getIpAddress();
    }

    public boolean getForce() {
        return this.force;
    }

    public boolean setForce(boolean bl) {
        this.force = bl;
        return this.force;
    }

    private static InetAddress getIp() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }
}

