/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.scheme.KeyAgreement;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class ECMQV
extends KeyAgreement
implements Serializable {
    private static final long serialVersionUID = -801150403429763844L;

    public ECMQV() {
        super("ECMQV");
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 6 && n2 != 7 || objectArray == null || objectArray.length < 6) {
            throw new IllegalArgumentException("wrong params");
        }
        this.reset();
        BigInteger bigInteger = new BigInteger(1, ((ECPrivateKey)objectArray[0]).getExp());
        PointParams pointParams = ((ECPublicKey)objectArray[1]).getPoint();
        BigInteger bigInteger2 = new BigInteger(1, ((ECPrivateKey)objectArray[2]).getExp());
        PointParams pointParams2 = ((ECPublicKey)objectArray[3]).getPoint();
        PointParams pointParams3 = ((ECPublicKey)objectArray[4]).getPoint();
        PointParams pointParams4 = ((ECPublicKey)objectArray[5]).getPoint();
        int n3 = objectArray.length;
        if (n3 > 6) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (objectArray[i2] instanceof SharedInfoParameterSpec) {
                    this.b = ((SharedInfoParameterSpec)objectArray[6]).getSharedInfo(0);
                    continue;
                }
                if (!(objectArray[i2] instanceof String)) continue;
                this.c = (String)objectArray[i2];
            }
        }
        super.init(n2, objectArray, random);
        ECParams eCParams = ((ECPrivateKey)objectArray[0]).getECParams();
        BigInteger bigInteger3 = new BigInteger(1, eCParams.getPointOrder());
        BigInteger bigInteger4 = BigInteger.valueOf(eCParams.getCofactor());
        int n4 = bigInteger3.bitLength();
        BigInteger bigInteger5 = bigInteger2.add(this.a(n4, pointParams2).multiply(bigInteger));
        try {
            ECFactory eCFactory = ECFactory.a(eCParams);
            ECA eCA = eCFactory.a(pointParams3.getX(), pointParams3.getY());
            ECA eCA2 = eCFactory.a(pointParams4.getX(), pointParams4.getY());
            ECA eCA3 = eCA2.a(eCA.a(this.a(n4, pointParams4).mod(bigInteger3))).a(bigInteger5.multiply(bigInteger4).mod(bigInteger3));
            if (eCA3.equals(eCA3.d())) {
                this.reset();
                throw new IllegalArgumentException("invalid keys.");
            }
            this.a = eCA3.e().f();
        }
        catch (ECException eCException) {
            this.reset();
            throw new IllegalStateException("cannot do cryptography.");
        }
    }

    private BigInteger a(int n2, PointParams pointParams) {
        BigInteger bigInteger = BigInteger.valueOf(1L).shiftLeft(n2 / 2 + n2 % 2);
        BigInteger bigInteger2 = new BigInteger(1, pointParams.getX());
        if (this.j == 32) {
            return bigInteger2.mod(bigInteger).add(bigInteger);
        }
        return bigInteger2.mod(bigInteger);
    }
}

