/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.WriteConcern;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.io.BsonOutput;

class InsertMessage
extends RequestMessage {
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final List<InsertRequest> insertRequestList;

    public InsertMessage(String collectionName, boolean ordered, WriteConcern writeConcern, List<InsertRequest> insertRequestList, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_INSERT, settings);
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.insertRequestList = insertRequestList;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput outputStream, int messageStartPosition) {
        this.writeInsertPrologue(outputStream);
        for (int i = 0; i < this.insertRequestList.size(); ++i) {
            BsonDocument document = this.insertRequestList.get(i).getDocument();
            int pos = outputStream.getPosition();
            this.addCollectibleDocument(document, outputStream, this.createValidator());
            if (outputStream.getPosition() - messageStartPosition <= this.getSettings().getMaxMessageSize()) continue;
            outputStream.truncateToPosition(pos);
            return new InsertMessage(this.getCollectionName(), this.ordered, this.writeConcern, this.insertRequestList.subList(i, this.insertRequestList.size()), this.getSettings());
        }
        return null;
    }

    private FieldNameValidator createValidator() {
        if (this.getCollectionName().endsWith(".system.indexes")) {
            return new NoOpFieldNameValidator();
        }
        return new CollectibleDocumentFieldNameValidator();
    }

    private void writeInsertPrologue(BsonOutput outputStream) {
        int flags = 0;
        if (!this.ordered) {
            flags |= 1;
        }
        outputStream.writeInt32(flags);
        outputStream.writeCString(this.getCollectionName());
    }
}

