/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.tests;

import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.javaseis.array.ArrayStorage;
import org.javaseis.array.ByteBufferStorage;
import org.javaseis.array.LongArrayStorage;

public class JTestArrayStorage
extends TestCase {
    private static int NMAX = 1000;

    public static void main(String[] args) {
        JTestArrayStorage test = new JTestArrayStorage();
        test.test1D();
        test.testByteBuf();
        test.testLongArray();
    }

    public void test1D() {
        Random r = new Random(12345L);
        double t0 = System.nanoTime();
        for (int i = 0; i < NMAX / 10; ++i) {
            int n1 = 1 + (int)(r.nextFloat() * (float)NMAX);
            int n2 = 1 + (int)(r.nextFloat() * (float)NMAX);
            this.test1Dfloat(n1, n2);
            this.test1Dshort(n1, n2);
            this.test1Ddouble(n1, n2);
        }
        System.out.println("ArrayStorage time " + 1.0E-9 * ((double)System.nanoTime() - t0));
    }

    public void testByteBuf() {
        Random r = new Random(12345L);
        double t0 = System.nanoTime();
        for (int i = 0; i < NMAX / 10; ++i) {
            int n1 = 1 + (int)(r.nextFloat() * (float)NMAX);
            int n2 = 1 + (int)(r.nextFloat() * (float)NMAX);
            this.testBBfloat(n1, n2);
            this.testBBshort(n1, n2);
            this.testBBdouble(n1, n2);
        }
        System.out.println("ByteBufferStorage time " + 1.0E-9 * ((double)System.nanoTime() - t0));
    }

    public void testLongArray() {
        Random r = new Random(12345L);
        double t0 = System.nanoTime();
        for (int i = 0; i < NMAX / 10; ++i) {
            int n1 = 1 + (int)(r.nextFloat() * (float)NMAX);
            int n2 = 1 + (int)(r.nextFloat() * (float)NMAX);
            this.testLongFloat(n1, n2);
            this.testLongShort(n1, n2);
            this.testLongDouble(n1, n2);
        }
        System.out.println("LongArrayStorage time " + 1.0E-9 * ((double)System.nanoTime() - t0));
    }

    public void test1Dshort(int n1, int n2) {
        int j;
        short[][] frame = new short[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = (short)(n1 * j2 + i);
            }
        }
        ArrayStorage as = new ArrayStorage(Short.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], (short)0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)((short)(n1 * j + i)), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getShort(n1 * j + i), (float)((short)(n1 * j + i)), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void test1Dfloat(int n1, int n2) {
        int j;
        float[][] frame = new float[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        ArrayStorage as = new ArrayStorage(Float.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0f);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)(n1 * j + i), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getFloat(n1 * j + i), (float)(n1 * j + i), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void test1Ddouble(int n1, int n2) {
        int j;
        double[][] frame = new double[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        ArrayStorage as = new ArrayStorage(Double.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((double)frame[j][i], (double)(n1 * j + i), (double)1.0E-6);
                JTestArrayStorage.assertEquals((double)as.getDouble(n1 * j + i), (double)(n1 * j + i), (double)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testBBshort(int n1, int n2) {
        int j;
        short[][] frame = new short[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = (short)(n1 * j2 + i);
            }
        }
        ByteBufferStorage as = new ByteBufferStorage(Short.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], (short)0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)((short)(n1 * j + i)), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getShort(n1 * j + i), (float)((short)(n1 * j + i)), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testBBfloat(int n1, int n2) {
        int j;
        float[][] frame = new float[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        ByteBufferStorage as = new ByteBufferStorage(Float.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0f);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)(n1 * j + i), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getFloat(n1 * j + i), (float)(n1 * j + i), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testBBdouble(int n1, int n2) {
        int j;
        double[][] frame = new double[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        ByteBufferStorage as = new ByteBufferStorage(Double.TYPE, n1 * n2);
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((double)frame[j][i], (double)(n1 * j + i), (double)1.0E-6);
                JTestArrayStorage.assertEquals((double)as.getDouble(n1 * j + i), (double)(n1 * j + i), (double)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testLongShort(int n1, int n2) {
        int j;
        short[][] frame = new short[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = (short)(n1 * j2 + i);
            }
        }
        LongArrayStorage as = new LongArrayStorage(Short.TYPE, n1, n2);
        as.fill((short)0, 0L, 1L, (long)(n1 * n2));
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], (short)0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)((short)(n1 * j + i)), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getShort(n1 * j + i), (float)((short)(n1 * j + i)), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testLongFloat(int n1, int n2) {
        int j;
        float[][] frame = new float[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        LongArrayStorage as = new LongArrayStorage(Float.TYPE, n1, n2);
        as.fill(0.0f, 0L, 1L, (long)(n1 * n2));
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0f);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((float)frame[j][i], (float)(n1 * j + i), (float)1.0E-6f);
                JTestArrayStorage.assertEquals((float)as.getFloat(n1 * j + i), (float)(n1 * j + i), (float)1.0E-6f);
            }
            index += (long)n1;
        }
    }

    public void testLongDouble(int n1, int n2) {
        int j;
        double[][] frame = new double[n2][n1];
        for (int j2 = 0; j2 < n2; ++j2) {
            for (int i = 0; i < n1; ++i) {
                frame[j2][i] = n1 * j2 + i;
            }
        }
        LongArrayStorage as = new LongArrayStorage(Double.TYPE, n1 * n2);
        as.fill(0.0, 0L, 1L, (long)(n1 * n2));
        long index = 0L;
        for (j = 0; j < n2; ++j) {
            as.putArray(frame[j], 0, n1, index);
            Arrays.fill(frame[j], 0.0);
            index += (long)n1;
        }
        index = 0L;
        for (j = 0; j < n2; ++j) {
            as.getArray(frame[j], 0, n1, index);
            for (int i = 0; i < n1; ++i) {
                JTestArrayStorage.assertEquals((double)frame[j][i], (double)(n1 * j + i), (double)1.0E-6);
                JTestArrayStorage.assertEquals((double)as.getDouble(n1 * j + i), (double)(n1 * j + i), (double)1.0E-6f);
            }
            index += (long)n1;
        }
    }
}

