/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.javaseis.io.ExtentListEntry;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.IVirtualIO;
import org.javaseis.util.SeisException;

public class VirtualMappedIO
implements IVirtualIO {
    private static final Logger LOG = Logger.getLogger(VirtualMappedIO.class.getName());
    private RandomAccessFile _mapIO;
    private FileChannel _channel;
    private long _channelSize;
    private MappedByteBuffer _mappedByteBuffer;
    private int _currentSegment = 0;
    private int _segmentSize;
    private long _fpos;
    private boolean _trackTime = false;
    private long _ioTime;
    private String _path;
    private FileChannel.MapMode _mode;

    public VirtualMappedIO(String path) throws SeisException {
        this(path, Integer.MAX_VALUE);
    }

    public VirtualMappedIO(String path, int segmentSize) throws SeisException {
        assert (segmentSize > 1);
        this._path = path;
        this._segmentSize = segmentSize;
        try {
            this.openExisting(path);
        }
        catch (IOException e) {
            throw new SeisException("Unable to open VirtualMappedIO File '" + path + "'\n", e);
        }
    }

    public VirtualMappedIO(String path, int segmentSize, long flen) throws SeisException {
        assert (segmentSize > 1);
        this._path = path;
        this._segmentSize = segmentSize;
        try {
            this.openNew(path, flen);
        }
        catch (IOException e) {
            throw new SeisException("Unable to open VirtualMappedIO File '" + path + "'\n", e);
        }
    }

    private void openExisting(String path) throws IOException {
        this._mapIO = new RandomAccessFile(path, "r");
        this._channel = this._mapIO.getChannel();
        this._channelSize = this._channel.size();
        this._mode = FileChannel.MapMode.READ_ONLY;
        long len = Math.min((long)this._segmentSize, this._channelSize);
        this._mappedByteBuffer = this._channel.map(this._mode, 0L, (int)len);
    }

    private void openNew(String path, long flen) throws IOException {
        this._mapIO = new RandomAccessFile(path, "rw");
        this._channel = this._mapIO.getChannel();
        this._channelSize = flen;
        this._mode = FileChannel.MapMode.READ_WRITE;
        long len = Math.min((long)this._segmentSize, this._channelSize);
        this._mappedByteBuffer = this._channel.map(this._mode, 0L, (int)len);
    }

    @Override
    public long setPosition(long fpos) throws SeisException {
        int ipos;
        if (fpos < 0L) {
            throw new IllegalArgumentException("Invalid position was specified, fpos = " + fpos);
        }
        long t0 = 0L;
        if (this._trackTime) {
            t0 = System.nanoTime();
        }
        this._fpos = fpos;
        int index = (int)(fpos / (long)this._segmentSize);
        if (this._currentSegment != index) {
            try {
                long offset = (long)index * (long)this._segmentSize;
                long len = Math.min(this._channelSize - offset, (long)this._segmentSize);
                this._mappedByteBuffer = this._channel.map(this._mode, offset, len);
            }
            catch (IOException e) {
                throw new SeisException("Failed to create mapped byte buffer, index = " + index + "\n", e);
            }
            this._currentSegment = index;
        }
        if ((ipos = this.getOffset(fpos)) < 0 || ipos > this._segmentSize) {
            throw new IllegalArgumentException("Integer position in map buffer is invalid\nfpos = " + fpos + "\nindex = " + index);
        }
        this._mappedByteBuffer.position(ipos);
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - t0;
        }
        return this._fpos;
    }

    private int getOffset(long fpos) {
        int ioffset = (int)(fpos - (long)this._currentSegment * (long)this._segmentSize);
        return ioffset;
    }

    @Override
    public int read(ByteBuffer buf) throws SeisException {
        long t0 = 0L;
        if (this._trackTime) {
            t0 = System.nanoTime();
        }
        int limit = buf.limit();
        int ipos = this._mappedByteBuffer.position();
        int icap = this._mappedByteBuffer.capacity();
        int left_remaining = icap - ipos;
        int right_remaining = limit - left_remaining;
        if (left_remaining < limit) {
            int i;
            buf.limit(left_remaining);
            for (i = 0; i < left_remaining; ++i) {
                buf.put(this._mappedByteBuffer.get());
            }
            this.setPosition(this._fpos + (long)left_remaining);
            buf.limit(limit);
            for (i = 0; i < limit - left_remaining - 1; ++i) {
                buf.put(this._mappedByteBuffer.get());
            }
        } else {
            for (int i = 0; i < limit; ++i) {
                buf.put(this._mappedByteBuffer.get());
            }
        }
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - t0;
        }
        return buf.position();
    }

    @Override
    public int write(ByteBuffer buf) throws SeisException {
        long t0 = 0L;
        if (this._trackTime) {
            t0 = System.nanoTime();
        }
        int limit = buf.limit();
        int ipos = this._mappedByteBuffer.position();
        int icap = this._mappedByteBuffer.capacity();
        int left_remaining = icap - ipos;
        int right_remaining = limit - left_remaining;
        if (left_remaining < limit) {
            buf.limit(left_remaining);
            this._mappedByteBuffer.put(buf);
            this.setPosition(this._fpos + (long)left_remaining);
            buf.limit(limit);
            this._mappedByteBuffer.put(buf);
        } else {
            this._mappedByteBuffer.put(buf);
        }
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - t0;
        }
        return buf.position();
    }

    @Override
    public void close() throws SeisException {
        try {
            if (this._channel != null) {
                this._channel.close();
            }
            if (this._mapIO != null) {
                this._mapIO.close();
            }
            this._mappedByteBuffer = null;
            System.gc();
        }
        catch (IOException e) {
            throw new SeisException("Error closing VirtualMappedIO file\n", e);
        }
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public void flush() throws SeisException {
    }

    @Override
    public ExtentPolicy getExtentPolicy() {
        return null;
    }

    @Override
    public FileDescriptor getFD() {
        return null;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public int readBuffer(ByteBuffer buffer) throws SeisException {
        return 0;
    }

    @Override
    public int readBuffer(ByteBuffer buffer, int len) throws SeisException {
        return 0;
    }

    @Override
    public int writeBuffer(ByteBuffer buffer) throws SeisException {
        return 0;
    }

    @Override
    public float getVirtualRate() {
        return 0.0f;
    }

    @Override
    public float getVirtualTime() {
        return 0.0f;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public long getIoBytes() {
        return 0L;
    }

    @Override
    public float getIoRate() {
        return 0.0f;
    }

    @Override
    public float getLoadTime() {
        return 0.0f;
    }

    @Override
    public float getLockTime() {
        return 0.0f;
    }

    @Override
    public ExtentListEntry[] getExtents() {
        return null;
    }

    @Override
    public void trackTime(boolean flag) {
        this._trackTime = flag;
    }

    @Override
    public float getIoTime() {
        return 1.0E-9f * (float)this._ioTime;
    }
}

