/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import java.util.Iterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.iterators.beta.IIterator;
import org.javaseis.iterators.beta.IPositionIterator;

public class FrameIterator<E>
implements IIterator<E> {
    private final IFlexArray _seismicArray;
    private final IPositionIterator<int[]> _positionIterator;
    private int[] _tracePosition;

    public FrameIterator(IFlexArray multiArray) {
        this._seismicArray = multiArray;
        this._tracePosition = new int[multiArray.getDimensions()];
        this._positionIterator = this._seismicArray.newPositionIterator();
        this._positionIterator.setScope(IPositionIterator.Scope.FRAME_AXIS);
    }

    public FrameIterator(IFlexArray multiArray, IPositionIterator<int[]> positionIterator) {
        this._seismicArray = multiArray;
        this._tracePosition = new int[multiArray.getDimensions()];
        this._positionIterator = positionIterator;
        if (this._positionIterator.getScope() != IPositionIterator.Scope.FRAME_AXIS) {
            throw new IllegalArgumentException("The scope for the position iterator must be 2");
        }
    }

    @Override
    public final boolean hasNext() {
        return this._positionIterator.hasNext();
    }

    @Override
    public E next() {
        this._tracePosition = (int[])this._positionIterator.next();
        return (E)this._seismicArray.getFrame(this._tracePosition);
    }

    @Override
    public int[] getPosition() {
        return (int[])this._tracePosition.clone();
    }

    @Override
    public void reset() {
        this._positionIterator.reset();
    }

    @Override
    public Iterator<E> iterator() {
        return new TraceIterator(this._seismicArray);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

