/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public class PhyUserId
extends HostId
implements FlexlmConstants {
    private String username;

    public PhyUserId() throws FlexlmException {
        this("PHY_USER=xxxx");
    }

    public PhyUserId(String string) throws FlexlmException {
        if (!string.startsWith(this.getKeyword() + "=")) {
            throw new FlexlmException(-504, 2082);
        }
        String string2 = string.substring(string.indexOf("=") + 1);
        if (string2.length() < 1) {
            throw new FlexlmException(-503, 2083);
        }
        this.username = string2;
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new PhyUserId(string);
    }

    @Override
    public boolean isCurrentHost() {
        return this.username.equalsIgnoreCase(this.getCurrent());
    }

    @Override
    public HostId[] getCurrentHostIds() {
        HostId[] hostIdArray = new HostId[1];
        try {
            hostIdArray[0] = new PhyUserId(this.getKeyword() + "=" + this.getCurrent());
        }
        catch (FlexlmException flexlmException) {
            throw new RuntimeException(flexlmException.getMessage());
        }
        return hostIdArray;
    }

    @Override
    public Object getValue() {
        return this.username;
    }

    @Override
    public String getKeyword() {
        return "PHY_USER";
    }

    @Override
    public int getType() {
        return 106;
    }

    private String getCurrent() {
        return super.currentConnectionData().getUsername();
    }
}

