/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.VendorInfo;
import java.util.StringTokenizer;

public class HostIdList
extends HostId
implements FlexlmConstants {
    private VendorInfo vendorInfo;
    private HostId[] hostIds;

    public HostIdList(String string, VendorInfo vendorInfo) throws FlexlmException {
        this.vendorInfo = vendorInfo;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        this.hostIds = new HostId[n];
        for (int i = 0; i < n; ++i) {
            this.hostIds[i] = HostId.parseHostId(stringTokenizer.nextToken(), vendorInfo);
        }
    }

    @Override
    public HostId createNew(String string) throws FlexlmException {
        return new HostIdList(string, this.vendorInfo);
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public String getKeyword() {
        return null;
    }

    @Override
    public int getCryptCode() {
        return 0;
    }

    @Override
    public boolean isCurrentHost() {
        for (int i = 0; i < this.hostIds.length; ++i) {
            if (!this.hostIds[i].isCurrentHost()) continue;
            return true;
        }
        return false;
    }

    @Override
    public HostId[] getCurrentHostIds() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.hostIds;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < this.hostIds.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.hostIds[i].toString());
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

