/* test set_o_direct method */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>

int set_o_direct (int fd, char *filename, int value);
int o_direct_is_set (int fd, char *filename);
char * getJS_NFS_O_DIRECT ();
long long diskCapacityBytes(char* dir);

int main (int argc, const char *argv[])
{
  int fd, flags, err;
  char *path = NULL; // "/d/geoprog/u/cornkc/set_o_direct/linux_debug/junk.dat"
  char *js_nfs_o_direct = NULL;
  long long diskSpaceKb;

  if (argv[1] != NULL) {
    path = (char *)malloc (strlen(argv[1])+1);
    strcpy (path, argv[1]);
    printf ("File name is %s\n", path);
    flags = O_RDWR;
    fd = open (path, flags);
    if (fd < 0) {
      printf ("Error opening file: %d\n", fd);
      return fd;
    }

    js_nfs_o_direct = getJS_NFS_O_DIRECT ();
    if (js_nfs_o_direct != NULL) {
      printf ("JS_NFS_O_DIRECT = %s\n", js_nfs_o_direct);
    }
    else {
      printf ("JS_NFS_O_DIRECT has not been set\n");
    }

    err = set_o_direct (fd, path, 1);
    if (err == 0) {
      printf ("Found no error setting O_DIRECT: %d\n", err);
      if (o_direct_is_set(fd,path) != 0) {
      	printf ("Found the O_DIRECT flag set\n");
      }
      else {
      	printf ("Found the O_DIRECT flag UNSET!!!!\n");
      }
      err = close (fd);
      printf ("Successfully closed file: %d\n", err);
      fd = open (path, flags);
      if (fd < 0) {
        printf ("Error reopening file: %d\n", fd);
        return fd;
      }
      err = set_o_direct (fd, path, 0);
      if (err == 0) {
        printf ("Found no error UNSETting O_DIRECT: %d\n", err);
        if (o_direct_is_set(fd,path) == 0) {
      	  printf ("Found the O_DIRECT flag unset\n");
        }
        else {
      	  printf ("Found the O_DIRECT flag SET!!!!\n");
        }
        err = close (fd);
        printf ("Successfully closed file: %d\n", err);
      }
      else {
        printf ("Error unsetting O_DIRECT: %d\n", err);
      }
    }
    else {
      printf ("Error setting O_DIRECT: %d\n", err);
    }
    
    /* Test usable disk space  in Kbytes */
    diskSpaceKb = diskCapacityBytes(path)/1024;
    printf("\nPath = %s\nAvailable disk space (KBytes) = %lld\n\n", 
	   path, diskSpaceKb);

    return err;
  }
  else {
  	printf ("Usage: %s  my_full_file_path\n", argv[0]);
    return -1;
  }
}
