/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.seiszip;

import java.nio.IntBuffer;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.javaseis.seiszip.BlockCompressor;
import org.javaseis.seiszip.DataCorruptedException;

public class HdrCompressor {
    private static final Logger LOG = Logger.getLogger("org.javaseis.seiszip");
    private static int[] c_candidateValues = HdrCompressor.getCandidateUniqueValues();
    private static final int SIZEOF_INT = 4;
    private static final int IND_COOKIE = 0;
    private static final int IND_SYM_CONST = 1;
    private static final int IND_SYM_ASCEND = 2;
    private static final int IND_SYM_DESCEND = 3;
    private static final int IND_SYM_DELTA = 4;
    private static final int IND_SYM_FLOATS = 5;
    private static final int IND_OUT_COUNT = 6;
    private static final int IND_HDR_LENGTH = 7;
    private static final int IND_NTRACES = 8;
    private static final int IND_REMUTE = 9;
    static final int HDR_LENGTH = 10;
    private static final int OLD_COOKIE1 = 6821923;
    private static final int COOKIE = 1215649;
    private static final int MIN_POS_FLOAT_BITS = 700000000;
    private static final int MAX_NEG_FLOAT_BITS = -700000000;
    private static final int BEST_ZIP_LEVEL = 6;
    private int[] _transposedHdrs;
    private int[] _runLengthEncodedValues;
    private byte[] _zipWorkBuffer;
    private int[] _singleHdrWork;
    private int[] _uniqueValues = new int[5];
    private Deflater _zipDeflater = new Deflater(6);
    private Inflater _zipInflater = new Inflater();

    public static int getOutputBufferSize(int maxHdrLength, int maxFrameSize) {
        if (maxHdrLength < 1 || maxFrameSize < 1) {
            throw new IllegalArgumentException("Header length of headers per frame is invalid");
        }
        return ((maxHdrLength + 1) * maxFrameSize + 10) * 4;
    }

    private void ensureHdrBuffers(int[][] hdrs, IntBuffer hdrIntBuffer, int hdrLength) {
        int nIntsMin;
        if (hdrLength < 1) {
            throw new IllegalArgumentException("Header length is nonsensical");
        }
        int lenHdr0 = 0;
        if (hdrs != null) {
            lenHdr0 = hdrs[0].length;
            nIntsMin = hdrs.length * (hdrs[0].length + 1) + 10;
        } else {
            int nTraces = hdrIntBuffer.capacity() / hdrLength;
            nIntsMin = hdrIntBuffer.capacity() + 10 + nTraces;
        }
        nIntsMin += 1024;
        int lenHdr = Math.max(lenHdr0, hdrLength);
        if (this._singleHdrWork == null || this._singleHdrWork.length < (lenHdr += 128)) {
            this._singleHdrWork = new int[lenHdr];
        }
        if (this._transposedHdrs == null || this._transposedHdrs.length < nIntsMin) {
            this._transposedHdrs = new int[nIntsMin];
        }
    }

    private void ensureZipBuffers(int[][] hdrs, IntBuffer hdrIntBuffer) {
        int nIntsMin = hdrs != null ? hdrs.length * (hdrs[0].length + 1) + 10 : hdrIntBuffer.capacity() * 2 + 10;
        if (this._runLengthEncodedValues == null || this._runLengthEncodedValues.length < (nIntsMin += 1024)) {
            this._runLengthEncodedValues = new int[nIntsMin];
        }
        if (this._zipWorkBuffer == null || this._zipWorkBuffer.length < nIntsMin * 4) {
            this._zipWorkBuffer = new byte[nIntsMin * 4];
        }
    }

    public int compress(int[][] hdrs, int hdrLength, float[][] traces, int nTraces, byte[] encodedBytes, int offset) {
        return this.private_compress(hdrs, null, hdrLength, traces, nTraces, encodedBytes, offset);
    }

    public int compress(IntBuffer hdrIntBuffer, int hdrLength, float[][] traces, int nTraces, byte[] encodedBytes, int offset) {
        return this.private_compress(null, hdrIntBuffer, hdrLength, traces, nTraces, encodedBytes, offset);
    }

    private int private_compress(int[][] hdrs, IntBuffer hdrIntBuffer, int hdrLength, float[][] traces, int nTraces, byte[] encodedBytes, int offset) {
        int j;
        if (encodedBytes.length - offset < hdrLength * nTraces * 4) {
            throw new IllegalArgumentException("Output encodedValues byte buffer is too small");
        }
        this.ensureZipBuffers(hdrs, hdrIntBuffer);
        this.ensureHdrBuffers(hdrs, hdrIntBuffer, hdrLength);
        int count = 0;
        if (hdrs != null) {
            for (int i = 0; i < hdrLength; ++i) {
                for (int j2 = 0; j2 < nTraces; ++j2) {
                    this._transposedHdrs[count] = hdrs[j2][i];
                    ++count;
                }
            }
        } else {
            for (j = 0; j < nTraces; ++j) {
                hdrIntBuffer.position(j * hdrLength);
                hdrIntBuffer.get(this._singleHdrWork, 0, hdrLength);
                for (int i = 0; i < hdrLength; ++i) {
                    int dest = j + i * nTraces;
                    this._transposedHdrs[dest] = this._singleHdrWork[i];
                }
            }
            count = hdrLength * nTraces;
        }
        if (traces != null) {
            for (j = 0; j < nTraces; ++j) {
                this._transposedHdrs[count] = HdrCompressor.getFirstNonZero(traces[j]);
                ++count;
            }
            this._runLengthEncodedValues[9] = 1;
        } else {
            this._runLengthEncodedValues[9] = 0;
        }
        this.getUniqueValues(this._transposedHdrs, count, this._uniqueValues);
        int endOfData = this._uniqueValues[0];
        int runSymbolConst = this._uniqueValues[0];
        int runSymbolAscend = this._uniqueValues[1];
        int runSymbolDescend = this._uniqueValues[2];
        int runSymbolDelta = this._uniqueValues[3];
        int runSymbolFloats = this._uniqueValues[4];
        this._transposedHdrs[count] = endOfData;
        this._runLengthEncodedValues[7] = hdrLength;
        this._runLengthEncodedValues[8] = nTraces;
        int nInts = this.runLengthEncode(this._transposedHdrs, runSymbolConst, runSymbolAscend, runSymbolDescend, runSymbolDelta, runSymbolFloats, endOfData, this._runLengthEncodedValues);
        return this.zip(this._runLengthEncodedValues, nInts, this._zipWorkBuffer, encodedBytes, offset);
    }

    private static int getFirstNonZero(float[] trace) {
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i] == 0.0f) continue;
            return i;
        }
        return trace.length;
    }

    private static void applyRemute(float[] trace, int indexFirstNonZero) {
        for (int i = 0; i < Math.min(indexFirstNonZero, trace.length); ++i) {
            trace[i] = 0.0f;
        }
    }

    public int uncompress(byte[] encodedBytes, int offset, int nBytes, int[][] hdrs, float[][] traces) throws DataFormatException, DataCorruptedException {
        return this.private_uncompress(encodedBytes, offset, nBytes, hdrs, null, traces);
    }

    public int uncompress(byte[] encodedBytes, int offset, int nBytes, IntBuffer hdrIntBuffer, float[][] traces) throws DataFormatException, DataCorruptedException {
        return this.private_uncompress(encodedBytes, offset, nBytes, null, hdrIntBuffer, traces);
    }

    public int private_uncompress(byte[] encodedBytes, int offset, int nBytes, int[][] hdrs, IntBuffer hdrIntBuffer, float[][] traces) throws DataFormatException, DataCorruptedException {
        int j;
        this.ensureZipBuffers(hdrs, hdrIntBuffer);
        this.unzip(encodedBytes, offset, nBytes, this._zipWorkBuffer, this._runLengthEncodedValues);
        if (this._runLengthEncodedValues[0] != 1215649) {
            throw new RuntimeException("Compressed data is corrupted or from an unsupported version");
        }
        int hdrLength = this._runLengthEncodedValues[7];
        int nTraces = this._runLengthEncodedValues[8];
        int iRemute = this._runLengthEncodedValues[9];
        if (hdrLength < 1 || nTraces < 1) {
            throw new DataCorruptedException("Header length and/or trace count is invalid");
        }
        if (iRemute != 0 && iRemute != 1) {
            throw new DataCorruptedException("Remute flag is invalid");
        }
        this.ensureHdrBuffers(hdrs, hdrIntBuffer, hdrLength);
        this.runLengthDecode(this._runLengthEncodedValues, this._transposedHdrs);
        int count = 0;
        if (hdrs != null) {
            count = 0;
            for (int i = 0; i < hdrLength; ++i) {
                for (int j2 = 0; j2 < nTraces; ++j2) {
                    hdrs[j2][i] = this._transposedHdrs[count];
                    ++count;
                }
            }
        } else {
            for (j = 0; j < nTraces; ++j) {
                for (int i = 0; i < hdrLength; ++i) {
                    int src = j + i * nTraces;
                    this._singleHdrWork[i] = this._transposedHdrs[src];
                }
                hdrIntBuffer.position(j * hdrLength);
                hdrIntBuffer.put(this._singleHdrWork, 0, hdrLength);
            }
            count = hdrLength * nTraces;
        }
        if (traces != null && iRemute == 1) {
            for (j = 0; j < nTraces; ++j) {
                HdrCompressor.applyRemute(traces[j], this._transposedHdrs[count]);
                ++count;
            }
        }
        return nTraces;
    }

    private void getUniqueValues(int[] inValues, int nInput, int[] uniqueValues) {
        int outCount = 0;
        int candidateCount = 0;
        while (true) {
            int candidateValue = candidateCount < c_candidateValues.length ? c_candidateValues[candidateCount] : Integer.MIN_VALUE + candidateCount;
            ++candidateCount;
            int n = 0;
            for (n = 0; n < nInput && inValues[n] != candidateValue; ++n) {
            }
            if (n != nInput) continue;
            uniqueValues[outCount] = candidateValue;
            if (++outCount == uniqueValues.length) break;
        }
    }

    private static int[] getCandidateUniqueValues() {
        byte[] bVals = new byte[4];
        bVals[1] = 0;
        bVals[2] = 0;
        bVals[3] = 0;
        int[] uniqueValues = new int[256];
        int count = 0;
        bVals[0] = 65;
        uniqueValues[count] = BlockCompressor.stuffBytesInInt(bVals, 0);
        bVals[0] = 1;
        uniqueValues[++count] = BlockCompressor.stuffBytesInInt(bVals, 0);
        bVals[0] = 74;
        uniqueValues[++count] = BlockCompressor.stuffBytesInInt(bVals, 0);
        bVals[0] = 68;
        uniqueValues[++count] = BlockCompressor.stuffBytesInInt(bVals, 0);
        ++count;
        for (int i = -128; i <= 127; ++i) {
            if (count >= uniqueValues.length) continue;
            bVals[0] = (byte)i;
            uniqueValues[count] = BlockCompressor.stuffBytesInInt(bVals, 0);
        }
        return uniqueValues;
    }

    private static boolean probablyFloat(int iVal) {
        if (iVal > 700000000 || iVal < -700000000) {
            return !Float.isNaN(Float.intBitsToFloat(iVal));
        }
        return false;
    }

    int runLengthEncode(int[] inValues, int runSymbolConst, int runSymbolAscend, int runSymbolDescend, int runSymbolDelta, int runSymbolFloats, int endOfData, int[] encodedValues) {
        if (inValues.length < 1) {
            return 0;
        }
        if (runSymbolConst == runSymbolAscend) {
            throw new IllegalArgumentException("runSymbolConst == runSymbolAscend");
        }
        if (runSymbolConst == runSymbolDescend) {
            throw new IllegalArgumentException("runSymbolConst == runSymbolDescend");
        }
        if (runSymbolConst == runSymbolDelta) {
            throw new IllegalArgumentException("runSymbolConst == runSymbolDelta");
        }
        if (runSymbolConst == runSymbolFloats) {
            throw new IllegalArgumentException("runSymbolConst == runSymbolFloats");
        }
        encodedValues[0] = 1215649;
        encodedValues[1] = runSymbolConst;
        encodedValues[2] = runSymbolAscend;
        encodedValues[3] = runSymbolDescend;
        encodedValues[4] = runSymbolDelta;
        encodedValues[5] = runSymbolFloats;
        int outCount = 10;
        int inCount = 0;
        do {
            int firstVal = inValues[inCount];
            int delta = inValues[inCount + 1] - firstVal;
            float deltaFloat = 0.0f;
            int runSymbol = runSymbolConst;
            int i = inCount + 1;
            int runLength = 1;
            while (inValues[i] != endOfData && inValues[i] == firstVal) {
                ++runLength;
                ++i;
            }
            if (runLength < 3) {
                runSymbol = runSymbolAscend;
                i = inCount + 1;
                runLength = 1;
                while (inValues[i] != endOfData && inValues[i] == firstVal + runLength) {
                    ++runLength;
                    ++i;
                }
            }
            if (runLength < 3) {
                runSymbol = runSymbolDescend;
                i = inCount + 1;
                runLength = 1;
                while (inValues[i] != endOfData && inValues[i] == firstVal - runLength) {
                    ++runLength;
                    ++i;
                }
            }
            if (runLength < 3) {
                runSymbol = runSymbolDelta;
                i = inCount + 1;
                runLength = 1;
                while (inValues[i] != endOfData && inValues[i] == firstVal + runLength * delta) {
                    ++runLength;
                    ++i;
                }
                if (runLength < 5) {
                    runLength = 0;
                }
            }
            if (runLength < 3 && HdrCompressor.probablyFloat(firstVal) && HdrCompressor.probablyFloat(inValues[inCount + 1])) {
                float firstValFloat = Float.intBitsToFloat(firstVal);
                deltaFloat = Float.intBitsToFloat(inValues[inCount + 1]) - firstValFloat;
                runSymbol = runSymbolFloats;
                i = inCount + 1;
                runLength = 1;
                while (inValues[i] != endOfData && HdrCompressor.probablyFloat(inValues[i]) && inValues[i] == Float.floatToIntBits(firstValFloat + (float)runLength * deltaFloat)) {
                    ++runLength;
                    ++i;
                }
                if (runLength < 5) {
                    runLength = 0;
                }
            }
            if (runLength > 3) {
                if (runSymbol == runSymbolDelta) {
                    encodedValues[outCount] = runSymbol;
                    encodedValues[outCount + 1] = runLength;
                    encodedValues[outCount + 2] = firstVal;
                    encodedValues[outCount + 3] = delta;
                    inCount += runLength;
                    outCount += 4;
                    continue;
                }
                if (runSymbol == runSymbolFloats) {
                    encodedValues[outCount] = runSymbol;
                    encodedValues[outCount + 1] = runLength;
                    encodedValues[outCount + 2] = firstVal;
                    encodedValues[outCount + 3] = Float.floatToIntBits(deltaFloat);
                    inCount += runLength;
                    outCount += 4;
                    continue;
                }
                encodedValues[outCount] = runSymbol;
                encodedValues[outCount + 1] = runLength;
                encodedValues[outCount + 2] = firstVal;
                inCount += runLength;
                outCount += 3;
                continue;
            }
            encodedValues[outCount] = inValues[inCount];
            ++inCount;
            ++outCount;
        } while (inValues[inCount] != endOfData);
        encodedValues[6] = outCount;
        return outCount;
    }

    int runLengthDecode(int[] encodedValues, int[] outValues) {
        if (encodedValues[0] == 6821923) {
            throw new RuntimeException("Compressed data is from an unsupported version");
        }
        if (encodedValues[0] != 1215649) {
            throw new IllegalArgumentException("Input encoded values have invalid header (wrong endianness?) [" + encodedValues[0] + "!=" + 1215649 + "]");
        }
        int runSymbolConst = encodedValues[1];
        int runSymbolAscend = encodedValues[2];
        int runSymbolDescend = encodedValues[3];
        int runSymbolDelta = encodedValues[4];
        int runSymbolFloats = encodedValues[5];
        int nInput = encodedValues[6];
        int outCount = 0;
        int delta = 0;
        float deltaFloat = 0.0f;
        float firstValFloat = 0.0f;
        int inCount = 10;
        while (inCount < nInput) {
            if (encodedValues[inCount] == runSymbolConst || encodedValues[inCount] == runSymbolAscend || encodedValues[inCount] == runSymbolDescend || encodedValues[inCount] == runSymbolDelta || encodedValues[inCount] == runSymbolFloats) {
                int runLength = encodedValues[inCount + 1];
                int firstVal = encodedValues[inCount + 2];
                if (encodedValues[inCount] == runSymbolDelta) {
                    delta = encodedValues[inCount + 3];
                }
                if (encodedValues[inCount] == runSymbolFloats) {
                    deltaFloat = Float.intBitsToFloat(encodedValues[inCount + 3]);
                    firstValFloat = Float.intBitsToFloat(firstVal);
                }
                for (int i = 0; i < runLength; ++i) {
                    outValues[outCount] = encodedValues[inCount] == runSymbolConst ? firstVal : (encodedValues[inCount] == runSymbolAscend ? firstVal + i : (encodedValues[inCount] == runSymbolDescend ? firstVal - i : (encodedValues[inCount] == runSymbolDelta ? firstVal + i * delta : Float.floatToIntBits(firstValFloat + (float)i * deltaFloat))));
                    ++outCount;
                }
                if (encodedValues[inCount] == runSymbolDelta || encodedValues[inCount] == runSymbolFloats) {
                    inCount += 4;
                    continue;
                }
                inCount += 3;
                continue;
            }
            outValues[outCount] = encodedValues[inCount];
            ++outCount;
            ++inCount;
        }
        return outCount;
    }

    private int zip(int[] encodedValues, int nValues, byte[] zipInput, byte[] zipOutput, int offset) {
        int index = 0;
        for (int i = 0; i < nValues; ++i) {
            BlockCompressor.stuffIntInBytes(encodedValues[i], zipInput, index);
            index += 4;
        }
        this._zipDeflater.reset();
        this._zipDeflater.setInput(zipInput, 0, nValues * 4);
        this._zipDeflater.finish();
        int nBytes = this._zipDeflater.deflate(zipOutput, offset, zipOutput.length - offset);
        if (nBytes == 0) {
            throw new RuntimeException("java.util.zip.Deflator.deflate() returned 0");
        }
        return nBytes;
    }

    private int unzip(byte[] unzipInput, int offset, int nBytesInput, byte[] unzipOutput, int[] encodedValues) throws DataFormatException {
        this._zipInflater.reset();
        this._zipInflater.setInput(unzipInput, offset, nBytesInput);
        int nBytesOutput = this._zipInflater.inflate(unzipOutput);
        if (nBytesOutput == 0) {
            throw new RuntimeException("java.util.zip.Inflator.inflate() returned 0");
        }
        int nInts = nBytesOutput / 4;
        if (nInts * 4 != nBytesOutput) {
            throw new RuntimeException("Unzip returned an odd number of bytes");
        }
        int index = 0;
        for (int i = 0; i < nInts; ++i) {
            encodedValues[i] = BlockCompressor.stuffBytesInInt(unzipOutput, index);
            index += 4;
        }
        return nInts;
    }
}

