/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.seiszip;

import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.javaseis.seiszip.HuffCoder;
import org.javaseis.seiszip.Transformer;

public class BlockCompressor {
    private static final Logger LOG = Logger.getLogger("org.javaseis.seiszip");
    private static boolean c_littleEndian = true;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_CHAR = 1;
    private static final int SIZEOF_FLOAT = 4;
    private static final float CPDF = 0.26f;
    private HuffCoder _huffCoder;
    private int[] _idata = new int[1024];
    private byte[] _huffchars = new byte[4096];
    private float _manualDelta = Float.MAX_VALUE;

    private static int nint(double a) {
        return a > 0.0 ? (int)(a + 0.5) : (int)(a - 0.5);
    }

    static void stuffIntInBytes(int ival, byte[] bvals, int offset) {
        bvals[offset] = (byte)(ival >> 24);
        bvals[1 + offset] = (byte)(ival << 8 >> 24);
        bvals[2 + offset] = (byte)(ival << 16 >> 24);
        bvals[3 + offset] = (byte)(ival << 24 >> 24);
    }

    static void copyIntInBytes_DONT_USE(int ival, byte[] bvals, int offset) {
        if (c_littleEndian) {
            bvals[3 + offset] = (byte)(ival >> 24);
            bvals[2 + offset] = (byte)(ival << 8 >> 24);
            bvals[1 + offset] = (byte)(ival << 16 >> 24);
            bvals[offset] = (byte)(ival << 24 >> 24);
        } else {
            BlockCompressor.stuffIntInBytes(ival, bvals, offset);
        }
    }

    static int copyBytesToInt_DONT_USE(byte[] bvals, int offset) {
        if (c_littleEndian) {
            int i0 = bvals[offset + 3] << 24;
            int i1 = BlockCompressor.unsignedByte(bvals[offset + 2]) << 16;
            int i2 = BlockCompressor.unsignedByte(bvals[offset + 1]) << 8;
            int i3 = BlockCompressor.unsignedByte(bvals[offset]);
            return i0 + i1 + i2 + i3;
        }
        return BlockCompressor.stuffBytesInInt(bvals, offset);
    }

    static int unsignedByte(byte i) {
        if (i < 0) {
            return i + 256;
        }
        return i;
    }

    static int stuffBytesInInt(byte[] bvals, int index) {
        int i0 = BlockCompressor.unsignedByte(bvals[index]) << 24;
        int i1 = BlockCompressor.unsignedByte(bvals[1 + index]) << 16;
        int i2 = BlockCompressor.unsignedByte(bvals[2 + index]) << 8;
        int i3 = BlockCompressor.unsignedByte(bvals[3 + index]);
        return i0 + i1 + i2 + i3;
    }

    static void stuffShortInBytes(short uval, byte[] bvals, int index) {
        short ival = uval;
        bvals[index] = (byte)(ival << 16 >> 24);
        bvals[1 + index] = (byte)(ival << 24 >> 24);
    }

    static int stuffBytesInShort(byte[] bvals, int index) {
        short i0 = (short)(bvals[index] << 8);
        short i1 = (short)BlockCompressor.unsignedByte(bvals[1 + index]);
        return i0 + i1;
    }

    static int unsignedShort(short i) {
        if (i < 0) {
            return i + 65536;
        }
        return i;
    }

    private static float computeDelta(float[] x, int n, float distortion) {
        int i;
        if (Transformer.c_integrityTest) {
            return 1.0f;
        }
        double blockVar = 0.0;
        for (i = 0; i < n; ++i) {
            blockVar += (double)(x[i] * x[i]);
        }
        blockVar /= (double)n;
        blockVar = Math.sqrt(blockVar);
        float delta = distortion * (float)blockVar / 0.26f;
        float quarterDelta = delta * 0.25f;
        float mquarterDelta = -quarterDelta;
        blockVar = 0.0;
        int n2 = 0;
        for (i = 0; i < n; ++i) {
            if (x[i] > quarterDelta) {
                ++n2;
                blockVar += (double)(x[i] * x[i]);
                continue;
            }
            if (!(x[i] < mquarterDelta)) continue;
            ++n2;
            blockVar += (double)(x[i] * x[i]);
        }
        if (n2 > 0) {
            blockVar /= (double)n2;
            blockVar = Math.sqrt(blockVar);
            delta = distortion * (float)blockVar / 0.26f;
        } else {
            delta = 1.0f;
        }
        return delta;
    }

    private static void quantize(float[] x, int n, float delta, int[] ix) {
        delta = 1.0f / delta;
        for (int i = 0; i < n; ++i) {
            float temp = x[i] * delta;
            ix[i] = (double)temp > 0.0 ? (int)(temp + 0.5f) : (int)(temp - 0.5f);
        }
    }

    static int runLengthEncode(int[] quantdata, int n, byte[] encodedChars) {
        int nwords = n / 4;
        int nbytes = 0;
        int i = 0;
        while (i < nwords) {
            short si;
            if (quantdata[i] == 0) {
                int istart = i++;
                while (quantdata[i] == 0) {
                    ++i;
                }
                while (i > istart + 65535) {
                    encodedChars[nbytes++] = 106;
                    si = -1;
                    BlockCompressor.stuffShortInBytes(si, encodedChars, nbytes);
                    nbytes += 2;
                    istart += 65535;
                }
                int zrun = i - istart;
                if (zrun > 255) {
                    encodedChars[nbytes] = 106;
                    si = (short)zrun;
                    BlockCompressor.stuffShortInBytes(si, encodedChars, ++nbytes);
                    nbytes += 2;
                    continue;
                }
                if (zrun > 100) {
                    encodedChars[nbytes] = 105;
                    encodedChars[++nbytes] = (byte)zrun;
                    ++nbytes;
                    continue;
                }
                encodedChars[nbytes] = (byte)zrun;
                ++nbytes;
                continue;
            }
            if (quantdata[i] < 75 && quantdata[i] > -74) {
                encodedChars[nbytes] = (byte)(quantdata[i] + 180);
                ++nbytes;
                ++i;
                continue;
            }
            if (quantdata[i] > 0) {
                if (quantdata[i] < 256) {
                    encodedChars[nbytes] = 101;
                    encodedChars[++nbytes] = (byte)quantdata[i];
                    ++nbytes;
                } else if (quantdata[i] < 65536) {
                    encodedChars[nbytes] = 103;
                    si = (short)quantdata[i];
                    BlockCompressor.stuffShortInBytes(si, encodedChars, ++nbytes);
                    nbytes += 2;
                } else {
                    encodedChars[nbytes] = -1;
                    BlockCompressor.stuffIntInBytes(quantdata[i], encodedChars, ++nbytes);
                    nbytes += 4;
                }
            } else if (quantdata[i] > -256) {
                encodedChars[nbytes] = 102;
                encodedChars[++nbytes] = (byte)(-quantdata[i]);
                ++nbytes;
            } else if (quantdata[i] > -65536) {
                encodedChars[nbytes] = 104;
                si = (short)(-quantdata[i]);
                BlockCompressor.stuffShortInBytes(si, encodedChars, ++nbytes);
                nbytes += 2;
            } else {
                encodedChars[nbytes] = -1;
                BlockCompressor.stuffIntInBytes(quantdata[i], encodedChars, ++nbytes);
                nbytes += 4;
            }
            ++i;
        }
        int nInts = nbytes / 4;
        if (nInts * 4 < nbytes) {
            encodedChars[nbytes] = 0;
            encodedChars[nbytes + 1] = 0;
            encodedChars[nbytes + 2] = 0;
            ++nInts;
        }
        return nbytes;
    }

    BlockCompressor() {
        this(HuffCoder.c_huffCount);
    }

    BlockCompressor(int[] huffTable) {
        this._huffCoder = new HuffCoder(huffTable);
    }

    void setDelta(float delta) {
        this._manualDelta = delta;
    }

    private static void runLengthDecodeDequant(byte[] huffchars, int nbytes, float delta, float[] quantdata) {
        int j = 0;
        int i = 0;
        while (i < nbytes) {
            int ival;
            int iend;
            int ihuffchar = huffchars[i];
            if (ihuffchar < 0) {
                ihuffchar += 256;
            }
            if (ihuffchar > 0 && ihuffchar < 101) {
                iend = j + ihuffchar;
                while (j < iend) {
                    quantdata[j] = 0.0f;
                    ++j;
                }
                ++i;
                continue;
            }
            if (ihuffchar == 105) {
                if ((ival = huffchars[++i]) < 0) {
                    ival += 256;
                }
                iend = j + ival;
                while (j < iend) {
                    quantdata[j] = 0.0f;
                    ++j;
                }
                ++i;
                continue;
            }
            if (ihuffchar > 106 && ihuffchar < 255) {
                quantdata[j++] = ((float)ihuffchar - 180.0f) * delta;
                ++i;
                continue;
            }
            if (huffchars[i] == 101) {
                if ((ival = huffchars[++i]) < 0) {
                    ival += 256;
                }
                quantdata[j++] = (float)ival * delta;
                ++i;
                continue;
            }
            if (huffchars[i] == 102) {
                if ((ival = huffchars[++i]) < 0) {
                    ival += 256;
                }
                quantdata[j++] = -((float)ival) * delta;
                ++i;
                continue;
            }
            if (huffchars[i] == 103) {
                if ((ival = BlockCompressor.stuffBytesInShort(huffchars, ++i)) < 0) {
                    ival += 65536;
                }
                quantdata[j++] = (float)ival * delta;
                i += 2;
                continue;
            }
            if (huffchars[i] == 104) {
                if ((ival = BlockCompressor.stuffBytesInShort(huffchars, ++i)) < 0) {
                    ival += 65536;
                }
                quantdata[j++] = -((float)ival) * delta;
                i += 2;
                continue;
            }
            if (huffchars[i] == 106) {
                if ((ival = BlockCompressor.stuffBytesInShort(huffchars, ++i)) < 0) {
                    ival += 65536;
                }
                iend = j + ival;
                while (j < iend) {
                    quantdata[j] = 0.0f;
                    ++j;
                }
                i += 2;
                continue;
            }
            if (ihuffchar == 255) {
                ival = BlockCompressor.stuffBytesInInt(huffchars, ++i);
                quantdata[j++] = (float)ival * delta;
                i += 4;
                continue;
            }
            LOG.warning("HuffTableDecode: bad character encountered at element " + huffchars[i]);
            return;
        }
    }

    int dataEncode(float[] data, int nsamps, float distortion, byte[] encodedData, int index, int outputBufferSize) {
        int i;
        int nbytesHdrExpected = 8;
        if (outputBufferSize < nbytesHdrExpected + 1) {
            return 0;
        }
        float delta = this._manualDelta != Float.MAX_VALUE ? this._manualDelta : BlockCompressor.computeDelta(data, nsamps, distortion);
        while (this._idata.length < nsamps + 2) {
            this._idata = new int[this._idata.length * 2];
        }
        BlockCompressor.quantize(data, nsamps, delta, this._idata);
        for (i = nsamps - 1; i >= 0 && this._idata[i] == 0; --i) {
        }
        int nNonZero = i + 1;
        if (nNonZero >> 1 << 1 < nNonZero) {
            ++nNonZero;
        }
        int idelta = Float.floatToIntBits(delta);
        BlockCompressor.stuffIntInBytes(idelta, encodedData, index);
        int nbytesHdr = 4;
        BlockCompressor.stuffIntInBytes(nNonZero, encodedData, index += 4);
        nbytesHdr += 4;
        index += 4;
        this._idata[nNonZero] = 1;
        int nbytes = nNonZero * 4;
        while (this._huffchars.length < nbytes * 2) {
            this._huffchars = new byte[this._huffchars.length * 2];
        }
        nbytes = BlockCompressor.runLengthEncode(this._idata, nbytes, this._huffchars);
        if (nbytesHdr != nbytesHdrExpected) assert (nbytes != 0);
        if ((nbytes = this._huffCoder.huffEncode(this._huffchars, nbytes, encodedData, index, outputBufferSize - nbytesHdr)) == 0) {
            return 0;
        }
        return nbytes + nbytesHdr;
    }

    int dataDecode(byte[] encodedData, int index, byte[] workBuffer, int workBufferSize, int nsamps, float[] data) {
        int idelta = BlockCompressor.stuffBytesInInt(encodedData, index);
        float delta = Float.intBitsToFloat(idelta);
        int nNonZero = BlockCompressor.stuffBytesInInt(encodedData, index += 4);
        int nbytes = this._huffCoder.huffDecode(encodedData, index += 4, workBuffer, workBufferSize);
        if (nbytes == -1) {
            return -1;
        }
        BlockCompressor.runLengthDecodeDequant(workBuffer, nbytes, delta, data);
        for (int i = 0; i < nsamps - nNonZero; ++i) {
            data[i + nNonZero] = 0.0f;
        }
        return 0;
    }

    static {
        c_littleEndian = ByteOrder.LITTLE_ENDIAN.equals(ByteOrder.nativeOrder());
    }
}

