/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.GlobalTraceAccessorInterface;
import org.javaseis.parallel.IParallelContext;

public class DistributedArrayGlobalTraceAccessor
implements GlobalTraceAccessorInterface {
    private static final boolean DEBUG = false;
    private String _name;
    private DistributedArray _a;
    private final IParallelContext _parallelContext;
    private final int _rank;
    private final int _size;
    private int _nFrames;
    private int _nTraces;
    private int _nSamples;
    private int _elementCount;
    private final float[] _remoteFloatBuf;
    private final int[] _remoteIntBuf;
    private static final int FOREMAN = 0;
    private static final int OPCODE_SUCCESS = 1001;
    private static final int OPCODE_FAILURE = 1002;
    private static final int OPCODE_EXIT = 1003;
    private static final int OPCODE_SEND_MINMAX = 1004;
    private static final int OPCODE_GET_SUBTRACE_FLOAT = 1005;
    private static final int OPCODE_GET_TRACE_INT = 1006;
    private static final int OPCODE_PUT_TRACE_INT = 1007;
    private final int TAG_OPCODE = 101;
    private final int TAG_CUSTOM = 102;
    private final int TAG_IBUF1 = 103;
    private final int TAG_IBUF2 = 104;
    private final int TAG_IBUF4 = 105;
    private final int TAG_IBUF6 = 106;
    private final int TAG_IBUFN = 107;
    private final int TAG_FBUF2 = 108;
    private final int TAG_FBUFN = 109;
    private Float _localMinValue = Float.valueOf(Float.MAX_VALUE);
    private final int[] _localMinPosition = new int[3];
    private Float _localMaxValue = Float.valueOf(-3.4028235E38f);
    private final int[] _localMaxPosition = new int[3];
    private Float _globalMinValue;
    private final int[] _globalMinPosition = new int[3];
    private Float _globalMaxValue;
    private final int[] _globalMaxPosition = new int[3];
    private int _statusCode;

    public DistributedArrayGlobalTraceAccessor(String name, int tag, DistributedArray distributedArray, boolean prepareMinMaxInformation) {
        this._name = name;
        this.setActiveDistributedArray(distributedArray);
        this._parallelContext = distributedArray.getParallelContext();
        this._rank = this._parallelContext.rank();
        this._size = this._parallelContext.size();
        int[] shape = this._a.getShape();
        this._nFrames = shape[2];
        this._nTraces = shape[1];
        this._nSamples = shape[0];
        this._elementCount = this._a.getElementCount();
        this._remoteFloatBuf = new float[this._elementCount * this._nSamples];
        this._remoteIntBuf = new int[this._elementCount * this._nSamples];
        this._globalMinValue = null;
        this._globalMaxValue = null;
        this._localMinValue = Float.valueOf(Float.MAX_VALUE);
        this._localMaxValue = Float.valueOf(-1.4E-45f);
        if (prepareMinMaxInformation) {
            this.prepareLocalMinMaxInformation();
        }
        if (this._rank != 0) {
            this.loopIndefinitelyAsWorker();
        }
    }

    public final int getRank() {
        return this._rank;
    }

    public final int getSize() {
        return this._size;
    }

    @Override
    public final void setActiveDistributedArray(DistributedArray a) {
        this._a = a;
    }

    @Override
    public final DistributedArray getActiveDistributedArray() {
        return this._a;
    }

    public final void resetDistributedArray(DistributedArray distributedArray) {
        int[] shape = distributedArray.getShape();
        if (shape[2] != this._nFrames) {
            throw new IllegalArgumentException("shape[2] changed upon reset");
        }
        if (shape[1] != this._nTraces) {
            throw new IllegalArgumentException("shape[1] changed upon reset");
        }
        if (shape[0] != this._nSamples) {
            throw new IllegalArgumentException("shape[0] changed upon reset");
        }
        this._a = distributedArray;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public final String getName() {
        return this._name;
    }

    @Override
    public final float getGlobalMinimum() {
        if (this._globalMinValue == null) {
            this.prepareGlobalMinMaxInformation();
        }
        return this._globalMinValue.floatValue();
    }

    @Override
    public final float getGlobalMaximum() {
        if (this._globalMaxValue == null) {
            this.prepareGlobalMinMaxInformation();
        }
        return this._globalMaxValue.floatValue();
    }

    private final synchronized void prepareGlobalMinMaxInformation() {
        if (this._rank != 0) {
            return;
        }
        int[] ibuf1 = new int[1];
        int[] ibuf6 = new int[6];
        float[] fbuf2 = new float[2];
        ibuf1[0] = 1004;
        this._globalMinValue = this._localMinValue;
        this._globalMaxValue = this._localMaxValue;
        this._globalMinPosition[0] = this._localMinPosition[0];
        this._globalMinPosition[1] = this._localMinPosition[1];
        this._globalMinPosition[2] = this._localMinPosition[2];
        this._globalMaxPosition[0] = this._localMaxPosition[0];
        this._globalMaxPosition[1] = this._localMaxPosition[1];
        this._globalMaxPosition[2] = this._localMaxPosition[2];
        for (int i = 1; i < this._size; ++i) {
            this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
            this._parallelContext.recvFloat(108, fbuf2, 0, 2);
            this._parallelContext.recvInt(106, ibuf6, 0, 6);
            if (fbuf2[0] < this._globalMinValue.floatValue()) {
                this._globalMinValue = Float.valueOf(fbuf2[0]);
                this._globalMinPosition[2] = ibuf6[0];
                this._globalMinPosition[1] = ibuf6[1];
                this._globalMinPosition[0] = ibuf6[2];
            }
            if (!(fbuf2[1] > this._globalMaxValue.floatValue())) continue;
            this._globalMaxValue = Float.valueOf(fbuf2[1]);
            this._globalMaxPosition[2] = ibuf6[3];
            this._globalMaxPosition[1] = ibuf6[4];
            this._globalMaxPosition[0] = ibuf6[5];
        }
    }

    private final synchronized void loopIndefinitelyAsWorker() {
        int[] ibuf1 = new int[1];
        int[] ibuf2 = new int[2];
        int[] ibuf3 = new int[3];
        int[] ibuf4 = new int[4];
        int[] ibuf6 = new int[6];
        float[] fbuf2 = new float[2];
        boolean keepLooping = true;
        block18: while (keepLooping) {
            this._parallelContext.recvInt(101, ibuf1, 0, 1);
            switch (ibuf1[0]) {
                case 1004: {
                    fbuf2[0] = this._localMinValue.floatValue();
                    fbuf2[1] = this._localMaxValue.floatValue();
                    this._parallelContext.sendFloat(108, fbuf2, 0, 2, 0);
                    ibuf6[0] = this._localMinPosition[2];
                    ibuf6[1] = this._localMinPosition[1];
                    ibuf6[2] = this._localMinPosition[0];
                    ibuf6[3] = this._localMaxPosition[2];
                    ibuf6[4] = this._localMaxPosition[1];
                    ibuf6[5] = this._localMaxPosition[0];
                    this._parallelContext.sendInt(106, ibuf6, 0, 6, 0);
                    continue block18;
                }
                case 1005: {
                    this._parallelContext.recvInt(105, ibuf4, 0, 4);
                    try {
                        ibuf3[0] = ibuf4[0];
                        ibuf3[1] = ibuf4[1];
                        ibuf3[2] = ibuf4[2];
                        this._a.getSubTrace(this._remoteFloatBuf, ibuf3, 0, ibuf4[3]);
                        ibuf1[0] = 1001;
                        this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                        this._parallelContext.sendFloat(109, this._remoteFloatBuf, 0, ibuf4[3], 0);
                        continue block18;
                    }
                    catch (Exception e) {
                    }
                    catch (Error e) {
                        // empty catch block
                    }
                    ibuf1[0] = 1002;
                    this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                    continue block18;
                }
                case 1006: {
                    this._parallelContext.recvInt(105, ibuf4, 0, 4);
                    try {
                        ibuf3[0] = ibuf4[0];
                        ibuf3[1] = ibuf4[1];
                        ibuf3[2] = ibuf4[2];
                        this._a.getTrace(this._remoteIntBuf, ibuf3);
                        ibuf1[0] = 1001;
                        this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                        this._parallelContext.sendInt(107, this._remoteIntBuf, 0, ibuf4[3], 0);
                        continue block18;
                    }
                    catch (Exception e) {
                    }
                    catch (Error e) {
                        // empty catch block
                    }
                    ibuf1[0] = 1002;
                    this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                    continue block18;
                }
                case 1007: {
                    this._parallelContext.recvInt(105, ibuf4, 0, 4);
                    try {
                        ibuf3[0] = ibuf4[0];
                        ibuf3[1] = ibuf4[1];
                        ibuf3[2] = ibuf4[2];
                        ibuf1[0] = 1001;
                        this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                        this._parallelContext.recvInt(107, this._remoteIntBuf, 0, ibuf4[3]);
                        this._a.putTrace(this._remoteIntBuf, ibuf3);
                        continue block18;
                    }
                    catch (Exception e) {
                    }
                    catch (Error e) {
                        // empty catch block
                    }
                    ibuf1[0] = 1002;
                    this._parallelContext.sendInt(103, ibuf1, 0, 1, 0);
                    continue block18;
                }
                case 1003: {
                    this._parallelContext.recvInt(103, ibuf1, 0, 1);
                    this._statusCode = ibuf1[0];
                    keepLooping = false;
                    continue block18;
                }
            }
            int methodID = ibuf1[0];
            this._parallelContext.recvInt(103, ibuf1, 0, 1);
            Object[] inputArgs = new Object[ibuf1[0]];
            this._parallelContext.recv(104, inputArgs, 0, inputArgs.length);
            try {
                Object[] outputArg = new Object[]{this.runGlobalCustomMethod(methodID, inputArgs)};
                ibuf2[0] = 1001;
                ibuf2[1] = this._rank;
                this._parallelContext.sendInt(112, ibuf2, 0, 2, 0);
                this._parallelContext.send(113, outputArg, 0, 1, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                ibuf2[0] = 1002;
                ibuf2[1] = 0;
                this._parallelContext.sendInt(104, ibuf2, 0, 2, 0);
            }
        }
    }

    public final Object[] invokeGlobalCustomMethod(int methodID, Object[] inputArgs) {
        if (this._rank != 0) {
            throw new RuntimeException("method can only be called on _rank == 0");
        }
        if (methodID >= 0) {
            throw new IllegalArgumentException("custom methodID's must be negative");
        }
        int[] ibuf1 = new int[1];
        int[] ibuf2 = new int[2];
        for (int i = 1; i < this._size; ++i) {
            ibuf1[0] = methodID;
            this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
            ibuf1[0] = inputArgs.length;
            this._parallelContext.sendInt(103, ibuf1, 0, 1, i);
            this._parallelContext.send(104, inputArgs, 0, inputArgs.length, i);
        }
        Object[][] outputArgs = new Object[this._size][1];
        outputArgs[0] = this.runGlobalCustomMethod(methodID, inputArgs);
        for (int i = 1; i < this._size; ++i) {
            this._parallelContext.recvInt(112, ibuf2, 0, 2);
            int fromRank = ibuf2[1];
            if (ibuf2[0] == 1001) {
                Object[] tmp = new Object[1];
                this._parallelContext.recv(113, tmp, 0, 1);
                outputArgs[fromRank] = tmp[0];
                continue;
            }
            if (ibuf2[0] == 1002) {
                outputArgs[fromRank] = null;
                continue;
            }
            throw new RuntimeException("illegal status code from " + fromRank + " was " + ibuf2[0]);
        }
        return outputArgs;
    }

    protected Object runGlobalCustomMethod(int methodID, Object[] inputArgs) {
        String s = "methodID " + methodID + " not understood (this method should be overridden anyway!)";
        throw new IllegalStateException(s);
    }

    private synchronized void prepareLocalMinMaxInformation() {
        int[] position = new int[3];
        int[] activeLocalShape = this._a.getLocalShape();
        float[] buf = new float[this._elementCount * this._nSamples];
        for (int frameIndex = 0; frameIndex < activeLocalShape[2]; ++frameIndex) {
            position[2] = this._a.localToGlobal(2, frameIndex);
            for (int traceIndex = 0; traceIndex < activeLocalShape[1]; ++traceIndex) {
                position[1] = this._a.localToGlobal(1, traceIndex);
                this._a.getTrace(buf, position);
                for (int sampleIndex = 0; sampleIndex < this._nSamples; ++sampleIndex) {
                    float val;
                    if (this._elementCount == 1) {
                        val = buf[sampleIndex];
                    } else {
                        float val0 = buf[2 * sampleIndex];
                        float val1 = buf[2 * sampleIndex + 1];
                        val = (float)Math.sqrt(val0 * val0 + val1 * val1);
                    }
                    if (val < this._localMinValue.floatValue()) {
                        this._localMinValue = Float.valueOf(val);
                        this._localMinPosition[0] = sampleIndex;
                        this._localMinPosition[1] = traceIndex;
                        this._localMinPosition[2] = frameIndex;
                    }
                    if (!(val > this._localMaxValue.floatValue())) continue;
                    this._localMaxValue = Float.valueOf(val);
                    this._localMaxPosition[0] = sampleIndex;
                    this._localMaxPosition[1] = traceIndex;
                    this._localMaxPosition[2] = frameIndex;
                }
            }
        }
    }

    public synchronized void getGlobalTrace(int[] traceBuf, int[] position) {
        assert (this._rank == 0) : "method should only be called when rank == 0!";
        if (position[2] < this._a.getLocalShape()[2]) {
            this._a.getTrace(traceBuf, position);
        } else {
            int[] ibuf1 = new int[1];
            int[] ibuf4 = new int[4];
            block3: for (int i = 1; i < this._size; ++i) {
                ibuf1[0] = 1006;
                this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
                ibuf4[0] = position[0];
                ibuf4[1] = position[1];
                ibuf4[2] = position[2];
                ibuf4[3] = traceBuf.length;
                this._parallelContext.sendInt(105, ibuf4, 0, 4, i);
                this._parallelContext.recvInt(103, ibuf1, 0, 1);
                switch (ibuf1[0]) {
                    case 1001: {
                        this._parallelContext.recvInt(107, traceBuf, 0, traceBuf.length);
                        i = this._size;
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public synchronized void getGlobalTrace(float[] traceBuf, int[] position) {
        this.getGlobalSubTrace(traceBuf, position, 0, traceBuf.length);
    }

    @Override
    public synchronized void getGlobalSubTrace(float[] traceBuf, int[] position, int ofs, int len) {
        assert (this._rank == 0) : "method should only be called when rank == 0!";
        if (position[2] < this._a.getLocalShape()[2]) {
            this._a.getSubTrace(traceBuf, position, ofs, len);
        } else {
            int[] ibuf1 = new int[1];
            int[] ibuf4 = new int[4];
            block3: for (int i = 1; i < this._size; ++i) {
                ibuf1[0] = 1005;
                this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
                ibuf4[0] = position[0];
                ibuf4[1] = position[1];
                ibuf4[2] = position[2];
                ibuf4[3] = len;
                this._parallelContext.sendInt(105, ibuf4, 0, 4, i);
                this._parallelContext.recvInt(103, ibuf1, 0, 1);
                switch (ibuf1[0]) {
                    case 1001: {
                        this._parallelContext.recvFloat(109, traceBuf, ofs, len);
                        i = this._size;
                        continue block3;
                    }
                }
            }
        }
    }

    public synchronized void putGlobalTrace(int[] traceBuf, int[] position) {
        assert (this._rank == 0) : "method should only be called when rank == 0!";
        if (position[2] < this._a.getLocalShape()[2]) {
            this._a.putTrace(traceBuf, position);
        } else {
            int[] ibuf1 = new int[1];
            int[] ibuf4 = new int[4];
            block3: for (int i = 1; i < this._size; ++i) {
                ibuf1[0] = 1007;
                this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
                ibuf4[0] = position[0];
                ibuf4[1] = position[1];
                ibuf4[2] = position[2];
                ibuf4[3] = traceBuf.length;
                this._parallelContext.sendInt(105, ibuf4, 0, 4, i);
                this._parallelContext.recvInt(103, ibuf1, 0, 1);
                switch (ibuf1[0]) {
                    case 1001: {
                        this._parallelContext.sendInt(107, traceBuf, 0, traceBuf.length, i);
                        i = this._size;
                        continue block3;
                    }
                }
            }
        }
    }

    public final synchronized void killWorkers(int statusCode) {
        if (this._rank == 0) {
            this._statusCode = statusCode;
            int[] ibuf1 = new int[1];
            for (int i = 1; i < this._size; ++i) {
                ibuf1[0] = 1003;
                this._parallelContext.sendInt(101, ibuf1, 0, 1, i);
                ibuf1[0] = statusCode;
                this._parallelContext.sendInt(103, ibuf1, 0, 1, i);
            }
        }
    }
}

