/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.javaseis.io.VirtualIO;
import org.javaseis.io.VirtualMappedIO;
import org.javaseis.util.SeisException;

public class TestVirtualMappedIO {
    private static final Logger LOG = Logger.getLogger(TestVirtualMappedIO.class.getName());

    public void write(String path, int tpf, int frames) throws SeisException {
        byte[] buf = new byte[8 * tpf];
        ByteBuffer traceBuffer = ByteBuffer.wrap(buf);
        traceBuffer.order(ByteOrder.nativeOrder());
        VirtualIO traceMapio = new VirtualIO(path, "rw");
        long index = 0L;
        long fpos = 0L;
        for (int frame = 0; frame < frames; ++frame) {
            traceBuffer.rewind();
            for (int i = 0; i < tpf; ++i) {
                traceBuffer.putLong(index++);
            }
            traceBuffer.flip();
            fpos = 8L * (long)tpf * (long)frame;
            traceMapio.setPosition(fpos);
            traceMapio.write(traceBuffer);
        }
        traceMapio.close();
    }

    public void writeMapped(String path, int tpf, int frames) throws SeisException {
        byte[] buf = new byte[8 * tpf];
        ByteBuffer traceBuffer = ByteBuffer.wrap(buf);
        traceBuffer.order(ByteOrder.nativeOrder());
        long flen = 8L * (long)tpf * (long)frames;
        int mapSize = 21474836;
        VirtualMappedIO traceMapio = new VirtualMappedIO(path, mapSize, flen);
        long index = 0L;
        long fpos = 0L;
        for (int frame = 0; frame < frames; ++frame) {
            traceBuffer.rewind();
            for (int i = 0; i < tpf; ++i) {
                traceBuffer.putLong(index++);
            }
            traceBuffer.flip();
            fpos = 8L * (long)tpf * (long)frame;
            traceMapio.setPosition(fpos);
            traceMapio.write(traceBuffer);
        }
        traceMapio.close();
    }

    public void read(int tpf, long frames, String path) throws SeisException {
        byte[] buf = new byte[8 * tpf];
        ByteBuffer traceBuffer = ByteBuffer.wrap(buf);
        traceBuffer.order(ByteOrder.nativeOrder());
        VirtualIO traceMapio = new VirtualIO(path, "r");
        long index = 0L;
        long fpos = 0L;
        for (long frame = 0L; frame < frames; ++frame) {
            traceBuffer.rewind();
            fpos = 8L * (long)tpf * frame;
            traceMapio.setPosition(fpos);
            traceMapio.read(traceBuffer);
            traceBuffer.flip();
            for (int i = 0; i < tpf; ++i) {
                long value = traceBuffer.getLong();
                assert (value == index++);
            }
        }
        traceMapio.close();
    }

    public void mappedread(int tpf, long frames, String path) throws SeisException {
        byte[] buf = new byte[8 * tpf];
        ByteBuffer traceBuffer = ByteBuffer.wrap(buf);
        traceBuffer.order(ByteOrder.nativeOrder());
        VirtualMappedIO traceMapio = new VirtualMappedIO(path);
        long index = 0L;
        long fpos = 0L;
        for (long frame = 0L; frame < frames; ++frame) {
            traceBuffer.rewind();
            traceBuffer.limit(8 * tpf);
            fpos = 8L * (long)tpf * frame;
            traceMapio.setPosition(fpos);
            traceMapio.read(traceBuffer);
            traceBuffer.position(0);
            traceBuffer.limit(8 * tpf);
            for (int i = 0; i < tpf; ++i) {
                long value = traceBuffer.getLong();
                assert (value == index++);
            }
        }
        traceMapio.close();
    }

    public static void main(String[] args) throws Exception {
        long fSize = 0x1000000L;
        int tpfIn = 1024;
        int framesIn = (int)fSize / tpfIn;
        long countIn = (long)tpfIn * (long)framesIn;
        LOG.info("tpfIn=" + tpfIn + " framesIn=" + framesIn + " countIn=" + countIn);
        File out1 = File.createTempFile("sort", "out");
        LOG.info("Writing with VirtualIO");
        TestVirtualMappedIO t = new TestVirtualMappedIO();
        t.write(out1.getAbsolutePath(), tpfIn, framesIn);
        long flen = out1.length();
        long countOut = flen / 8L;
        long framesOut = flen / (8L * (long)tpfIn);
        LOG.info("flen=" + flen + " countOut=" + countOut + " framesOut=" + framesOut);
        assert (countIn == countOut);
        assert ((long)framesIn == framesOut);
        LOG.info("Reading with VirtualIO");
        t.read(tpfIn, framesIn, out1.getAbsolutePath());
        LOG.info("Reading with VirtualMappedIO");
        t.mappedread(tpfIn, framesIn, out1.getAbsolutePath());
        out1.delete();
        out1 = File.createTempFile("sort", "out");
        LOG.info("Writing with VirtualMappedIO");
        t = new TestVirtualMappedIO();
        t.writeMapped(out1.getAbsolutePath(), tpfIn, framesIn);
        flen = out1.length();
        countOut = flen / 8L;
        framesOut = flen / (8L * (long)tpfIn);
        LOG.info("flen=" + flen + " countOut=" + countOut + " framesOut=" + framesOut);
        assert (countIn == countOut);
        assert ((long)framesIn == framesOut);
        LOG.info("Reading with VirtualIO");
        t.read(tpfIn, framesIn, out1.getAbsolutePath());
        LOG.info("Reading with VirtualMappedIO");
        t.mappedread(tpfIn, framesIn, out1.getAbsolutePath());
        out1.delete();
    }
}

