/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.javaseis.grid.GridDefinition;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFolders;
import org.javaseis.properties.AxisDefinition;
import org.javaseis.properties.AxisLabel;
import org.javaseis.properties.DataDefinition;
import org.javaseis.properties.DataDomain;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;
import org.javaseis.properties.PropertyDescription;
import org.javaseis.properties.TraceProperties;
import org.javaseis.properties.Units;
import org.javaseis.util.SeisException;

public class JTest5D
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTest5D.class.getName());

    public void test1() throws Exception {
        this.testFileStruct("desc", "/Users/matt/Data/JavaSeisTest/test2.js", null, 0);
    }

    private void testFileStruct(String testDesc, String path, VirtualFolders vFolders, int vfioExtentCount) throws Exception {
        int origNumDimensions = 5;
        int origNumSamples = 251;
        int origNumTraces = 50;
        int origNumFrames = 21;
        int origNumVolumes = 11;
        int origNumHypercubes = 3;
        AxisDefinition[] axes = new AxisDefinition[origNumDimensions];
        axes[0] = new AxisDefinition(AxisLabel.TIME, Units.MSEC, DataDomain.TIME, origNumSamples, 0L, 4L, 0.0, 4.0);
        axes[1] = new AxisDefinition(AxisLabel.OFFSET, Units.FEET, DataDomain.SPACE, origNumTraces, 50L, 50L, 50.0, 50.0);
        axes[2] = new AxisDefinition(AxisLabel.CROSSLINE, Units.FEET, DataDomain.SPACE, origNumFrames, 100L, 1L, 1250.0, 12.5);
        axes[3] = new AxisDefinition(AxisLabel.INLINE, Units.FEET, DataDomain.SPACE, origNumVolumes, 200L, 2L, 5000.0, 25.0);
        axes[4] = new AxisDefinition(AxisLabel.OFFSET_BIN, Units.FEET, DataDomain.SPACE, origNumHypercubes, 300L, 3L, 1000.0, 17.0);
        GridDefinition origGridDef = new GridDefinition(origNumDimensions, axes);
        System.out.println("Seisio: " + testDesc + " dataset grid definition created.");
        DataType origDataType = DataType.CMP;
        DataFormat origTraceFormat = DataFormat.FLOAT;
        DataDefinition origDataDef = new DataDefinition(origDataType, origTraceFormat);
        System.out.println("Seisio: " + testDesc + " dataset data definition created.");
        String[] Presidents = new String[]{"George Washington", "Thomas Jefferson", "Abe Lincoln", "Teddy Roosevelt"};
        int origNumHeaderProps = 5;
        PropertyDescription[] origHeaderProps = new PropertyDescription[origNumHeaderProps];
        origHeaderProps[0] = new PropertyDescription("THE_PREZ", "Name of President", 9, 27);
        origHeaderProps[1] = new PropertyDescription("ILINE_NO", "Inline #", 3, 1);
        origHeaderProps[2] = new PropertyDescription("XLINE_NO", "Crossline #", 3, 1);
        origHeaderProps[3] = new PropertyDescription("SRC_XYZ", "Source xyz-coordinates", 6, 3);
        origHeaderProps[4] = new PropertyDescription("RECV_XYZ", "Receiver xyz-coordinates", 6, 3);
        TraceProperties origHeaderDef = new TraceProperties(origNumHeaderProps, origHeaderProps);
        System.out.println("Seisio: " + testDesc + " dataset header definition created.");
        Seisio fileStruct = new Seisio(path, origGridDef, origDataDef, origHeaderDef);
        fileStruct.setMapped();
        if (vFolders == null) {
            fileStruct.create();
        } else {
            fileStruct.create(vFolders, vfioExtentCount);
        }
        System.out.println("Seisio: " + testDesc + " dataset created.");
        float[][] origTraceData = fileStruct.getTraceDataArray();
        double pi = Math.PI;
        double omega1 = pi / (double)(origNumSamples - 1);
        for (int i = 0; i < origNumTraces; ++i) {
            double omega2 = (double)(i + 10) * omega1;
            for (int j = 0; j < origNumSamples; ++j) {
                double t = j;
                origTraceData[i][j] = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
            }
        }
        System.out.println("Seisio: " + testDesc + " dataset synthetic traces generated.");
        double[] xyz = new double[3];
        double dxy = 0.0;
        int[] origPosition = new int[origNumDimensions];
        origPosition[0] = 0;
        origPosition[1] = 0;
        for (int volumeIndex = 0; volumeIndex < origNumVolumes; ++volumeIndex) {
            origPosition[3] = volumeIndex;
            AxisDefinition volumeAxis = origGridDef.getAxis(3);
            int iline = (int)(volumeAxis.getLogicalOrigin() + volumeAxis.getLogicalDelta() * (long)volumeIndex);
            double xm = volumeAxis.getPhysicalOrigin() + volumeAxis.getPhysicalDelta() * (double)volumeIndex;
            int frameIndex = 0;
            while (frameIndex < origNumFrames) {
                AxisDefinition frameAxis = origGridDef.getAxis(2);
                int xline = (int)(frameAxis.getLogicalOrigin() + frameAxis.getLogicalDelta() * (long)frameIndex);
                double ym = frameAxis.getPhysicalOrigin() + frameAxis.getPhysicalDelta() * (double)frameIndex;
                for (int traceIndex = 0; traceIndex < origNumTraces; ++traceIndex) {
                    AxisDefinition traceAxis = origGridDef.getAxis(1);
                    dxy = traceAxis.getPhysicalOrigin() + traceAxis.getPhysicalDelta() * (double)traceIndex;
                    origHeaderDef.setTraceIndex(traceIndex);
                    origHeaderDef.putInt("ILINE_NO", iline);
                    origHeaderDef.putInt("XLINE_NO", xline);
                    xyz[0] = xm;
                    xyz[1] = ym;
                    xyz[2] = 0.0;
                    origHeaderDef.putDoubleArray("SRC_XYZ", xyz);
                    xyz[0] = xm + dxy;
                    xyz[1] = ym - dxy;
                    xyz[2] = 1.0;
                    origHeaderDef.putDoubleArray("RECV_XYZ", xyz);
                    int presIndex = traceIndex % Presidents.length;
                    origHeaderDef.putValue("THE_PREZ", Presidents[presIndex]);
                }
                origPosition[2] = frameIndex++;
                int count = fileStruct.writeFrame(origPosition, origNumTraces);
                if (count == origNumTraces) continue;
                throw new SeisException("Seisio: Error writing to dataset (" + count + " != " + origNumTraces);
            }
        }
        System.out.println("Seisio: " + testDesc + " dataset written.");
        fileStruct.close();
        System.out.println("Seisio: " + testDesc + " dataset closed.");
        fileStruct.open("rw");
        System.out.println("Seisio: " + testDesc + " dataset opened.");
        GridDefinition testGridDef = fileStruct.getGridDefinition();
        System.out.println("Seisio: Checking grid definition...");
        int testNumDimensions = testGridDef.getNumDimensions();
        if (testNumDimensions != origNumDimensions) {
            throw new SeisException("Mismatch in data type: " + testNumDimensions + " vs " + origNumDimensions);
        }
        for (int i = 0; i < testNumDimensions; ++i) {
            AxisDefinition axis = testGridDef.getAxis(i);
            System.out.println("Seisio:   Axis : " + axis.getLabel() + " --> " + "units=" + axis.getUnits() + ", domain=" + axis.getDomain());
        }
        long testNumSamples = testGridDef.getNumSamplesPerTrace();
        if (testNumSamples != (long)origNumSamples) {
            throw new SeisException("Mismatch in # of samples: " + testNumSamples + " vs " + origNumSamples);
        }
        long testNumTraces = testGridDef.getNumTracesPerFrame();
        if (testNumTraces != (long)origNumTraces) {
            throw new SeisException("Mismatch in # of traces: " + testNumTraces + " vs " + origNumTraces);
        }
        long testNumFrames = testGridDef.getNumFramesPerVolume();
        if (testNumFrames != (long)origNumFrames) {
            throw new SeisException("Mismatch in # of frames: " + testNumFrames + " vs " + origNumFrames);
        }
        long testNumVolumes = testGridDef.getNumVolumesPerHypercube();
        if (testNumVolumes != (long)origNumVolumes) {
            throw new SeisException("Mismatch in # of volumes: " + testNumVolumes + " vs " + origNumVolumes);
        }
        DataDefinition testDataDef = fileStruct.getDataDefinition();
        System.out.println("Seisio: Checking data definition...");
        DataType testDataType = testDataDef.getDataType();
        if (testDataType != origDataType) {
            throw new SeisException("Mismatch in data type: " + testDataDef.getDataTypeString() + " vs " + origDataDef.getDataTypeString());
        }
        DataFormat testTraceFormat = testDataDef.getTraceFormat();
        if (testTraceFormat != origTraceFormat) {
            throw new SeisException("Mismatch in trace format: " + testDataDef.getTraceFormatString() + " vs " + origDataDef.getTraceFormatString());
        }
        TraceProperties testHeaderDef = fileStruct.getTraceProperties();
        System.out.println("Seisio: Checking header definition...");
        int testNumHeaderProps = testHeaderDef.getNumProperties();
        if (testNumHeaderProps != origNumHeaderProps) {
            throw new SeisException("Mismatch in # of header properties: " + testNumHeaderProps + " vs " + origNumHeaderProps);
        }
        PropertyDescription[] testHeaderProps = testHeaderDef.getTraceProperties();
        for (int i = 0; i < testNumHeaderProps; ++i) {
            System.out.println("Seisio:   Header : " + testHeaderProps[i].getLabel() + " --> " + testHeaderProps[i].getDescription() + ", reclen=" + testHeaderProps[i].getRecordLength() + ", offset=" + testHeaderProps[i].getOffset());
        }
        float[][] testTraceData = fileStruct.getTraceDataArray();
        int[] testPosition = new int[testNumDimensions];
        testPosition[0] = 0;
        testPosition[1] = 0;
        int volumeIndex = 0;
        while ((long)volumeIndex < testNumVolumes) {
            testPosition[3] = volumeIndex;
            int frameIndex = 0;
            while ((long)frameIndex < testNumFrames) {
                testPosition[2] = frameIndex;
                int count = fileStruct.readFrame(testPosition);
                if ((long)count != testNumTraces) {
                    throw new SeisException("Error reading from dataset (" + count + " != " + testNumTraces);
                }
                if ((long)volumeIndex == testNumVolumes / 2L && (long)frameIndex == testNumFrames / 2L) {
                    int traceIndex = 0;
                    while ((long)traceIndex < testNumTraces) {
                        if ((long)traceIndex == testNumTraces / 2L) {
                            System.out.println("Seisio: Checking header...");
                            testHeaderDef.setTraceIndex(traceIndex);
                            for (int headerIndex = 0; headerIndex < testNumHeaderProps; ++headerIndex) {
                                String key = testHeaderProps[headerIndex].getLabel();
                                System.out.println("Seisio:   Header : " + key + " --> " + testHeaderDef.getValue(key));
                            }
                        }
                        ++traceIndex;
                    }
                }
                ++frameIndex;
            }
            ++volumeIndex;
        }
        System.out.println("Seisio: " + testDesc + " data set read.");
        fileStruct.close();
        System.out.println("Seisio: " + testDesc + " data set closed.");
    }
}

