/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.io.BufferedVirtualIO;
import org.javaseis.io.IVirtualIO;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortNameFilter;
import org.javaseis.io.VirtualIO;
import org.javaseis.io.VirtualMappedIO;
import org.javaseis.util.SeisException;

public class SortMapIO {
    private static final Logger LOG = Logger.getLogger(SortMapIO.class.getName());
    private String _sortmapName;
    private String _basePath;
    private SortIOParms _parms;
    private ByteOrder _order = ByteOrder.nativeOrder();
    private boolean _readOnly = true;
    private IVirtualIO _volumeMapio;
    private ByteBuffer _volumeBuffer;
    private IntBuffer _volumeView;
    private int[] _volumeMap;
    private int _currentVolume = -1;
    private int _logicalVolume = Integer.MIN_VALUE;
    private IVirtualIO _frameMapio;
    private ByteBuffer _frameBuffer;
    private IntBuffer _frameView;
    private int[] _frameMap;
    private int _logicalFrame = Integer.MIN_VALUE;
    private int _currentFrame = -1;
    private int _framesInVolume;
    private IVirtualIO _traceMapio;
    private ByteBuffer _traceBuffer;
    private LongBuffer _traceView;
    private long[] _traceList;
    private int _tracesInFrame = -1;

    public SortMapIO(String basePath, String sortmapName) throws IOException {
        this(basePath, sortmapName, null);
    }

    public SortMapIO(String basePath, String sortmapName, SortIOParms parms) throws IOException {
        if (basePath == null || basePath.isEmpty()) {
            throw new IllegalArgumentException("The path to the base dataset is invalid " + basePath);
        }
        if (sortmapName == null || sortmapName.isEmpty()) {
            throw new IllegalArgumentException("The sortmap name is invalid " + sortmapName);
        }
        this._basePath = basePath;
        this._sortmapName = sortmapName;
        this._parms = parms;
        if (this._parms == null) {
            this._parms = new SortIOParms();
            this._parms.loadDefinition(this._basePath, this._sortmapName);
        }
    }

    public SortIOParms getParms() {
        return this._parms;
    }

    public void open(String mode) throws SeisException {
        if (mode.compareToIgnoreCase("r") != 0) {
            this._readOnly = false;
        }
        this._volumeMap = new int[2 * this._parms.volumes];
        this._frameMap = new int[2 * this._parms.framesPerVolume];
        this._traceList = new long[this._parms.tracesPerFrame];
        this._frameBuffer = ByteBuffer.allocateDirect(8 * this._parms.framesPerVolume);
        this._frameBuffer.order(ByteOrder.nativeOrder());
        this._frameView = this._frameBuffer.asIntBuffer();
        byte[] buf = new byte[8 * this._parms.tracesPerFrame];
        this._traceBuffer = ByteBuffer.wrap(buf);
        this._traceBuffer.order(ByteOrder.nativeOrder());
        this._traceView = this._traceBuffer.asLongBuffer();
        this._volumeMapio = new VirtualIO(this._basePath + File.separator + "SortVolumeMap." + this._sortmapName, mode);
        this._frameMapio = this._readOnly ? new VirtualIO(this._basePath + File.separator + "SortFrameMap." + this._sortmapName, mode) : new VirtualIO(this._basePath + File.separator + "SortFrameMap." + this._sortmapName, mode);
        this._volumeBuffer = ByteBuffer.allocateDirect(8 * this._parms.volumes);
        this._volumeBuffer.order(this._order);
        this._volumeBuffer.clear();
        this._volumeView = this._volumeBuffer.asIntBuffer();
        this._volumeMapio.trackTime(true);
        this._frameMapio.trackTime(true);
        if (this._readOnly) {
            this._traceMapio = new VirtualMappedIO(this._basePath + File.separator + "SortTraceMap." + this._sortmapName);
            int lenr = this._volumeMapio.read(this._volumeBuffer);
            if (8 * this._parms.volumes != lenr) {
                throw new SeisException("Could not read volume map");
            }
            this._volumeBuffer.position(0);
            this._volumeView.position(0);
            this._volumeView.get(this._volumeMap);
            this._volumeMapio.close();
            this._volumeView = null;
            this._volumeBuffer = null;
            this.setVolume(0);
            this.setFrame(0);
        } else {
            this._traceMapio = new VirtualIO(this._basePath + File.separator + "SortTraceMap." + this._sortmapName, mode);
        }
    }

    public String getIoTimes() {
        if (this._volumeMapio == null || this._frameMapio == null) {
            return "";
        }
        float vtime = this._volumeMapio.getIoTime();
        float ftime = this._frameMapio.getIoTime();
        float ttime = this._traceMapio.getIoTime();
        StringBuffer buf = new StringBuffer();
        if (this._readOnly) {
            buf.append("VolumeMap Read time = " + vtime / 1000.0f + " ms\n");
            buf.append("FrameMap Read time = " + ftime / 1000.0f + " ms\n");
            buf.append("TraceMap Read time = " + ttime / 1000.0f + " ms\n");
        } else {
            buf.append("VolumeMap Write time = " + vtime / 1000.0f + " ms\n");
            buf.append("FrameMap Write time = " + ftime / 1000.0f + " ms\n");
            buf.append("TraceMap Write time = " + ttime / 1000.0f + " ms\n");
            if (this._frameMapio instanceof BufferedVirtualIO) {
                buf.append("FrameMap write stats " + ((BufferedVirtualIO)this._frameMapio).getWriteStats() + "\n");
            }
            if (this._traceMapio instanceof BufferedVirtualIO) {
                buf.append("TraceMap write stats " + ((BufferedVirtualIO)this._traceMapio).getWriteStats() + "\n");
            }
        }
        return buf.toString();
    }

    public void close() {
        if (this._frameMapio != null) {
            try {
                this._frameMapio.close();
            }
            catch (SeisException e) {
                // empty catch block
            }
        }
        if (this._traceMapio != null) {
            try {
                this._traceMapio.close();
            }
            catch (SeisException seisException) {
                // empty catch block
            }
        }
    }

    public int setVolume(int ivol) throws SeisException {
        if (ivol < 0 || ivol >= this._parms.volumes) {
            throw new SeisException("Volume index is out of range : " + ivol + "\n");
        }
        if (ivol == this._currentVolume) {
            assert (this._logicalVolume == this._volumeMap[2 * ivol]) : "logicalVolume mismatch";
            assert (this._framesInVolume == this._volumeMap[2 * ivol + 1]) : "framesInVolume mismatch";
            return this._framesInVolume;
        }
        this._currentVolume = ivol;
        this._logicalVolume = this._volumeMap[2 * ivol];
        this._framesInVolume = this._volumeMap[2 * ivol + 1];
        if (this._framesInVolume > this._parms.framesPerVolume) {
            throw new SeisException("framesInVolume exceeds the sortmap definition of the maximum frames per volume \n frames in current volume = " + this._framesInVolume + " maximum framePerVolume=" + this._parms.framesPerVolume);
        }
        long fpos = 8 * this._parms.framesPerVolume * this._currentVolume;
        try {
            this._frameBuffer.position(0);
            this._frameBuffer.limit(8 * this._framesInVolume);
            this._frameMapio.setPosition(fpos);
            this._frameMapio.read(this._frameBuffer);
            this._frameView.position(0);
            this._frameView.get(this._frameMap, 0, 2 * this._framesInVolume);
        }
        catch (SeisException e) {
            throw new SeisException("Could not read frame maps\n" + e.getMessage());
        }
        this._currentFrame = -1;
        this._logicalFrame = Integer.MIN_VALUE;
        return this._framesInVolume;
    }

    public int findLogicalVolume(long logicalVolumeKey) {
        if (this._currentVolume != -1 && (long)this._volumeMap[this._currentVolume * 2] == logicalVolumeKey) {
            return this._currentVolume;
        }
        for (int ivol = 0; ivol < this._parms.volumes; ++ivol) {
            if (logicalVolumeKey != (long)this._volumeMap[2 * ivol]) continue;
            return ivol;
        }
        return -1;
    }

    public int findLogicalFrame(int logicalFrameKey) throws SeisException {
        if (this._currentFrame != -1 && this._frameMap[this._currentFrame * 2] == logicalFrameKey) {
            return this._currentFrame;
        }
        for (int iframe = 0; iframe < this._framesInVolume; ++iframe) {
            if (logicalFrameKey != this._frameMap[2 * iframe]) continue;
            return iframe;
        }
        return -1;
    }

    public void getFrameDetails(int iframe, int[] buf) {
        buf[0] = this._frameMap[2 * iframe];
        buf[1] = this._frameMap[2 * iframe + 1];
    }

    public int getCurrentLogicalVolume() {
        return this._logicalVolume;
    }

    public int framesInCurrentVolume() {
        return this._framesInVolume;
    }

    public int getCurrentLogicalFrame() {
        return this._logicalFrame;
    }

    public int setFrame(int ifrm) throws SeisException {
        if (ifrm < 0 || ifrm >= this._parms.framesPerVolume) {
            throw new SeisException("Frame index is out of range : " + ifrm + "\n");
        }
        if (ifrm == this._currentFrame) {
            assert (this._logicalFrame == this._frameMap[2 * ifrm]) : "logicalFrame mismatch";
            assert (this._tracesInFrame == this._frameMap[2 * ifrm + 1]) : "tracesInFrame mismatch";
            return this._tracesInFrame;
        }
        this._currentFrame = ifrm;
        this._logicalFrame = this._frameMap[2 * ifrm];
        this._tracesInFrame = this._frameMap[2 * ifrm + 1];
        if (this._tracesInFrame > this._parms.tracesPerFrame) {
            throw new SeisException("tracesInFrame out of range : " + this._tracesInFrame);
        }
        long fpos = 8L * (long)this._parms.tracesPerFrame * ((long)ifrm + (long)this._parms.framesPerVolume * (long)this._currentVolume);
        this._traceBuffer.clear();
        this._traceBuffer.limit(8 * this._tracesInFrame);
        this._traceMapio.setPosition(fpos);
        this._traceMapio.read(this._traceBuffer);
        this._traceView.position(0);
        this._traceView.get(this._traceList, 0, this._tracesInFrame);
        return this._tracesInFrame;
    }

    public long[] getCurrentTraceList() {
        return this._traceList;
    }

    public int getCurrentTracesInFrame() {
        return this._tracesInFrame;
    }

    public int getNumUniqueVolumes() {
        return this._parms.volumes;
    }

    public int getNumUniqueFramesPerVolume() {
        return this._parms.framesPerVolume;
    }

    public int getNumTracesPerFrame() {
        return this._parms.tracesPerFrame;
    }

    public String getVolumeLabel() {
        return this._parms.label4;
    }

    public String getFrameLabel() {
        return this._parms.label3;
    }

    public String getTraceLabel() {
        return this._parms.label2;
    }

    public int getTraceLogicalIncrement() {
        return this._parms.logTrcInc;
    }

    public int getTraceLogicalOrigin() {
        return this._parms.minLogTrc;
    }

    public int getTraceRange() {
        return this._parms.maxLogTrc - this._parms.minLogTrc + 1;
    }

    public int getFrameLogicalIncrement() {
        return this._parms.logFrmInc;
    }

    public int getFrameLogicalOrigin() {
        return this._parms.minLogFrm;
    }

    public int getFrameRange() {
        return this._parms.maxLogFrm - this._parms.minLogFrm + 1;
    }

    public int getVolumeLogicalOrigin() {
        return this._parms.minLogVol;
    }

    public int getVolumeLogicalIncrement() {
        return this._parms.logVolInc;
    }

    public int getVolumeRange() {
        return this._parms.maxLogVol - this._parms.minLogVol + 1;
    }

    public static boolean exists(String path, String name) {
        File f = new File(SortIOParms.makePropertiesFileName(path, name));
        return f.exists();
    }

    public static String[] list(String path) {
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return new String[0];
        }
        File[] flist = dir.listFiles(new SortNameFilter());
        ArrayList<String> sortNames = new ArrayList<String>();
        if (flist != null) {
            for (File f : flist) {
                String name = f.getName();
                if (name.endsWith(".xml")) {
                    name = name.substring(0, name.length() - 4);
                }
                String ext = name.substring(name.lastIndexOf(46) + 1);
                sortNames.add(ext);
            }
        }
        return sortNames.toArray(new String[0]);
    }

    public String[] getFrameSortParms() {
        String[] parms = new String[]{this._parms.sort3_secondary, this._parms.sort3_tertiary};
        return parms;
    }

    public static boolean delete(String basePath, String sortmapName) {
        File f = new File(SortIOParms.makePropertiesFileName(basePath, sortmapName));
        if (!f.exists()) {
            return false;
        }
        boolean test = f.delete();
        if (!test) {
            return false;
        }
        boolean ok = true;
        f = new File(basePath + File.separatorChar + "SortVolumeMap" + "." + sortmapName);
        if (f.exists()) {
            ok = f.delete();
        }
        if ((f = new File(basePath + File.separatorChar + "SortFrameMap" + "." + sortmapName)).exists()) {
            ok = f.delete();
        }
        if ((f = new File(basePath + File.separatorChar + "SortTraceMap" + "." + sortmapName)).exists()) {
            ok = f.delete();
        }
        return ok;
    }

    public static boolean delete(String path) {
        String[] list = SortMapIO.list(path);
        if (list == null) {
            return false;
        }
        boolean ok = true;
        for (String name : list) {
            if (SortMapIO.delete(path, name)) continue;
            ok = false;
        }
        return ok;
    }

    public void writeVolumeMap(int nvol, int ivol) throws SeisException {
        LOG.fine("writeVolumeMap - nvol: " + nvol + ", ivol: " + ivol);
        if (nvol == 0) {
            return;
        }
        this._volumeView.position(0);
        this._volumeBuffer.clear();
        int nbytes = nvol * 8;
        this._volumeBuffer.limit(nbytes);
        this._volumeMapio.setPosition(8L * (long)ivol);
        int nbytesWritten = this._volumeMapio.write(this._volumeBuffer);
        if (nbytesWritten != nbytes) {
            throw new SeisException("SortCreate.writeVolumeMap wrote " + nbytesWritten + " when " + nbytes + " were expected");
        }
    }

    public void appendVolume(int ivolume, int volumeKey, int nframes) {
        if (ivolume == 0) {
            this._volumeBuffer.position(0);
            this._volumeView.position(0);
        }
        this._volumeView.put(volumeKey);
        this._volumeView.put(nframes);
    }

    public void writeFrameMap(int nfrm, int ivol) throws SeisException {
        this.writeFrameMap(0, nfrm, ivol);
    }

    public void writeFrameMap(int ifrm, int nfrm, int ivol) throws SeisException {
        this._frameView.position(0);
        this._frameBuffer.clear();
        int nbytes = nfrm * 8;
        this._frameBuffer.limit(nbytes);
        long fpos = 8L * (long)this._parms.framesPerVolume * (long)ivol + 8L * (long)ifrm;
        this._frameMapio.setPosition(fpos);
        int nbytesWritten = this._frameMapio.write(this._frameBuffer);
        if (nbytesWritten != nbytes) {
            throw new SeisException("SortCreate.writeFrameMap wrote " + nbytesWritten + " when " + nbytes + " were expected");
        }
    }

    public void appendFrame(int ifrm, int frameKey, int ntraces) {
        if (ifrm == 0) {
            this._frameBuffer.position(0);
            this._frameView.position(0);
        }
        this._frameView.put(frameKey);
        this._frameView.put(ntraces);
    }

    public void writeTraceMap(int ntrc, int ivol, int ifrm) throws SeisException {
        if (ntrc < this._traceList.length) {
            Arrays.fill(this._traceList, ntrc, this._traceList.length - 1, -1L);
        }
        this._traceView.position(0);
        this._traceView.put(this._traceList, 0, this._traceList.length);
        this._traceBuffer.clear();
        this._traceBuffer.limit(8 * this._traceList.length);
        long fpos = 8L * (long)this._parms.tracesPerFrame * ((long)ifrm + (long)this._parms.framesPerVolume * (long)ivol);
        this._traceMapio.setPosition(fpos);
        this._traceMapio.write(this._traceBuffer);
    }

    public static void writeparms(String basePath, String sortmapName, SortIOParms parms) throws IOException {
        SortIOParms.writeparms(basePath, sortmapName, parms);
    }
}

