/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.compress;

public enum DataCompression {
    NONE("NONE", "No commpression", 0),
    INT16("INT16", "Compress to 16-bit Integer", 2),
    INT08("INT08", "Compress to 08-bit Integer", 1);

    protected String _name;
    protected String _description;
    protected int _bytesPerSample;

    private DataCompression(String name, String description, int bytesPerSample) {
        this._name = new String(name);
        this._description = new String(description);
        this._bytesPerSample = bytesPerSample;
    }

    public static DataCompression get(String name) {
        if (name == null) {
            return null;
        }
        for (DataCompression dataCompression : DataCompression.values()) {
            if (!dataCompression.toString().equals(name)) continue;
            return dataCompression;
        }
        return null;
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public int getBytesPerSample() {
        return this._bytesPerSample;
    }
}

