/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.certicom.ecc.jcae.Certicom;
import com.certicom.ecc.scheme.ECDSA;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.Conversion;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.security.spec.ECParameterSpec;
import javax.security.spec.ECRawPublicKeySpec;
import javax.security.spec.F2mParameterSpec;

public class PriKey
implements FlexlmConstants {
    static final String CVSId = "$Id";
    protected static String certicomName;
    protected static final String signatureAlgorithmName = "ECDSA";

    public static boolean pubkeyVerify(byte[] byArray, byte[] byArray2, VendorInfo vendorInfo, int n) throws FlexlmException {
        boolean bl;
        System.setProperty("JDK_1_3_Compatibility", "YES");
        String string = PriKey.initCerticom();
        if (string == null) {
            throw new FlexlmException(-514, 4026);
        }
        SystemConfig systemConfig = SystemConfig.getConfig();
        systemConfig.setConformance(16);
        systemConfig.setPtCompression(2);
        systemConfig.setFormat(10);
        switch (n) {
            case 2: {
                break;
            }
            case 3: {
                systemConfig.setCurve("sect163k1");
                break;
            }
            case 4: {
                systemConfig.setCurve("sect239k1");
                break;
            }
            default: {
                throw new FlexlmException(-515, 4027);
            }
        }
        PublicKey publicKey = vendorInfo.getPublicKey(n);
        if (publicKey == null) {
            throw new FlexlmException(-515, 4028);
        }
        byte[] byArray3 = publicKey.getEncoded();
        PublicKey publicKey2 = null;
        ECRawPublicKeySpec eCRawPublicKeySpec = null;
        X509EncodedKeySpec x509EncodedKeySpec = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(signatureAlgorithmName);
            if (n == 2) {
                ECDSA.setThreadOldHashTruncate((boolean)true);
                int[] nArray = new int[]{9};
                String string2 = "1.3.132.0.4";
                F2mParameterSpec f2mParameterSpec = new F2mParameterSpec(Conversion.HexString2OS((String)"3088250ca6e7c7fe649ce85820f7"), Conversion.HexString2OS((String)"e8bee4d3e2260744188be0e9c723"), Conversion.HexString2OS((String)"10e723ab14d696e6768756151756febf8fcb49a9"), Conversion.HexString2OS((String)"9d73616f35f4ab1407d73562c10f"), Conversion.HexString2OS((String)"a52830277958ee84d1315ed31886"), Conversion.HexString2OS((String)"100000000000000d9ccec8a39e56f"), 2, 113, nArray, string2);
                eCRawPublicKeySpec = new ECRawPublicKeySpec(byArray3, (ECParameterSpec)f2mParameterSpec);
                publicKey2 = keyFactory.generatePublic((KeySpec)eCRawPublicKeySpec);
            } else {
                x509EncodedKeySpec = new X509EncodedKeySpec(byArray3);
                publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            }
            Signature signature = Signature.getInstance(signatureAlgorithmName, string);
            signature.initVerify(publicKey2);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FlexlmException(-515, 4029);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new FlexlmException(-515, 4030);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new FlexlmException(-515, 4031);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new FlexlmException(-515, 4032);
        }
        catch (SignatureException signatureException) {
            throw new FlexlmException(-515, 4033);
        }
        finally {
            Security.removeProvider(certicomName);
            certicomName = null;
        }
        return bl;
    }

    protected static String initCerticom() {
        if (certicomName != null) {
            return certicomName;
        }
        Certicom certicom = new Certicom();
        if (Security.addProvider((Provider)certicom) < 0) {
            // empty if block
        }
        certicomName = certicom.getName();
        return certicomName;
    }

    public static void printBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(Integer.toString(byArray[i] & 0xFF, 16));
            System.out.print(" ");
        }
    }

    public static void printBytes(String string, byte[] byArray) {
        System.out.print(string + " = { ");
        PriKey.printBytes(byArray);
        System.out.println(" }");
    }
}

