/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.hostid.SimpleHostId;

public abstract class IntelHostId
extends SimpleHostId {
    int[] intelHostid;

    public IntelHostId(String string) throws FlexlmException {
        super(string);
    }

    @Override
    protected void initHostId(String string) throws FlexlmException {
        this.initHostIdValue(string);
    }

    @Override
    protected void initHostIdValue(String string) throws FlexlmException {
        int n;
        int n2 = this.getGroupCount();
        this.intelHostid = new int[n2 / 2];
        if (string.length() != n2 * 5 - 1) {
            throw new FlexlmException(-503, 2021);
        }
        int[] nArray = new int[n2];
        String string2 = string;
        for (n = 0; n < n2; ++n) {
            String string3;
            if (n < n2 - 1) {
                if (string2.charAt(4) != '-') {
                    throw new FlexlmException(-503, 2022);
                }
                string3 = string2.substring(0, 4);
                string2 = string2.substring(5);
            } else {
                string3 = string2;
            }
            nArray[n] = this.parseHexPiece(string3);
            if (nArray[n] >= 0 && nArray[n] < 65536) continue;
            throw new FlexlmException(-503, 2024);
        }
        n = n2 / 2;
        for (int i = 0; i < n; ++i) {
            this.intelHostid[n - i - 1] = nArray[2 * i] << 16 | nArray[2 * i + 1];
        }
    }

    protected int parseHexPiece(String string) throws FlexlmException {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmException(-503, 2023);
        }
    }

    protected abstract int getGroupCount();

    @Override
    public String getKeyword() {
        return null;
    }

    @Override
    public int getCryptCode() {
        return 0;
    }

    @Override
    public Object getValue() {
        return this.intelHostid;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.intelHostid.length - 1; i >= 0; --i) {
            int n = this.intelHostid[i] >> 16 & 0xFFFF;
            int n2 = this.intelHostid[i] & 0xFFFF;
            if (n < 16) {
                stringBuffer.append("000");
            } else if (n < 256) {
                stringBuffer.append("00");
            } else if (n < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n, 16));
            stringBuffer.append("-");
            if (n2 < 16) {
                stringBuffer.append("000");
            } else if (n2 < 256) {
                stringBuffer.append("00");
            } else if (n2 < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n2, 16));
            if (i <= 0) continue;
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    @Override
    protected int compareValueTo(Object object) {
        int[] nArray = (int[])object;
        int n = this.intelHostid.length - nArray.length;
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.intelHostid.length; ++i) {
            long l = (long)this.intelHostid[i] & 0xFFFFFFFFL;
            long l2 = (long)nArray[i] & 0xFFFFFFFFL;
            long l3 = l - l2;
            if (l3 < 0L) {
                return -1;
            }
            if (l3 <= 0L) continue;
            return 1;
        }
        return 0;
    }
}

