/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECCurve;
import com.certicom.ecc.FF;
import com.certicom.ecc.FFFactory;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.provider.EccPoint;
import com.certicom.ecc.provider.F2mPoint;
import com.certicom.ecc.provider.FpPoint;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.F2mParameterSpec;
import com.certicom.ecc.spec.FpParameterSpec;
import com.certicom.ecc.spec.PointSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class ECKeyFactory
extends ECTransform
implements Serializable {
    private static final long serialVersionUID = 5605591590292370033L;
    private ECParams a;
    private boolean b;
    private static final Class c;
    private static final Class d;

    public ECKeyFactory() {
        super("ECKeyFactory");
    }

    public void reset() {
        super.reset();
        this.a = null;
        this.b = false;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n2, objectArray, random);
        if (n2 == 5 && objectArray != null && objectArray.length == 2) {
            bl = true;
            if (objectArray[0].equals(c)) {
                this.b = true;
            } else if (!objectArray[0].equals(d)) {
                bl = false;
            }
            if (objectArray[1] instanceof ECParams) {
                this.a = (ECParams)objectArray[1];
            } else {
                bl = false;
            }
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
    }

    public boolean isIncremental() {
        return false;
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.h != 5) {
            throw new IllegalStateException("wrong mode");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        if (this.b) {
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(this.a(), this.b(), this.a, byArray, n2, n3);
            return eCPublicKeySpec;
        }
        return new ECPrivateKeySpec(this.a(), this.a, byArray, n2, n3);
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        if (object instanceof ECPublicKeySpec) {
            try {
                ECKeyFactory.a((ECPublicKeySpec)object);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    static void a(ECPublicKeySpec eCPublicKeySpec) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        byte[] byArray;
        ECParams eCParams = eCPublicKeySpec.getECParams();
        PointParams pointParams = eCParams.getPoint();
        if (!(pointParams instanceof PointSpec)) {
            throw new IllegalStateException("params is invalid");
        }
        FFFactory fFFactory = ((PointSpec)pointParams).getFactory();
        boolean bl = false;
        BigInteger bigInteger = null;
        if (eCParams instanceof FpParameterSpec) {
            byArray = ((FpParams)eCParams).getPrime();
            bigInteger = new BigInteger(1, byArray);
            bl = true;
        } else if (eCParams instanceof F2mParameterSpec) {
            bl = false;
        } else {
            throw new IllegalStateException("curve is invalid");
        }
        byArray = eCPublicKeySpec.getX();
        byte[] byArray2 = eCPublicKeySpec.getY();
        FF fF = fFFactory.a(byArray);
        FF fF2 = fFFactory.a(byArray2);
        FF fF3 = fFFactory.a(eCParams.getA());
        FF fF4 = fFFactory.a(eCParams.getB());
        if (fF.equals(fF.d())) {
            throw new IllegalStateException("Public Key Validation is not passed: infinity check");
        }
        BigInteger bigInteger2 = fF.g();
        BigInteger bigInteger3 = fF2.g();
        BigInteger bigInteger4 = BigInteger.ZERO;
        if (bl) {
            if (bigInteger2.compareTo(bigInteger4) < 0 || bigInteger2.compareTo(bigInteger) >= 0 || bigInteger3.compareTo(bigInteger4) < 0 || bigInteger3.compareTo(bigInteger) >= 0) {
                throw new IllegalStateException("Public Key Validation is not passed: wrong Xq, Yq intervals");
            }
        } else {
            int n2 = (eCParams.getSize() + 7) / 8;
            if (byArray.length != n2 || byArray2.length != n2) {
                throw new IllegalStateException("Public Key Validation is not passed: wrong X, Y size");
            }
        }
        FF fF5 = fF2.b();
        FF fF6 = fF.b().c(fF);
        if (bl) {
            serializable3 = fF3.c(fF);
            serializable2 = fF4.a(bigInteger);
            if (!fF5.equals(fF6.a((FF)serializable3).a((FF)serializable2))) {
                throw new IllegalStateException("Public Key Validation is not passed: the public key is not on the elliptic correct curve");
            }
        } else {
            serializable3 = fF.c(fF2);
            serializable2 = fF.b();
            serializable = fF3.c((FF)serializable2);
            if (!fF5.a((FF)serializable3).equals(fF6.a((FF)serializable).a(fF4))) {
                throw new IllegalStateException("Public Key Validation is not passed: the public key is not on the elliptic correct curve");
            }
        }
        serializable3 = null;
        serializable2 = new ECCurve(fF3, fF4, null);
        serializable3 = bl ? new FpPoint(fF, fF2, (ECCurve)serializable2) : new F2mPoint(fF, fF2, (ECCurve)serializable2);
        ECA eCA = ((EccPoint)serializable3).a((BigInteger)(serializable = new BigInteger(1, eCParams.getPointOrder())));
        if (!eCA.e().equals(fF.d()) || !eCA.f().equals(fF2.d())) {
            throw new IllegalStateException("Public Key Validation is not passed: incorrect order");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(new Boolean(this.b));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (ECParams)objectInputStream.readObject();
        this.b = (Boolean)objectInputStream.readObject();
    }

    static {
        try {
            c = Class.forName("com.certicom.ecc.interfaces.ECPublicKey");
            d = Class.forName("com.certicom.ecc.interfaces.ECPrivateKey");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }
}

