#include <jni.h>

extern int jsutilfile_set_o_direct (int fd, char *filename, int set);
extern int jsutilfile_o_direct_is_set (int fd, char *filename);
extern long long jsutilfile_diskCapacityBytes (const char* dir);
extern int jsutilfile_set_sparse (const char *filename);

static int get_fd (JNIEnv *env, jobject fdobj);
static const char *alloc_string (JNIEnv *env, jstring string, jboolean *iscopy);
static void free_string (JNIEnv *env, jstring string, const char *loc_string);

JNIEXPORT jint JNICALL Java_org_javaseis_io_JSUtilFile_nSetODirect
  (JNIEnv *env, jclass sclass, jobject fdobj, jstring fnstring, jint iset)
{
  jboolean iscopy;
  int fd = get_fd (env, fdobj);
  const char *filename = alloc_string (env, fnstring, &iscopy);
  jint retval;

  if (iset != 0) {
    retval = jsutilfile_set_o_direct (fd, (char *)filename, 1);
  }
  else {
    retval = jsutilfile_set_o_direct (fd, (char *)filename, 0);
  }
  if(iscopy == JNI_TRUE) free_string (env, fnstring, filename);
  return retval;
}

JNIEXPORT jboolean JNICALL Java_org_javaseis_io_JSUtilFile_nODirectIsSet
  (JNIEnv *env, jclass sclass, jobject fdobj, jstring fnstring)
{
  jboolean iscopy;
  int fd = get_fd (env, fdobj);
  const char *filename = alloc_string (env, fnstring, &iscopy);
  jboolean retval;

  retval = (jboolean)jsutilfile_o_direct_is_set (fd, (char *)filename) != 0;

  if(iscopy == JNI_TRUE) free_string (env, fnstring, filename);
  return retval;
}

JNIEXPORT jboolean JNICALL Java_org_javaseis_io_JSUtilFile_nSetSparse
  (JNIEnv *env, jclass sclass, jstring fnstring)
{
  jboolean iscopy;
  const char *filename = alloc_string (env, fnstring,&iscopy);
  jboolean retval;

  retval = (jboolean) jsutilfile_set_sparse(filename);

  if(iscopy == JNI_TRUE) free_string (env, fnstring, filename);
  return retval;
}

/*
 * Class:     org_javaseis_io_JSUtilFile
 * Method:    nDiskCapacityBytes
 * Signature: (Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_org_javaseis_io_JSUtilFile_nDiskCapacityBytes
(JNIEnv *env, jclass sclass, jstring dir) {
  jboolean iscopy;
  const char *cdir = alloc_string (env, dir, &iscopy);
  jlong retval;

  retval = (jlong)jsutilfile_diskCapacityBytes(cdir);

  if(iscopy == JNI_TRUE) free_string (env, dir, cdir);
  return retval;
}


int get_fd (JNIEnv *env, jobject fdobj)
{
  /* do a lot of work to get the unix int fd needed for C */
  jclass fdclass = (*env)->GetObjectClass (env, fdobj);
  /* UGLY: as of today the fd field is a private int in java that is accessible in C */
  jfieldID fdid = (*env)->GetFieldID (env, fdclass, "fd", "I");
  int retval = (*env)->GetIntField (env, fdobj, fdid);
  return retval;
}

const char *alloc_string (JNIEnv *env, jstring string, jboolean *iscopy)
{
  const char *retval = (*env)->GetStringUTFChars (env, string, iscopy);
  return retval;
}

void free_string (JNIEnv *env, jstring string, const char *loc_string)
{
  (*env)->ReleaseStringUTFChars (env, string, loc_string);
}
