/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.seiszip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import org.javaseis.seiszip.HdrCompressor;
import org.javaseis.seiszip.SeisPEG;

public class SegyUnzip {
    private static final Logger LOG = Logger.getLogger("org.javaseis.seiszip");
    private String _inFile = null;
    private String _outFile = null;
    private FileInputStream _inputStream;
    private FileOutputStream _outputStream;
    private FileChannel _inputChannel;
    private FileChannel _outputChannel;
    private long _nbytesRead = 0L;
    private long _inputStreamOffset = 0L;
    private long _nbytesWritten = 0L;
    private SeisPEG _seisPEG;
    private int _nbytesPerTrace;
    private int _nbytesPerTraceOut;
    private float[][] _traces = null;
    private int[][] _hdrs = null;
    private byte[] _compressedHdrBytes = null;
    private byte[] _compressedTrcBytes = null;
    private ByteBuffer _compressedHdrByteBuffer = null;
    private ByteBuffer _compressedTrcByteBuffer = null;
    private ByteBuffer _twoWords = null;
    private ByteBuffer _hdrByteBuffer = null;
    private ByteBuffer _trcByteBuffer = null;
    private IntBuffer _hdrBuffer = null;
    private FloatBuffer _trcBuffer = null;
    private int _tracesPerFrameLast = -1;
    private int _samplesPerTraceLast = -1;
    private int _fileCount = 0;
    private String[] _inputFileList;
    private File _inputDir;
    private File _outputDir;
    private String _volumeName;
    private String _segyExtension;
    private String _seispegExtension;
    private long _minVolume = Long.MIN_VALUE;
    private long _maxVolume = Long.MAX_VALUE;
    private long _volumeInc = 1L;
    private long _minFrame = Long.MIN_VALUE;
    private long _maxFrame = Long.MAX_VALUE;
    private long _frameInc = 1L;
    private long _minTrace = Long.MIN_VALUE;
    private long _maxTrace = Long.MAX_VALUE;
    private long _traceInc = 1L;
    private long _maxSample = Long.MAX_VALUE;
    private boolean _ignoreErrors = false;

    public SegyUnzip(String inFile, String outFile) throws IOException {
        this.initializeFile(inFile, outFile);
    }

    public SegyUnzip(String inputDir, String outputDir, String volumeName, String segyExtension, String seispegExtension, long minVolume, long maxVolume, long volumeInc, long minFrame, long maxFrame, long frameInc, long minTrace, long maxTrace, long traceInc, long maxSample, boolean ignoreErrors) {
        if (inputDir == null) {
            throw new IllegalArgumentException("Input directory is null");
        }
        this._inputDir = new File(inputDir);
        if (!this._inputDir.exists()) {
            throw new IllegalArgumentException("Input directory '" + inputDir + "' does not exist");
        }
        if (!this._inputDir.isDirectory()) {
            throw new IllegalArgumentException("Input directory '" + inputDir + "' is not actually a directory");
        }
        this._inputFileList = this._inputDir.list();
        if (this._inputFileList == null || this._inputFileList.length == 0) {
            throw new IllegalArgumentException("Input directory '" + inputDir + "' is empty");
        }
        Arrays.sort(this._inputFileList);
        if (outputDir == null) {
            throw new IllegalArgumentException("Output directory is null");
        }
        this._outputDir = new File(outputDir);
        if (this._outputDir.exists()) {
            if (!this._outputDir.isDirectory()) {
                throw new IllegalArgumentException("Output directory '" + outputDir + "' is not actually a directory");
            }
        } else {
            boolean success = this._outputDir.mkdirs();
            if (!success) {
                throw new IllegalArgumentException("Unable to create output directory " + outputDir);
            }
        }
        if (volumeName == null) {
            volumeName = "SOURCE_";
        }
        if (segyExtension == null) {
            segyExtension = ".sgy";
        }
        if (seispegExtension == null) {
            seispegExtension = ".syz";
        }
        this._volumeName = volumeName;
        this._segyExtension = segyExtension;
        this._seispegExtension = seispegExtension;
        if (minVolume > maxVolume) {
            throw new IllegalArgumentException("minVolume > maxVolume");
        }
        if (volumeInc < 1L) {
            throw new IllegalArgumentException("volumeInc < 1");
        }
        if (minFrame > maxFrame) {
            throw new IllegalArgumentException("minFrame > maxFrame");
        }
        if (frameInc < 1L) {
            throw new IllegalArgumentException("frameInc < 1");
        }
        if (minTrace > maxTrace) {
            throw new IllegalArgumentException("minTrace > maxTrace");
        }
        if (traceInc < 1L) {
            throw new IllegalArgumentException("traceInc < 1");
        }
        this._minVolume = minVolume;
        this._maxVolume = maxVolume;
        this._volumeInc = volumeInc;
        this._minFrame = minFrame;
        this._maxFrame = maxFrame;
        this._frameInc = frameInc;
        this._minTrace = minTrace;
        this._maxTrace = maxTrace;
        this._traceInc = traceInc;
        this._maxSample = maxSample;
        this._ignoreErrors = ignoreErrors;
    }

    private void initializeFile(String inFile, String outFile) throws IOException {
        int nsamplesOutput;
        this._nbytesRead = 0L;
        this._inputStreamOffset = 0L;
        this._nbytesWritten = 0L;
        this._inFile = inFile;
        this._outFile = outFile;
        this._inputStream = new FileInputStream(inFile);
        this._inputChannel = this._inputStream.getChannel();
        this._outputStream = new FileOutputStream(outFile);
        this._outputChannel = this._outputStream.getChannel();
        if (this._twoWords == null) {
            this._twoWords = ByteBuffer.allocate(8);
            this._twoWords.order(ByteOrder.BIG_ENDIAN);
        }
        this._twoWords.position(0);
        int nRead = this._inputChannel.read(this._twoWords);
        this._nbytesRead += (long)nRead;
        this._inputStreamOffset += (long)nRead;
        if (nRead != 8) {
            throw new IOException("For file '" + this._inFile + "' - Error reading file header: " + nRead + "!=8");
        }
        int cookie = this._twoWords.getInt(0);
        if (cookie != 35478349) {
            throw new RuntimeException("For file '" + this._inFile + "' - Sorry - you are trying to unzip data from an invalid or corrupted file " + "(contact Dave.Diller@weinmangeoscience.com if this is unacceptable) " + cookie + " " + 35478349);
        }
        ByteBuffer reelHdrBuffer = ByteBuffer.allocate(3200);
        nRead = this._inputChannel.read(reelHdrBuffer);
        this._nbytesRead += (long)nRead;
        this._inputStreamOffset += (long)nRead;
        if (nRead != 3200) {
            throw new IOException("For file '" + this._inFile + "' - Error reading SEG-Y reel header: " + nRead + "!=" + 3200);
        }
        reelHdrBuffer.position(0);
        int nWritten = this._outputChannel.write(reelHdrBuffer);
        this._nbytesWritten += (long)nWritten;
        if (nWritten != 3200) {
            throw new IOException("For file '" + this._outFile + "' - Error writing SEG-Y reel header: " + nWritten + "!=" + 3200);
        }
        ByteBuffer binaryHdrBuffer = ByteBuffer.allocate(400);
        nRead = this._inputChannel.read(binaryHdrBuffer);
        this._nbytesRead += (long)nRead;
        this._inputStreamOffset += (long)nRead;
        if (nRead != 400) {
            throw new IOException("For file '" + this._inFile + "' - Error reading SEG-Y binary header: " + nRead + "!=" + 400);
        }
        binaryHdrBuffer.order(ByteOrder.BIG_ENDIAN);
        short tracesPerFrame = binaryHdrBuffer.getShort(12);
        float sampleInterval = (float)binaryHdrBuffer.getShort(16) / 1000.0f;
        int samplesPerTrace = binaryHdrBuffer.getShort(20);
        this._nbytesPerTrace = samplesPerTrace * 4;
        System.out.println("For file '" + this._inFile + "' ...");
        if (this._fileCount == 0) {
            System.out.println("  tracesPerFrame= " + tracesPerFrame);
            System.out.println("  sampleInterval= " + sampleInterval);
            System.out.println("  samplesPerTrace= " + samplesPerTrace);
        }
        ++this._fileCount;
        if (this._maxSample < (long)samplesPerTrace) {
            nsamplesOutput = (int)this._maxSample;
            binaryHdrBuffer.putShort(20, (short)nsamplesOutput);
        } else {
            nsamplesOutput = samplesPerTrace;
        }
        this._nbytesPerTraceOut = nsamplesOutput * 4;
        binaryHdrBuffer.position(0);
        nWritten = this._outputChannel.write(binaryHdrBuffer);
        this._nbytesWritten += (long)nWritten;
        if (nWritten != 400) {
            throw new IOException("For file '" + this._outFile + "' - Error writing SEG-Y binary header: " + nWritten + "!=" + 400);
        }
        if (this._traces == null || this._traces.length != tracesPerFrame || this._traces[0].length != samplesPerTrace) {
            this._traces = new float[tracesPerFrame][samplesPerTrace];
        }
        if (this._hdrs == null || this._hdrs.length != tracesPerFrame || this._hdrs[0].length != 60) {
            this._hdrs = new int[tracesPerFrame][60];
        }
        if (this._compressedHdrBytes == null || this._tracesPerFrameLast != tracesPerFrame) {
            this._compressedHdrBytes = new byte[HdrCompressor.getOutputBufferSize(60, tracesPerFrame)];
            this._compressedHdrByteBuffer = ByteBuffer.wrap(this._compressedHdrBytes);
        }
        if (this._compressedTrcBytes == null || this._tracesPerFrameLast != tracesPerFrame || this._samplesPerTraceLast != samplesPerTrace) {
            this._compressedTrcBytes = new byte[samplesPerTrace * tracesPerFrame * 4];
            this._compressedTrcByteBuffer = ByteBuffer.wrap(this._compressedTrcBytes);
        }
        this._samplesPerTraceLast = samplesPerTrace;
        this._tracesPerFrameLast = tracesPerFrame;
    }

    private String inputFileIsInRange(String inputFile) throws IOException {
        long volumeNumber;
        if (!inputFile.startsWith(this._volumeName)) {
            return null;
        }
        String s = inputFile.substring(this._volumeName.length(), inputFile.length());
        int index = s.indexOf(this._seispegExtension);
        if (index < 1) {
            return null;
        }
        if ((index = (s = s.substring(0, index)).indexOf(this._segyExtension)) < 1) {
            return null;
        }
        s = s.substring(0, index);
        File file = new File(this._inputDir, inputFile);
        if (!file.exists()) {
            throw new IOException("Input file '" + file.getAbsolutePath() + "' does not exist");
        }
        try {
            volumeNumber = Long.parseLong(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to parse volume number for input file '" + file.getAbsolutePath() + "'");
        }
        if (volumeNumber < this._minVolume) {
            return null;
        }
        if (volumeNumber > this._maxVolume) {
            return null;
        }
        if (this._minVolume == Long.MIN_VALUE ? volumeNumber % this._volumeInc != 0L : (volumeNumber - this._minVolume) % this._volumeInc != 0L) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private String getOutputFile(String inputFile) throws IOException {
        int index = inputFile.indexOf(this._seispegExtension);
        if (index < 1) {
            throw new IOException("SeisPEG extension '" + this._seispegExtension + "' is missing from input file '" + new File(this._inputDir, inputFile).getAbsolutePath() + "'");
        }
        String outputFile = inputFile.substring(0, index);
        return new File(this._outputDir, outputFile).getAbsolutePath();
    }

    public void unzipAllFiles() throws IOException {
        for (int j = 0; j < this._inputFileList.length; ++j) {
            try {
                String inFile = this.inputFileIsInRange(this._inputFileList[j]);
                if (inFile == null) continue;
                String outFile = this.getOutputFile(this._inputFileList[j]);
                this.initializeFile(inFile, outFile);
                this.unzipFile();
                continue;
            }
            catch (IOException e) {
                if (this._ignoreErrors) {
                    e.printStackTrace();
                    continue;
                }
                throw e;
            }
        }
    }

    public void unzipFile() throws IOException {
        if (this._hdrByteBuffer == null) {
            this._hdrByteBuffer = ByteBuffer.allocateDirect(240);
            this._hdrByteBuffer.order(ByteOrder.BIG_ENDIAN);
            this._hdrBuffer = this._hdrByteBuffer.asIntBuffer();
        }
        if (this._trcByteBuffer == null) {
            this._trcByteBuffer = ByteBuffer.allocateDirect(this._nbytesPerTrace);
            this._trcByteBuffer.order(ByteOrder.BIG_ENDIAN);
            this._trcBuffer = this._trcByteBuffer.asFloatBuffer();
        }
        long inputTraceCount = 1L;
        long outputTraceCount = 1L;
        long frameCounter = 1L;
        while (true) {
            boolean readThisFrame = true;
            if (frameCounter < this._minFrame) {
                readThisFrame = false;
            }
            if (frameCounter > this._maxFrame) {
                readThisFrame = false;
            }
            if (this._minFrame == Long.MIN_VALUE) {
                if (frameCounter % this._frameInc != 0L) {
                    readThisFrame = false;
                }
            } else if ((frameCounter - this._minFrame) % this._frameInc != 0L) {
                readThisFrame = false;
            }
            this._twoWords.position(0);
            int nRead = this._inputChannel.read(this._twoWords);
            this._nbytesRead += (long)nRead;
            this._inputStreamOffset += (long)nRead;
            if (nRead == -1) {
                this._inputStream.close();
                this._outputStream.close();
                System.out.println("  Data expansion ratio= " + this.getUncompressionRatio());
                return;
            }
            if (nRead != 8) {
                throw new IOException("For file '" + this._inFile + "' - Error reading mini header near trace " + inputTraceCount + ": " + nRead + "!=8");
            }
            int nbytesHdrs = this._twoWords.getInt(0);
            int nbytesTraces = this._twoWords.getInt(4);
            if (!readThisFrame) {
                this._inputStreamOffset += (long)(nbytesHdrs + nbytesTraces);
                this._inputChannel.position(this._inputStreamOffset);
            } else {
                this._compressedHdrByteBuffer.position(0);
                this._compressedHdrByteBuffer.limit(nbytesHdrs);
                nRead = this._inputChannel.read(this._compressedHdrByteBuffer);
                this._nbytesRead += (long)nRead;
                this._inputStreamOffset += (long)nRead;
                if (nRead != nbytesHdrs) {
                    throw new IOException("For file '" + this._inFile + "' - Error reading compressed headers near trace " + inputTraceCount + ": " + nRead + "!=" + nbytesHdrs);
                }
                this._compressedTrcByteBuffer.position(0);
                this._compressedTrcByteBuffer.limit(nbytesTraces);
                nRead = this._inputChannel.read(this._compressedTrcByteBuffer);
                this._nbytesRead += (long)nRead;
                this._inputStreamOffset += (long)nRead;
                if (nRead != nbytesTraces) {
                    throw new IOException("For file '" + this._inFile + "' - Error reading compressed data near trace " + inputTraceCount + ": " + nRead + "!=" + nbytesTraces);
                }
                if (this._seisPEG == null) {
                    this._seisPEG = new SeisPEG(this._compressedTrcBytes);
                }
                int tracesInFrame = 0;
                try {
                    tracesInFrame = this._seisPEG.uncompressHdrs(this._compressedHdrBytes, nbytesHdrs, this._hdrs);
                }
                catch (DataFormatException e) {
                    throw new IOException(e.toString());
                }
                this._seisPEG.uncompress(this._compressedTrcBytes, nbytesTraces, this._traces);
                for (int j = 0; j < tracesInFrame; ++j) {
                    int traceCounter = j + 1;
                    boolean writeThisTrace = true;
                    if ((long)traceCounter < this._minTrace) {
                        writeThisTrace = false;
                    }
                    if ((long)traceCounter > this._maxTrace) {
                        writeThisTrace = false;
                    }
                    if (this._minTrace == Long.MIN_VALUE) {
                        if ((long)traceCounter % this._traceInc != 0L) {
                            writeThisTrace = false;
                        }
                    } else if (((long)traceCounter - this._minTrace) % this._traceInc != 0L) {
                        writeThisTrace = false;
                    }
                    if (writeThisTrace) {
                        this._hdrBuffer.position(0);
                        this._hdrBuffer.put(this._hdrs[j]);
                        this._trcBuffer.position(0);
                        this._trcBuffer.put(this._traces[j]);
                        this._hdrByteBuffer.position(0);
                        int nWritten = this._outputChannel.write(this._hdrByteBuffer);
                        this._nbytesWritten += (long)nWritten;
                        if (nWritten != 240) {
                            throw new IOException("For file '" + this._outFile + "' - Error writing SEG-Y trace header " + outputTraceCount + ": " + nWritten + "!=" + 240);
                        }
                        this._trcByteBuffer.position(0);
                        this._trcByteBuffer.limit(this._nbytesPerTraceOut);
                        nWritten = this._outputChannel.write(this._trcByteBuffer);
                        this._nbytesWritten += (long)nWritten;
                        if (nWritten != this._nbytesPerTraceOut) {
                            throw new IOException("For file '" + this._outFile + "' - Error writing SEG-Y trace " + outputTraceCount + ": " + nWritten + "!=" + this._nbytesPerTraceOut);
                        }
                    } else {
                        this._nbytesWritten += (long)(240 + this._nbytesPerTraceOut);
                    }
                    ++inputTraceCount;
                    ++outputTraceCount;
                }
                if (frameCounter % 250L == 0L) {
                    System.out.println("  Finished uncompressing and writing frame " + frameCounter + " ...");
                }
            }
            ++frameCounter;
        }
    }

    public double getUncompressionRatio() {
        return (double)this._nbytesWritten / (double)this._nbytesRead;
    }

    public static void main(String[] args) {
        boolean historicUsage = true;
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].indexOf("=");
            if (index <= 0) continue;
            historicUsage = false;
        }
        if (historicUsage) {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage: java SegyUnzip zippedInputFile segyOutputFile \n  or\njava SegyUnzip inputDir=some_directory outputDir=some_directory [volumeName=SOURCE_] [segyExtension=.sgy] [seispegExtension=.syz] [minVolume=first_available] [maxVolume=last_available] [volumeInc=1] [minFrame=1] [maxFrame=last_available] [frameInc=1] [minTrace=1] [maxTrace=last_available] [traceInc=1] [maxSample=last_available] [ignoreErrors=false]");
            }
            try {
                String inFile = args[0];
                String outFile = args[1];
                SegyUnzip segyUnzip = new SegyUnzip(inFile, outFile);
                segyUnzip.unzipFile();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        } else {
            String inputDir = null;
            String outputDir = null;
            String volumeName = "SOURCE_";
            String segyExtension = ".sgy";
            String seispegExtension = ".syz";
            long minVolume = Long.MIN_VALUE;
            long maxVolume = Long.MAX_VALUE;
            long volumeInc = 1L;
            long minFrame = Long.MIN_VALUE;
            long maxFrame = Long.MAX_VALUE;
            long frameInc = 1L;
            long minTrace = Long.MIN_VALUE;
            long maxTrace = Long.MAX_VALUE;
            long traceInc = 1L;
            long maxSample = Long.MAX_VALUE;
            boolean ignoreErrors = false;
            try {
                for (int i = 0; i < args.length; ++i) {
                    String s = args[i];
                    if (s.startsWith("inputDir=")) {
                        inputDir = s.substring("inputDir=".length(), s.length());
                        continue;
                    }
                    if (s.startsWith("outputDir=")) {
                        outputDir = s.substring("outputDir=".length(), s.length());
                        continue;
                    }
                    if (s.startsWith("volumeName=")) {
                        volumeName = s.substring("volumeName=".length(), s.length());
                        continue;
                    }
                    if (s.startsWith("segyExtension=")) {
                        segyExtension = s.substring("segyExtension=".length(), s.length());
                        continue;
                    }
                    if (s.startsWith("seispegExtension=")) {
                        seispegExtension = s.substring("seispegExtension=".length(), s.length());
                        continue;
                    }
                    if (s.startsWith("minVolume=")) {
                        s = s.substring("minVolume=".length(), s.length());
                        minVolume = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("maxVolume=")) {
                        s = s.substring("maxVolume=".length(), s.length());
                        maxVolume = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("volumeInc=")) {
                        s = s.substring("volumeInc=".length(), s.length());
                        volumeInc = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("minFrame=")) {
                        s = s.substring("minFrame=".length(), s.length());
                        minFrame = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("maxFrame=")) {
                        s = s.substring("maxFrame=".length(), s.length());
                        maxFrame = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("frameInc=")) {
                        s = s.substring("frameInc=".length(), s.length());
                        frameInc = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("minTrace=")) {
                        s = s.substring("minTrace=".length(), s.length());
                        minTrace = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("maxTrace=")) {
                        s = s.substring("maxTrace=".length(), s.length());
                        maxTrace = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("traceInc=")) {
                        s = s.substring("traceInc=".length(), s.length());
                        traceInc = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("maxSample=")) {
                        s = s.substring("maxSample=".length(), s.length());
                        maxSample = Long.parseLong(s);
                        continue;
                    }
                    if (s.startsWith("ignoreErrors=")) {
                        if (!(s = s.substring("ignoreErrors=".length(), s.length()).toLowerCase()).equals("true") && !s.equals("t") && !s.equals("yes") && !s.equals("y")) continue;
                        ignoreErrors = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Input argument '" + s + "' is not recognized - run with no args to see usage");
                }
                if (inputDir == null) {
                    throw new IllegalArgumentException("Input directory must be specified via 'inputDir=some_directory'");
                }
                if (outputDir == null) {
                    throw new IllegalArgumentException("Output directory must be specified via 'outputDir=some_directory'");
                }
                SegyUnzip segyUnzip = new SegyUnzip(inputDir, outputDir, volumeName, segyExtension, seispegExtension, minVolume, maxVolume, volumeInc, minFrame, maxFrame, frameInc, minTrace, maxTrace, traceInc, maxSample, ignoreErrors);
                segyUnzip.unzipAllFiles();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

