/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.util.Arrays;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayTraceIterator;

public class DistributedArrayStatistics {
    public static synchronized double[] getMinMaxSumMean(DistributedArray distributedArray, boolean excludeHardZeroes, String message) {
        boolean highlyVerbose = false;
        return DistributedArrayStatistics.getMinMaxSumMean(distributedArray, null, null, excludeHardZeroes, highlyVerbose, message);
    }

    public static synchronized double[] getMinMaxSumMean(DistributedArray distributedArray, Integer minPos2, Integer maxPos2, boolean excludeHardZeroes, boolean highlyVerbose, String message) {
        int i;
        int len = distributedArray.getShape()[0] * distributedArray.getElementCount();
        float[] buf = new float[len];
        DistributedArrayTraceIterator<float[]> traceIterator = new DistributedArrayTraceIterator<float[]>(distributedArray, buf);
        long totalTraceCount = 0L;
        long restrictedTraceCount = 0L;
        long deadTraceCount = 0L;
        long hardZeroCount = 0L;
        long infiniteCount = 0L;
        long outsideActiveSectionCount = 0L;
        long nonzeroesOutsideCount = 0L;
        long nanCount = 0L;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        double sum = 0.0;
        long nlive = 0L;
        while (traceIterator.hasNext()) {
            buf = traceIterator.next();
            int[] position = traceIterator.getPosition();
            ++totalTraceCount;
            if (minPos2 != null && position[2] < minPos2 || maxPos2 != null && position[2] > maxPos2) {
                ++outsideActiveSectionCount;
                for (int i2 = 0; i2 < buf.length; ++i2) {
                    float val = buf[i2];
                    if (val == 0.0f) continue;
                    ++nonzeroesOutsideCount;
                }
                continue;
            }
            ++restrictedTraceCount;
            long nlivePrevious = nlive;
            for (i = 0; i < buf.length; ++i) {
                float val = buf[i];
                if (excludeHardZeroes && val == 0.0f) {
                    ++hardZeroCount;
                    continue;
                }
                if (Float.isInfinite(val)) {
                    ++infiniteCount;
                    continue;
                }
                if (Float.isNaN(val)) {
                    ++nanCount;
                    continue;
                }
                if (val < min) {
                    min = val;
                }
                if (val > max) {
                    max = val;
                }
                sum += (double)val;
                ++nlive;
            }
            if (nlive == nlivePrevious) {
                ++deadTraceCount;
            }
            if (!highlyVerbose) continue;
            DistributedArrayStatistics.getMinMaxSumMean(buf, excludeHardZeroes, "pos[2], pos[1] = " + position[2] + ", " + position[1]);
        }
        double mean = sum / (double)nlive;
        double[] stats = new double[]{min, max, sum, mean};
        if (message != null) {
            System.out.println("\n" + message);
            System.out.println("    len = " + len);
            System.out.println("  shape = " + Arrays.toString(distributedArray.getShape()));
            System.out.println("           total trace count = " + totalTraceCount);
            System.out.println("      restricted trace count = " + restrictedTraceCount);
            System.out.println("outside active section count = " + outsideActiveSectionCount);
            System.out.println("     nonzeroes outside count = " + nonzeroesOutsideCount);
            System.out.println("            dead trace count = " + deadTraceCount);
            System.out.println("             hard zero count = " + hardZeroCount);
            System.out.println("              infinite count = " + infiniteCount);
            System.out.println("                   nan count = " + nanCount);
            for (i = 0; i < stats.length; ++i) {
                System.out.printf("%20.9f", stats[i]);
            }
            System.out.println();
        }
        return stats;
    }

    public static synchronized double[] getMinMaxSumMean(float[] buf, boolean excludeHardZeroes, String message) {
        double sum = 0.0;
        int nlive = 0;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        int hardZeroCount = 0;
        int infiniteCount = 0;
        int nanCount = 0;
        for (int i = 0; i < buf.length; ++i) {
            float val = buf[i];
            if (excludeHardZeroes && val == 0.0f) {
                ++hardZeroCount;
                continue;
            }
            if (Float.isInfinite(val)) {
                ++infiniteCount;
                continue;
            }
            if (Float.isNaN(val)) {
                ++nanCount;
                continue;
            }
            if (val < min) {
                min = val;
            }
            if (val > max) {
                max = val;
            }
            sum += (double)val;
            ++nlive;
        }
        double mean = sum / (double)nlive;
        double[] stats = new double[]{min, max, sum, mean};
        if (message != null) {
            System.out.printf(message + ": %4d %4d %4d %4d -> ", nlive, hardZeroCount, infiniteCount, nanCount);
            System.out.printf("%12.5f", stats[0]);
            System.out.printf("%12.5f", stats[1]);
            System.out.printf("%19.7f", stats[2]);
            System.out.printf("%19.7f", stats[3]);
            System.out.println();
        }
        return stats;
    }

    public static synchronized void formattedPrint(float[] buf, String message, String format) {
        System.out.print(message + ": ");
        for (int i = 0; i < buf.length; ++i) {
            System.out.printf(format, Float.valueOf(buf[i]));
        }
        System.out.println();
    }
}

