/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import junit.framework.TestCase;
import org.javaseis.io.ExtentPolicyFolder1;
import org.javaseis.io.ExtentPolicyRandom;
import org.javaseis.io.Seisio;
import org.javaseis.io.VirtualFolder;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualFoldersSS;
import org.javaseis.tests.TestUtil;

public class JTestVirtualFolders
extends TestCase {
    public void test1() throws Exception {
        String path = TestUtil.getDatasetPath("area1/line1/JTestVirtualFolders.js");
        System.out.println(path);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(path, "area1", "line1");
        System.out.println(vFolders.toString());
        String[] secondary = new String[vFolders.count() - 1];
        VirtualFolder[] folders = vFolders.getFolders();
        for (int i = 0; i < vFolders.count() - 1; ++i) {
            secondary[i] = folders[i].getPath();
        }
        String extraFolder = folders[vFolders.count() - 1].getPath();
        VirtualFoldersSS vFolders2 = new VirtualFoldersSS(path, secondary, new ExtentPolicyFolder1());
        System.out.println(vFolders2.toString());
        if (Seisio.isJavaSeis(path)) {
            JTestVirtualFolders.assertTrue((boolean)Seisio.delete(path));
            System.out.println("dataset existed and deleted");
        }
        Seisio seisio = Seisio.testFileStruct("JTestVirtualFolders", path, vFolders2, 12);
        seisio.close();
        Seisio sio = null;
        System.out.println("\nAdding folder");
        VirtualFolders.resolve(path, vFolders.getFolders());
        sio = new Seisio(path);
        sio.open("rw");
        VirtualFolders datasetFolders = sio.getVirtualFolders();
        JTestVirtualFolders.assertTrue((datasetFolders.count() == vFolders.count() ? 1 : 0) != 0);
        sio.close();
        sio = null;
        System.out.println("\nRemoving 1 unused folder");
        VirtualFolders.resolve(path, vFolders2.getFolders());
        sio = new Seisio(path);
        sio.open("rw");
        datasetFolders = sio.getVirtualFolders();
        JTestVirtualFolders.assertTrue((datasetFolders.count() == vFolders2.count() ? 1 : 0) != 0);
        sio.close();
        sio = null;
        System.out.println("\n Attempting to remove all folders.  Should retain 1 because it has extents");
        VirtualFolders.resolve(path, new VirtualFolder[0]);
        sio = new Seisio(path);
        sio.open("rw");
        datasetFolders = sio.getVirtualFolders();
        JTestVirtualFolders.assertTrue((datasetFolders.count() == 1 ? 1 : 0) != 0);
        sio.close();
        sio = null;
        System.out.println("*** org.javaseis.io.test.JTestVirtualFolders test1 SUCCESS");
    }

    public void test2() throws Exception {
        VirtualFolder[] folders;
        String path = TestUtil.getDatasetPath("area1/line1/JTestVirtualFolders2.js");
        System.out.println(path);
        if (Seisio.isJavaSeis(path)) {
            JTestVirtualFolders.assertTrue((boolean)Seisio.delete(path));
            System.out.println("dataset existed and deleted");
        }
        VirtualFoldersSS vFolders = new VirtualFoldersSS(path, TestUtil.getVirtualFolders(path, "area1", "line1").getSecondary(), new ExtentPolicyRandom());
        System.out.println(vFolders.toString());
        for (VirtualFolder v : folders = vFolders.getFolders()) {
            v.setAttribute(VirtualFolder.Attribute.READ_WRITE);
        }
        folders[0].setAttribute(VirtualFolder.Attribute.READ_WRITE);
        Seisio seisio = Seisio.testFileStruct("JTestVirtualFolders2", path, vFolders, 12);
        seisio.close();
        Seisio sio = null;
        sio = new Seisio(path);
        sio.open("rw");
        VirtualFolders datasetFolders = sio.getVirtualFolders();
        folders[0].setAttribute(VirtualFolder.Attribute.READ_WRITE);
        sio.close();
        sio = null;
        System.out.println("*** org.javaseis.io.test.JTestVirtualFolders test2 SUCCESS");
    }
}

