/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.javaseis.array.beta.FftNdLocal;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.fft.IFFT;
import org.javaseis.iterators.beta.IPositionIterator;
import org.junit.Assert;
import org.junit.Test;

public class JTestFftNdLocal {
    @Test
    public void test1D() {
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        List<int[]> list = this.getShapesList();
        for (int i = 0; i < list.size(); ++i) {
            this.fftHarness(1, list.get(i), pad);
        }
    }

    @Test
    public void test2D() {
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        List<int[]> list = this.getShapesList();
        for (int i = 0; i < list.size(); ++i) {
            this.fftHarness(2, list.get(i), pad);
        }
    }

    @Test
    public void test3D() {
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        List<int[]> list = this.getShapesList();
        for (int i = 0; i < list.size(); ++i) {
            this.fftHarness(3, list.get(i), pad);
        }
    }

    @Test
    public void test4D() {
        float[] pad0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] pad25 = new float[]{25.0f, 25.0f, 25.0f, 25.0f};
        float[] pad50 = new float[]{50.0f, 50.0f, 50.0f, 50.0f};
        float[] pad100 = new float[]{100.0f, 100.0f, 100.0f, 100.0f};
        List<int[]> list = this.getShapesList4D();
        for (int i = 0; i < list.size(); ++i) {
            this.fftHarness(4, list.get(i), pad0);
            this.fftHarness(4, list.get(i), pad25);
            this.fftHarness(4, list.get(i), pad50);
            this.fftHarness(4, list.get(i), pad100);
        }
    }

    private void fftHarness(int fftDimensions, int[] shape, float[] pad) {
        FftNdLocal fnd = new FftNdLocal(fftDimensions, shape, pad, IFFT.Type.REAL);
        int[] forwardShape = fnd.getForwardShape();
        IFlexArray<float[]> gma = FlexArray.createFloatArray(shape);
        int[] pos = new int[shape.length];
        PositionIterator pti = new PositionIterator(shape, pos, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
        Random r = new Random(12345L);
        while (pti.hasNext()) {
            pti.next();
            float[] trc = gma.getTrace(pos);
            for (int i = 0; i < shape[0]; ++i) {
                trc[i] = r.nextFloat();
            }
        }
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < forwardShape.length; ++i) {
            arraySize *= (double)forwardShape[i];
        }
        double startTime = JTestFftNdLocal.getTime();
        fnd.forward(gma);
        fnd.inverse(gma);
        double elapsedTime = JTestFftNdLocal.getTime() - startTime;
        this.logInfo(fftDimensions + "D FFT Forward/Inverse : size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(forwardShape));
        pti.reset();
        r.setSeed(12345L);
        while (pti.hasNext()) {
            pti.next();
            float[] trc = gma.getTrace(pos);
            for (int i = 0; i < shape[0]; ++i) {
                float f1 = trc[i];
                float f2 = r.nextFloat();
                Assert.assertEquals((String)("frequency slice " + i + Arrays.toString(pos)), (double)f1, (double)f2, (double)1.0E-6f);
            }
        }
    }

    private List<int[]> getShapesList() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        list.add(new int[]{16, 8, 5});
        list.add(new int[]{13, 17, 7});
        return list;
    }

    private List<int[]> getShapesList4D() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        list.add(new int[]{39, 29, 15, 21});
        return list;
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    private void logInfo(String message) {
        System.out.println(message);
    }
}

