/*
 * Decompiled with CFR 0.152.
 */
package zmq.poll;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.poll.IPollEvents;
import zmq.util.Clock;
import zmq.util.MultiMap;

abstract class PollerBase
implements Runnable {
    private final AtomicInteger load;
    private final MultiMap<Long, TimerInfo> timers;
    protected final Thread worker;
    private boolean changed;

    protected PollerBase(String name) {
        this.worker = this.createWorker(name);
        this.load = new AtomicInteger(0);
        this.timers = new MultiMap();
    }

    Thread createWorker(String name) {
        Thread worker = new Thread((Runnable)this, name);
        worker.setDaemon(true);
        return worker;
    }

    long clock() {
        return Clock.nowMS();
    }

    final boolean isEmpty() {
        return this.timers.isEmpty();
    }

    public final int getLoad() {
        return this.load.get();
    }

    protected void adjustLoad(int amount) {
        this.load.addAndGet(amount);
    }

    public void addTimer(long timeout, IPollEvents sink, int id) {
        assert (Thread.currentThread() == this.worker);
        long expiration = this.clock() + timeout;
        TimerInfo info = new TimerInfo(sink, id);
        this.timers.insert(expiration, info);
        this.changed = true;
    }

    public void cancelTimer(IPollEvents sink, int id) {
        assert (Thread.currentThread() == this.worker);
        TimerInfo copy = new TimerInfo(sink, id);
        TimerInfo timerInfo = this.timers.find(copy);
        if (timerInfo != null) {
            timerInfo.cancelled = true;
        }
    }

    protected long executeTimers() {
        assert (Thread.currentThread() == this.worker);
        this.changed = false;
        if (this.timers.isEmpty()) {
            return 0L;
        }
        long current = this.clock();
        for (Map.Entry<TimerInfo, Long> entry : this.timers.entries()) {
            TimerInfo timerInfo = entry.getKey();
            if (timerInfo.cancelled) {
                this.timers.remove((Long)((Comparable)entry.getValue()), timerInfo);
                continue;
            }
            Long key = entry.getValue();
            if (key > current) {
                return key - current;
            }
            this.timers.remove(key, timerInfo);
            timerInfo.sink.timerEvent(timerInfo.id);
        }
        for (Map.Entry<TimerInfo, Long> entry : this.timers.entries()) {
            Long key = entry.getValue();
            if (this.timers.hasValues(key)) continue;
            this.timers.remove(key);
        }
        if (this.changed) {
            return this.executeTimers();
        }
        return 0L;
    }

    private static final class TimerInfo {
        private final IPollEvents sink;
        private final int id;
        private boolean cancelled;

        public TimerInfo(IPollEvents sink, int id) {
            assert (sink != null);
            this.sink = sink;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + this.sink.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof TimerInfo)) {
                return false;
            }
            TimerInfo that = (TimerInfo)other;
            return this.id == that.id && this.sink.equals(that.sink);
        }

        public String toString() {
            return "TimerInfo [id=" + this.id + ", sink=" + this.sink + "]";
        }
    }
}

