/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.interfaces.ECParams;
import javax.security.spec.CurveOIDParameterSpec;

public abstract class ECParameterSpec
extends CurveOIDParameterSpec
implements AlgorithmParameterSpec,
ECParams {
    private static final long serialVersionUID = -2071633733885415248L;
    private byte[] b = null;
    private byte[] c = null;
    private byte[] d = null;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g = null;
    private int h = 0;
    private int i = 0;

    public ECParameterSpec() {
    }

    protected ECParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string) {
        super(string);
        this.h = n3;
        int n4 = (n3 + 7) / 8;
        this.b = this.a(byArray, 0, byArray.length, n4);
        this.c = this.a(byArray2, 0, byArray2.length, n4);
        this.d = byArray3 != null ? this.a(byArray3, 0, byArray3.length, -1) : null;
        this.e = this.a(byArray4, 0, byArray4.length, n4);
        this.f = this.a(byArray5, 0, byArray5.length, n4);
        this.g = this.a(byArray6, 0, byArray6.length, -1);
        this.i = n2;
    }

    public int getSize() {
        return this.h;
    }

    public int getOrderSizeBytes() {
        return this.g.length;
    }

    public byte[] getA() {
        return this.a(this.b, 0, this.b.length, -1);
    }

    public byte[] getB() {
        return this.a(this.c, 0, this.c.length, -1);
    }

    public byte[] getSeed() {
        if (this.d == null) {
            return null;
        }
        return this.a(this.d, 0, this.d.length, -1);
    }

    public byte[] getGx() {
        return this.a(this.e, 0, this.e.length, -1);
    }

    public byte[] getGy() {
        return this.a(this.f, 0, this.f.length, -1);
    }

    public byte[] getPointOrder() {
        return this.a(this.g, 0, this.g.length, -1);
    }

    public int getCofactor() {
        return this.i;
    }

    protected final byte[] a(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null || byArray.length - n2 < n3) {
            throw new IllegalArgumentException("parameter(s) relating to input buffer invalid");
        }
        if (n4 == -1) {
            n4 = n3;
        }
        while (n3 > 0 && byArray[n2] == 0) {
            ++n2;
            --n3;
        }
        if (n3 == 0) {
            return new byte[n4];
        }
        if (n3 > n4) {
            throw new IllegalArgumentException("output buffer is too small.");
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, n4 - n3, n3);
        return byArray2;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.b, (byte)0);
        Arrays.fill(this.c, (byte)0);
        if (this.d != null) {
            Arrays.fill(this.d, (byte)0);
        }
        Arrays.fill(this.e, (byte)0);
        Arrays.fill(this.f, (byte)0);
        Arrays.fill(this.g, (byte)0);
        this.h = 0;
        this.i = 0;
        super.zeroize();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.g);
        objectOutputStream.writeInt(this.h);
        objectOutputStream.writeInt(this.i);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.b = (byte[])objectInputStream.readObject();
        this.c = (byte[])objectInputStream.readObject();
        this.d = (byte[])objectInputStream.readObject();
        this.e = (byte[])objectInputStream.readObject();
        this.f = (byte[])objectInputStream.readObject();
        this.g = (byte[])objectInputStream.readObject();
        this.h = objectInputStream.readInt();
        this.i = objectInputStream.readInt();
    }
}

