/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.IDLCKeyGen;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public final class DSA
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = 6481365093410072202L;
    private BigInteger a;
    private BigInteger b;
    private CryptoTransform c;
    private byte[] d;
    private byte[][] e = new byte[4][];
    private CryptoCodec f;
    private int k;
    private int l;
    private int m;

    public DSA() {
        super("DSA");
        this.setHashMode(this.getHashMode());
        this.k = SystemConfig.getConfig().getFormat();
        this.l = SystemConfig.getConfig().getConformance();
        this.f = CryptoCodec.getInstance("DSA", this.k);
    }

    public void reset() {
        int n2;
        super.reset();
        if (this.c != null) {
            this.c.reset();
        }
        if (this.d != null) {
            n2 = 0;
            while (n2 < this.d.length) {
                this.d[n2++] = 0;
            }
            this.d = null;
        }
        for (n2 = 0; n2 < this.e.length; ++n2) {
            if (this.e[n2] == null) continue;
            this.e[n2] = null;
        }
        this.a = null;
        this.b = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n2, objectArray, random);
        if (objectArray != null && (n2 == 1 && random != null || n2 == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params: wrong mode");
        }
        if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null || objectArray[3] == null) {
            this.reset();
            throw new IllegalArgumentException("wrong params: p, g, q, and pub key cannot be null");
        }
        this.m = ((byte[])objectArray[1]).length;
        this.e[0] = (byte[])objectArray[0];
        this.e[1] = (byte[])objectArray[1];
        this.e[2] = (byte[])objectArray[2];
        this.e[3] = (byte[])objectArray[3];
        try {
            this.a = new BigInteger(1, this.e[0]);
            this.b = new BigInteger(1, this.e[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("cannot calculate signature.");
        }
        if (this.getHashMode() != 1) {
            String string;
            if (objectArray.length < 5 || objectArray[4] == null) {
                string = "SHA-1";
            } else {
                String string2 = (String)objectArray[4];
                if (string2.equals("SHA1") || string2.equals("SHA-1")) {
                    string = "SHA-1";
                } else if (string2.equals("SHA224") || string2.equals("SHA-224")) {
                    string = "SHA-224";
                } else if (string2.equals("SHA256") || string2.equals("SHA-256")) {
                    string = "SHA-256";
                } else if (string2.equals("SHA384") || string2.equals("SHA-384")) {
                    string = "SHA-384";
                } else if (string2.equals("SHA512") || string2.equals("SHA-512")) {
                    string = "SHA-512";
                } else {
                    throw new IllegalArgumentException("message digest algorithm " + string2 + " is not supported with DSA");
                }
            }
            this.c = (CryptoTransform)CryptoManager.getInstance(TYPE, string);
            this.c.init(5, null, random);
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (this.h != 1 && this.h != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.h == 2) {
            return 0;
        }
        if (this.k == 10) {
            return 2 * this.m;
        }
        if (this.k == 11) {
            return 2 * this.m + 9;
        }
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.h != 1 && this.h != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.getHashMode() == 1) {
                this.d = new byte[n3];
                System.arraycopy(byArray, n2, this.d, 0, n3);
            } else {
                this.c.transform(byArray, n2, n3, false);
            }
        }
        if (!bl || bl && this.h == 2) {
            return 0;
        }
        BigInteger bigInteger = new BigInteger(1, this.a()).mod(this.b);
        IDLCKeyGen iDLCKeyGen = new IDLCKeyGen();
        ((CryptoTransform)iDLCKeyGen).init(5, new Object[]{this.e[0], this.e[1], this.e[2]}, this.g);
        Object[] objectArray = (Object[])((CryptoTransform)iDLCKeyGen).transformToObject(null, 0, 0, true);
        BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[0]).mod(this.b);
        BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[1]).mod(this.a).mod(this.b);
        BigInteger bigInteger4 = new BigInteger(1, this.e[3]).mod(this.b);
        BigInteger bigInteger5 = bigInteger2.modInverse(this.b).multiply(bigInteger4.multiply(bigInteger3).add(bigInteger)).mod(this.b);
        byte[] byArray3 = bigInteger3.toByteArray();
        byte[] byArray4 = new byte[this.m];
        if (this.m < byArray3.length) {
            System.arraycopy(byArray3, byArray3.length - this.m, byArray4, 0, this.m);
        } else if (this.m > byArray3.length) {
            System.arraycopy(byArray3, 0, byArray4, this.m - byArray3.length, byArray3.length);
        } else if (this.m == byArray3.length) {
            byArray4 = byArray3;
        }
        byte[] byArray5 = bigInteger5.toByteArray();
        byte[] byArray6 = new byte[this.m];
        if (this.m < byArray5.length) {
            System.arraycopy(byArray5, byArray5.length - this.m, byArray6, 0, this.m);
        } else if (this.m > byArray5.length) {
            System.arraycopy(byArray5, 0, byArray6, this.m - byArray5.length, byArray5.length);
        } else if (this.m == byArray5.length) {
            byArray6 = byArray5;
        }
        this.f.init(1, null);
        this.f.codecToObject(byArray4, 0, byArray4.length, false);
        Object[] objectArray2 = this.f.codecToObject(byArray6, 0, byArray6.length, true);
        byte[] byArray7 = (byte[])objectArray2[1];
        if (byArray2.length - n4 < byArray7.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray7, 0, byArray2, n4, byArray7.length);
        return byArray7.length;
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        if (this.h != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        try {
            this.f.init(2, null);
            Object[] objectArray = this.f.codecToObject(byArray, n2, byArray.length, true);
            BigInteger bigInteger = new BigInteger(1, this.a()).mod(this.b);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[1]).mod(this.b);
            BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[2]).mod(this.b);
            BigInteger bigInteger4 = bigInteger3.modInverse(this.b);
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
            BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
            BigInteger bigInteger7 = new BigInteger(1, this.e[2]).mod(this.a).modPow(bigInteger5, this.a).multiply(new BigInteger(1, this.e[3]).mod(this.a).modPow(bigInteger6, this.a)).mod(this.a);
            BigInteger bigInteger8 = bigInteger7.mod(this.b);
            return bigInteger8.equals(bigInteger2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] a() {
        if (this.getHashMode() == 2) {
            this.d = this.c.transform(null, 0, 0, true);
        }
        return this.d;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeInt(this.k);
        objectOutputStream.writeInt(this.l);
        objectOutputStream.writeInt(this.m);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (BigInteger)objectInputStream.readObject();
        this.b = (BigInteger)objectInputStream.readObject();
        this.c = (CryptoTransform)objectInputStream.readObject();
        this.d = (byte[])objectInputStream.readObject();
        this.e = (byte[][])objectInputStream.readObject();
        this.f = (CryptoCodec)objectInputStream.readObject();
        this.k = objectInputStream.readInt();
        this.l = objectInputStream.readInt();
        this.m = objectInputStream.readInt();
    }
}

